/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.action;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.j2ee.persistence.action.UseEntityManagerAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class PersistenceActionGroup
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
    }

    public String getName() {
        return NbBundle.getMessage(PersistenceActionGroup.class, (String)"CTL_PersistenceActionGroup");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static final SystemAction[] grouped() {
        return new SystemAction[]{SystemAction.get(UseEntityManagerAction.class)};
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        return PersistenceActionGroup.hasPersistenceContext(activatedNodes[0]);
    }

    public JMenuItem getPopupPresenter() {
        boolean oneNodeSelected;
        Node[] activatedNodes = this.getActivatedNodes();
        boolean bl = oneNodeSelected = activatedNodes.length == 1;
        if (oneNodeSelected && PersistenceActionGroup.hasPersistenceContext(activatedNodes[0])) {
            return new LazyMenu();
        }
        JMenuItem i = super.getPopupPresenter();
        i.setVisible(false);
        return i;
    }

    private static boolean hasPersistenceContext(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return PersistenceScope.getPersistenceScope((FileObject)dataObject.getPrimaryFile()) != null;
        }
        return false;
    }

    private final class LazyMenu
    extends JMenu {
        public LazyMenu() {
            super(PersistenceActionGroup.this.getName());
        }

        public JPopupMenu getPopupMenu() {
            if (this.getItemCount() == 0) {
                SystemAction[] grouped = PersistenceActionGroup.grouped();
                for (int i = 0; i < grouped.length; ++i) {
                    Object action = grouped[i];
                    if (action == null && this.getItemCount() != 0) {
                        this.addSeparator();
                        continue;
                    }
                    if (action instanceof ContextAwareAction) {
                        action = ((ContextAwareAction)action).createContextAwareInstance(Utilities.actionsGlobalContext());
                    }
                    if (!(action instanceof Presenter.Popup)) continue;
                    this.add(((Presenter.Popup)action).getPopupPresenter());
                }
            }
            return super.getPopupMenu();
        }
    }
}

