/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.Utils;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Properties;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.HibernateProvider;
import org.netbeans.modules.j2ee.persistence.provider.KodoProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ToplinkProvider;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderUtil {
    public static final Provider HIBERNATE_PROVIDER = new HibernateProvider();
    public static final Provider TOPLINK_PROVIDER = new ToplinkProvider();
    public static final Provider KODO_PROVIDER = new KodoProvider();
    public static final Provider DEFAULT_PROVIDER = new DefaultProvider();
    private static final Provider[] PROVIDERS = new Provider[]{HIBERNATE_PROVIDER, TOPLINK_PROVIDER, KODO_PROVIDER};

    private ProviderUtil() {
    }

    public static Provider getProvider(Library library) {
        for (int i = 0; i < PROVIDERS.length; ++i) {
            if (!Utils.containsClass((Library)library, (String)PROVIDERS[i].getProviderClass())) continue;
            return PROVIDERS[i];
        }
        return null;
    }

    public static Provider getProvider(String providerClass, Project project) {
        if (null == providerClass || "".equals(providerClass.trim())) {
            return ProviderUtil.getContainerManagedProvider(project);
        }
        for (int i = 0; i < PROVIDERS.length; ++i) {
            if (!PROVIDERS[i].getProviderClass().equals(providerClass.trim())) continue;
            return PROVIDERS[i];
        }
        return DEFAULT_PROVIDER;
    }

    public static Provider getContainerManagedProvider(Project project) {
        String serverInstanceId;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String string = serverInstanceId = j2eeModuleProvider != null ? j2eeModuleProvider.getServerInstanceID() : null;
        if (serverInstanceId == null) {
            return DEFAULT_PROVIDER;
        }
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceId);
        if (platform == null) {
            return DEFAULT_PROVIDER;
        }
        if (platform.getSupportedSpecVersions(j2eeModuleProvider.getJ2eeModule().getModuleType()).contains("1.5")) {
            if ("J2EE".equals(j2eeModuleProvider.getServerID())) {
                return TOPLINK_PROVIDER;
            }
            if ("JBoss4".equals(j2eeModuleProvider.getServerID())) {
                return HIBERNATE_PROVIDER;
            }
        }
        return DEFAULT_PROVIDER;
    }

    public static DatabaseConnection getConnection(PersistenceUnit pu) {
        if (pu == null || pu.getProperties() == null) {
            return null;
        }
        String url = null;
        String driver = null;
        String username = null;
        Property[] properties = pu.getProperties().getProperty2();
        Provider provider = ProviderUtil.getProvider(pu);
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i].getName();
            if (key == null) continue;
            if (key.equals(provider.getJdbcUrl())) {
                url = properties[i].getValue();
                continue;
            }
            if (key.equals(provider.getJdbcDriver())) {
                driver = properties[i].getValue();
                continue;
            }
            if (!key.equals(provider.getJdbcUsername())) continue;
            username = properties[i].getValue();
        }
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            DatabaseConnection c = connections[i];
            if (!c.getDatabaseURL().equals(url) || !c.getDriverClass().equals(driver) || !c.getUser().equals(username)) continue;
            return c;
        }
        return null;
    }

    public static String getDatasourceName(PersistenceUnit pu) {
        String datasourceName = pu.getJtaDataSource();
        if (datasourceName == null) {
            datasourceName = pu.getNonJtaDataSource();
        }
        return datasourceName;
    }

    public static Library getLibrary(PersistenceUnit pu) {
        return ProviderUtil.getLibrary(ProviderUtil.getProvider(pu));
    }

    public static Library getLibrary(Provider provider) {
        List<Library> libraries = ProviderUtil.createLibraries();
        if (provider != null) {
            for (Library library : libraries) {
                if (!provider.getProviderClass().equals(ProviderUtil.extractProvider(library))) continue;
                return library;
            }
        }
        return null;
    }

    public static void setTableGeneration(PersistenceUnit persistenceUnit, String tableGenerationStrategy, Project project) {
        String providerClass = persistenceUnit.getProvider();
        Provider provider = ProviderUtil.getProvider(providerClass, project);
        ProviderUtil.setTableGeneration(persistenceUnit, tableGenerationStrategy, provider);
    }

    public static void setTableGeneration(PersistenceUnit persistenceUnit, String tableGenerationStrategy, Provider provider) {
        Property existing;
        Property tableGenerationProperty = provider.getTableGenerationProperty(tableGenerationStrategy);
        Properties properties = persistenceUnit.getProperties();
        if (properties == null) {
            properties = persistenceUnit.newProperties();
            persistenceUnit.setProperties(properties);
        }
        if ((existing = ProviderUtil.getProperty(properties.getProperty2(), provider.getTableGenerationPropertyName())) != null && tableGenerationProperty == null) {
            properties.removeProperty2(existing);
        } else if (existing != null && tableGenerationProperty != null) {
            existing.setValue(tableGenerationProperty.getValue());
        } else if (tableGenerationProperty != null) {
            properties.addProperty2(tableGenerationProperty);
        }
    }

    public static void setProvider(PersistenceUnit persistenceUnit, Provider provider, DatabaseConnection connection, String tableGenerationStrategy) {
        ProviderUtil.removeProviderProperties(persistenceUnit);
        persistenceUnit.setProvider(provider.getProviderClass());
        ProviderUtil.setDatabaseConnection(persistenceUnit, connection);
        ProviderUtil.setTableGeneration(persistenceUnit, tableGenerationStrategy, provider);
    }

    public static void removeProviderProperties(PersistenceUnit persistenceUnit) {
        Provider old = ProviderUtil.getProvider(persistenceUnit);
        Property[] properties = ProviderUtil.getProperties(persistenceUnit);
        if (old != null) {
            for (int i = 0; i < properties.length; ++i) {
                Property each = properties[i];
                if (!old.getPropertyNames().contains(each.getName())) continue;
                persistenceUnit.getProperties().removeProperty2(each);
            }
        }
        persistenceUnit.setProvider(null);
    }

    public static PersistenceUnit buildPersistenceUnit(String name, Provider provider, DatabaseConnection connection) {
        PersistenceUnit persistenceUnit = new PersistenceUnit();
        persistenceUnit.setName(name);
        persistenceUnit.setProvider(provider.getProviderClass());
        Properties properties = persistenceUnit.newProperties();
        Map<String, String> connectionProperties = provider.getConnectionPropertiesMap(connection);
        for (String propertyName : connectionProperties.keySet()) {
            Property property = properties.newProperty();
            property.setName(propertyName);
            property.setValue(connectionProperties.get(propertyName));
            properties.addProperty2(property);
        }
        Map defaultProperties = provider.getDefaultVendorSpecificProperties();
        for (String propertyName : defaultProperties.keySet()) {
            Property property = properties.newProperty();
            property.setName(propertyName);
            property.setValue((String)defaultProperties.get(propertyName));
            properties.addProperty2(property);
        }
        persistenceUnit.setProperties(properties);
        return persistenceUnit;
    }

    public static void setDatabaseConnection(PersistenceUnit persistenceUnit, DatabaseConnection connection) {
        Provider provider = ProviderUtil.getProvider(persistenceUnit);
        Property[] properties = ProviderUtil.getProperties(persistenceUnit);
        Map<String, String> propertiesMap = provider.getConnectionPropertiesMap(connection);
        for (String name : propertiesMap.keySet()) {
            String value;
            Property property = ProviderUtil.getProperty(properties, name);
            if (property == null) {
                if (persistenceUnit.getProperties() == null) {
                    persistenceUnit.setProperties(persistenceUnit.newProperties());
                }
                property = persistenceUnit.getProperties().newProperty();
                property.setName(name);
                persistenceUnit.getProperties().addProperty2(property);
            }
            if ((value = propertiesMap.get(name)) == null) {
                value = "";
            }
            property.setValue(value);
        }
    }

    public static Property[] getProperties(PersistenceUnit persistenceUnit) {
        if (persistenceUnit.getProperties() != null) {
            return persistenceUnit.getProperties().getProperty2();
        }
        return new Property[0];
    }

    private static Property getProperty(Property[] properties, String propertyName) {
        if (null == properties) {
            return null;
        }
        for (int i = 0; i < properties.length; ++i) {
            Property each = properties[i];
            if (each.getName() == null || !each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public static Property getProperty(PersistenceUnit persistenceUnit, String propertyName) {
        if (persistenceUnit.getProperties() == null) {
            return null;
        }
        return ProviderUtil.getProperty(persistenceUnit.getProperties().getProperty2(), propertyName);
    }

    public static Provider getProvider(PersistenceUnit persistenceUnit) {
        for (int i = 0; i < PROVIDERS.length; ++i) {
            if (!PROVIDERS[i].getProviderClass().equals(persistenceUnit.getProvider())) continue;
            return PROVIDERS[i];
        }
        return DEFAULT_PROVIDER;
    }

    public static boolean isValid(PUDataObject puDataObject) {
        return null == puDataObject ? false : puDataObject.parseDocument();
    }

    public static PersistenceUnit[] getPersistenceUnits(PUDataObject puDataObject) {
        if (puDataObject.getPersistence() == null) {
            return new PersistenceUnit[0];
        }
        return puDataObject.getPersistence().getPersistenceUnit();
    }

    public static void renameManagedClass(PersistenceUnit persistenceUnit, String newName, String oldName, PUDataObject dataObject) {
        dataObject.removeClass(persistenceUnit, oldName);
        dataObject.addClass(persistenceUnit, newName);
    }

    public static void removeManagedClass(PersistenceUnit persistenceUnit, String clazz, PUDataObject dataObject) {
        dataObject.removeClass(persistenceUnit, clazz);
    }

    public static void addManagedClass(PersistenceUnit persistenceUnit, String clazz, PUDataObject dataObject) {
        dataObject.addClass(persistenceUnit, clazz);
    }

    public static void addPersistenceUnit(PersistenceUnit persistenceUnit, Project project) {
        PUDataObject pud = ProviderUtil.getPUDataObject(project);
        pud.addPersistenceUnit(persistenceUnit);
        pud.save();
    }

    public static PUDataObject getPUDataObject(FileObject fo) {
        if (fo == null) {
            throw new IllegalArgumentException("Called PUDataObject#getPUDataObject with null FileObject param");
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        assert (dataObject instanceof PUDataObject) : "Got invalid data object: " + dataObject;
        return (PUDataObject)dataObject;
    }

    public static PUDataObject getPUDataObject(Project project) {
        FileObject puFileObject = ProviderUtil.getDDFile(project);
        if (puFileObject == null) {
            puFileObject = ProviderUtil.createPersistenceDDFile(project);
        }
        return ProviderUtil.getPUDataObject(puFileObject);
    }

    private static FileObject createPersistenceDDFile(Project project) {
        final FileObject[] dd = new FileObject[1];
        try {
            final FileObject persistenceLocation = PersistenceLocation.createLocation((Project)project);
            persistenceLocation.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    try {
                        dd[0] = FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-j2ee-persistence/persistence-1.0.xml"), (FileObject)persistenceLocation, (String)"persistence");
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return dd[0];
    }

    public static boolean persistenceExists(Project project) {
        if (ProviderUtil.getDDFile(project) == null) {
            return false;
        }
        PUDataObject pud = ProviderUtil.getPUDataObject(project);
        return pud.getPersistence().getPersistenceUnit().length > 0;
    }

    public static FileObject getDDFile(Project project) {
        int i = 0;
        PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes(project);
        if (i < persistenceScopes.length) {
            return persistenceScopes[i].getPersistenceXml();
        }
        return null;
    }

    public static List<Library> createLibraries() {
        ArrayList<Library> providerLibs = new ArrayList<Library>();
        Library[] libs = LibraryManager.getDefault().getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            if (!Utils.containsClass((Library)libs[i], (String)"javax.persistence.EntityManager") || ProviderUtil.extractProvider(libs[i]) == null) continue;
            providerLibs.add(libs[i]);
        }
        Collections.sort(providerLibs, new Comparator(){

            public int compare(Object o1, Object o2) {
                assert (o1 instanceof Library && o2 instanceof Library);
                String name1 = ((Library)o1).getDisplayName();
                String name2 = ((Library)o2).getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return providerLibs;
    }

    public static List<Provider> getProvidersFromLibraries() {
        ArrayList<Provider> providerLibs = new ArrayList<Provider>();
        Library[] libs = LibraryManager.getDefault().getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            if (!Utils.containsClass((Library)libs[i], (String)"javax.persistence.EntityManager") || ProviderUtil.extractProvider(libs[i]) == null) continue;
            providerLibs.add(ProviderUtil.getProvider(libs[i]));
        }
        Collections.sort(providerLibs, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((Provider)o1).getDisplayName();
                String name2 = ((Provider)o2).getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return providerLibs;
    }

    private static String extractProvider(Library library) {
        for (int i = 0; i < PROVIDERS.length; ++i) {
            if (!Utils.containsClass((Library)library, (String)PROVIDERS[i].getProviderClass())) continue;
            return PROVIDERS[i].getProviderClass();
        }
        return null;
    }

    public static Provider[] getAllProviders() {
        return new Provider[]{DEFAULT_PROVIDER, TOPLINK_PROVIDER, HIBERNATE_PROVIDER, KODO_PROVIDER};
    }

    public static boolean makePortableIfPossible(Project project, PersistenceUnit persistenceUnit) {
        if (org.netbeans.modules.j2ee.persistence.wizard.Util.isJavaSE(project)) {
            return false;
        }
        Provider defaultProvider = ProviderUtil.getContainerManagedProvider(project);
        if (defaultProvider.getProviderClass().equals(persistenceUnit.getProvider()) && persistenceUnit.getProperties().sizeProperty2() == 0) {
            persistenceUnit.setProvider(null);
            return true;
        }
        return false;
    }

    public static boolean isValidServerInstanceOrNone(Project project) {
        if (project == null) {
            throw new NullPointerException("Passed null project paramater to ProviderUtil#isValidServerInstanceOrNone");
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return true;
        }
        return Util.isValidServerInstance((J2eeModuleProvider)j2eeModuleProvider);
    }
}

