/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.common.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardDescriptor;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class EntityWizard
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private EntityWizardDescriptor ejbPanel;
    private WizardDescriptor wiz;
    private SourceGroup[] sourceGroups;

    public static EntityWizard create() {
        return new EntityWizard();
    }

    public String name() {
        return NbBundle.getMessage(EntityWizard.class, (String)"LBL_EntityEJBWizardTitle");
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        this.sourceGroups = Util.getJavaSourceGroups(project);
        this.ejbPanel = new EntityWizardDescriptor();
        ValidatingPanel p = new ValidatingPanel(JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])this.sourceGroups, (WizardDescriptor.Panel)this.ejbPanel, (boolean)true));
        this.panels = new WizardDescriptor.Panel[]{p};
        Util.mergeSteps(this.wiz, this.panels, null);
    }

    public Set instantiate() throws IOException {
        if (this.ejbPanel.getPersistenceUnit() != null) {
            ProviderUtil.addPersistenceUnit(this.ejbPanel.getPersistenceUnit(), Templates.getProject((WizardDescriptor)this.wiz));
        }
        FileObject result = EntityWizard.generateEntity(Templates.getTargetFolder((WizardDescriptor)this.wiz), Templates.getTargetName((WizardDescriptor)this.wiz), this.ejbPanel.getPrimaryKeyClassName(), this.sourceGroups, false);
        return Collections.singleton(result);
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateEntity(FileObject targetFolder, String targetName, String primaryKeyClassName, SourceGroup[] sourceGroups, boolean isAccessProperty) {
        PUDataObject pudo;
        PersistenceUnit[] pu;
        JavaClass javaClass = null;
        boolean rollback = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            javaClass = JMIGenerationUtil.createEntityClass((FileObject)targetFolder, (String)targetName);
            JMIGenerationUtil.addInterface((JavaClass)javaClass, (String)"java.io.Serializable");
            Annotation entityAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.Entity", (List)Collections.EMPTY_LIST);
            javaClass.getAnnotations().add(entityAnnotation);
            Annotation idAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.Id", (List)Collections.EMPTY_LIST);
            AttributeValue strategyAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"strategy", (String)"javax.persistence.GenerationType", (String)"AUTO");
            Annotation generatedValueAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.GeneratedValue", Collections.singletonList(strategyAttibuteValue));
            String memberName = "id";
            String capitalizedMemberName = "Id";
            Field idField = JMIGenerationUtil.createField((Element)javaClass, (String)memberName, (int)2, (String)primaryKeyClassName);
            List features = javaClass.getFeatures();
            features.add(0, idField);
            Method getter = JMIGenerationUtil.createGetterMethod((String)memberName, (String)capitalizedMemberName, (String)primaryKeyClassName, (JavaClass)javaClass);
            List addAnnotationsList = isAccessProperty ? getter.getAnnotations() : idField.getAnnotations();
            addAnnotationsList.add(idAnnotation);
            addAnnotationsList.add(generatedValueAnnotation);
            features.add(getter);
            features.add(JMIGenerationUtil.createSetterMethod((String)memberName, (String)capitalizedMemberName, (String)primaryKeyClassName, (JavaClass)javaClass));
            List<Field> idFieldList = Collections.singletonList(idField);
            Method hashCodeMethod = JMIGenerationUtil.createHashCodeMethod((JavaClass)javaClass, idFieldList);
            features.add(hashCodeMethod);
            Method equalsMethod = JMIGenerationUtil.createEntityEqualsMethod((JavaClass)javaClass, idFieldList);
            features.add(equalsMethod);
            Method toString = JMIGenerationUtil.createToStringMethod((JavaClass)javaClass, idFieldList);
            features.add(toString);
            rollback = false;
        }
        catch (DataObjectNotFoundException dex) {
            ErrorManager.getDefault().notify((Throwable)dex);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        finally {
            JavaModel.getJavaRepository().endTrans(rollback);
        }
        FileObject fo = javaClass == null ? null : JavaModel.getFileObject((Resource)javaClass.getResource());
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        if (fo != null && !Util.isSupportedJavaEEVersion(project) && ProviderUtil.getDDFile(project) != null && (pu = (pudo = ProviderUtil.getPUDataObject(project)).getPersistence().getPersistenceUnit()).length == 1) {
            pudo.addClass(pu[0], javaClass.getName());
        }
        return fo;
    }

    private static final class ValidatingPanel
    extends DelegatingWizardDescriptorPanel {
        public ValidatingPanel(WizardDescriptor.Panel delegate) {
            super(delegate);
        }

        public boolean isValid() {
            if (!ProviderUtil.isValidServerInstanceOrNone(this.getProject())) {
                this.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_MissingServer"));
                return false;
            }
            return super.isValid();
        }
    }
}

