/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private PersistenceUnitWizardPanelDS p;
    private PersistenceUnitWizardPanelJdbc jdbcPanel;
    private PersistenceUnitWizardPanel panel;
    private List changeListeners = new ArrayList();
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private boolean isContainerManaged;
    private static String ERROR_MSG_KEY = "WizardPanel_errorMessage";

    public PersistenceUnitWizardDescriptor(Project project) {
        this.project = project;
        this.isContainerManaged = Util.isSupportedJavaEEVersion(project);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public Component getComponent() {
        if (this.panel == null) {
            if (this.isContainerManaged) {
                this.p = new PersistenceUnitWizardPanelDS(this.project, this, true);
                this.panel = this.p;
            } else {
                this.jdbcPanel = new PersistenceUnitWizardPanelJdbc(this.project, this, true);
                this.panel = this.jdbcPanel;
            }
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        PersistenceUnitWizardDescriptor.this.stateChanged(null);
                    }
                }
            });
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(EntityWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_MissingServer"));
            return false;
        }
        if (this.panel != null && !this.panel.isValidPanel()) {
            if (!this.panel.isNameUnique()) {
                this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
            }
            return false;
        }
        this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)" ");
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void storeSettings(Object settings) {
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        List list = this.changeListeners;
        synchronized (list) {
            it = new HashSet(this.changeListeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    String getPersistenceUnitName() {
        return this.panel.getPersistenceUnitName();
    }

    Library getPersistenceLibrary() {
        return this.jdbcPanel == null ? null : this.jdbcPanel.getPersistenceLibrary();
    }

    DatabaseConnection getPersistenceConnection() {
        return this.jdbcPanel == null ? null : this.jdbcPanel.getPersistenceConnection();
    }

    String getDatasource() {
        return this.p == null ? null : this.p.getDatasource();
    }

    boolean isContainerManaged() {
        return this.isContainerManaged;
    }

    boolean isJTA() {
        return this.p == null ? false : this.p.isJTA();
    }

    boolean isNonDefaultProviderEnabled() {
        return this.p == null ? false : this.p.isNonDefaultProviderEnabled();
    }

    String getNonDefaultProvider() {
        return this.p == null ? null : this.p.getNonDefaultProvider();
    }

    String getTableGeneration() {
        return this.panel.getTableGeneration();
    }

    Provider getSelectedProvider() {
        return this.panel.getSelectedProvider();
    }
}

