/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.awt.JInlineMenu;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FileSystemAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static JMenuItem[] NONE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Node[] nodes(Lookup lookup) {
        Collection c = lookup != null ? lookup.lookup(new Lookup.Template(Node.class)).allInstances() : Collections.EMPTY_LIST;
        return c.toArray(new Node[c.size()]);
    }

    static JMenuItem[] createMenu(boolean popUp, Lookup lookup) {
        Node[] n = FileSystemAction.nodes(lookup);
        if (n == null) {
            n = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        HashMap fsSet = new HashMap();
        if (n != null) {
            for (int i = 0; i < n.length; ++i) {
                DataObject obj = (DataObject)n[i].getCookie(class$org$openide$loaders$DataObject == null ? FileSystemAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                while (obj instanceof DataShadow) {
                    obj = ((DataShadow)obj).getOriginal();
                }
                if (obj == null) continue;
                try {
                    FileSystem fs = obj.getPrimaryFile().getFileSystem();
                    LinkedHashSet foSet = (LinkedHashSet)fsSet.get(fs);
                    if (foSet == null) {
                        foSet = new LinkedHashSet();
                        fsSet.put(fs, foSet);
                    }
                    foSet.addAll(obj.files());
                    continue;
                }
                catch (FileStateInvalidException ex) {
                    // empty catch block
                }
            }
            if (fsSet.size() == 0 || fsSet.size() > 1) {
                return FileSystemAction.createMenu(Enumerations.empty(), popUp, lookup);
            }
            Iterator entrySetIt = fsSet.entrySet().iterator();
            LinkedList<SystemAction> result = new LinkedList<SystemAction>();
            LinkedHashSet backSet = new LinkedHashSet();
            while (entrySetIt.hasNext()) {
                Map.Entry entry = entrySetIt.next();
                FileSystem fs = (FileSystem)entry.getKey();
                Set foSet = (Set)entry.getValue();
                LinkedList backupList = new LinkedList();
                Iterator itBackup = foSet.iterator();
                while (itBackup.hasNext()) {
                    backupList.add(itBackup.next());
                }
                Iterator it = backupList.iterator();
                while (it.hasNext()) {
                    FileObject fo = (FileObject)it.next();
                    try {
                        if (fo.getFileSystem() == fs) continue;
                        it.remove();
                    }
                    catch (FileStateInvalidException ex) {
                        it.remove();
                    }
                }
                backSet.addAll(backupList);
                result.addAll(Arrays.asList(fs.getActions(backSet)));
            }
            return FileSystemAction.createMenu(Collections.enumeration(result), popUp, (Lookup)FileSystemAction.createProxyLookup(lookup, backSet));
        }
        return NONE;
    }

    private static ProxyLookup createProxyLookup(Lookup lookup, Set backSet) {
        return new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])backSet.toArray(new FileObject[backSet.size()]))});
    }

    static JMenuItem[] createMenu(Enumeration en, boolean popUp, Lookup lookup) {
        en = Enumerations.removeDuplicates((Enumeration)en);
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        while (en.hasMoreElements()) {
            Action a = (Action)en.nextElement();
            if (lookup != null && a instanceof ContextAwareAction) {
                a = ((ContextAwareAction)a).createContextAwareInstance(lookup);
            }
            boolean enabled = false;
            try {
                enabled = a.isEnabled();
            }
            catch (RuntimeException e) {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate((Throwable)e, 0, "Guilty action: " + a.getClass().getName(), null, null, null);
                em.notify((Throwable)e);
            }
            if (!enabled) continue;
            JMenuItem item = null;
            if (popUp) {
                if (a instanceof Presenter.Popup) {
                    item = ((Presenter.Popup)a).getPopupPresenter();
                }
            } else if (a instanceof Presenter.Menu) {
                item = ((Presenter.Menu)a).getMenuPresenter();
            }
            if (item == null) continue;
            items.add(item);
        }
        JMenuItem[] array = new JMenuItem[items.size()];
        items.toArray(array);
        return array;
    }

    public JMenuItem getMenuPresenter() {
        return new Menu(false, null);
    }

    public JMenuItem getPopupPresenter() {
        return new Menu(true, null);
    }

    public String getName() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"ACT_FileSystemAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FileSystemAction.class);
    }

    public void actionPerformed(ActionEvent e) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("ActionEvt: " + e));
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(actionContext);
    }

    static {
        $assertionsDisabled = !FileSystemAction.class.desiredAssertionStatus();
        NONE = new JMenuItem[0];
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Menu,
    Presenter.Popup {
        private Lookup lookup;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DelegateAction(Lookup lookup) {
            this.lookup = lookup;
        }

        public JMenuItem getMenuPresenter() {
            return new Menu(false, this.lookup);
        }

        public JMenuItem getPopupPresenter() {
            return new Menu(true, this.lookup);
        }

        public void actionPerformed(ActionEvent e) {
            if (!$assertionsDisabled) {
                throw new AssertionError(e);
            }
        }

        static {
            $assertionsDisabled = !(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FileSystemAction.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction).desiredAssertionStatus();
        }
    }

    private static class Menu
    extends JInlineMenu
    implements PropertyChangeListener {
        private boolean popup;
        private JMenuItem[] last = NONE;
        private Lookup lookup;
        static final long serialVersionUID = 2650151487189209766L;
        boolean needsChange = false;

        Menu(boolean popup, Lookup lookup) {
            this.popup = popup;
            this.lookup = lookup;
            this.changeMenuItems(FileSystemAction.createMenu(popup, lookup));
            if (lookup == null) {
                TopComponent.Registry r = WindowManager.getDefault().getRegistry();
                r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)r));
            }
        }

        synchronized void changeMenuItems(JMenuItem[] items) {
            this.removeListeners(this.last);
            this.addListeners(items);
            this.last = items;
            this.setMenuItems(items);
        }

        private void addListeners(JMenuItem[] items) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                items[i].addPropertyChangeListener(this);
            }
        }

        private void removeListeners(JMenuItem[] items) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                items[i].removePropertyChangeListener(this);
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(FileSystemAction.createMenu(this.popup, this.lookup));
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if (name == null || name.equals("enabled") || name.equals("activatedNodes")) {
                this.needsChange = true;
            }
        }
    }
}

