/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.SecondaryConfigDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConfigDataLoader
extends UniFileLoader {
    private static final String GENERIC_EXTENSION = "dpf";
    private static final String PRIMARY = "primary";
    private static final String SECONDARY = "secondary";
    private static HashMap primaryByName;
    private static HashMap secondaryByName;

    public ConfigDataLoader() {
        super("org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject");
        this.initMaps();
    }

    protected void initialize() {
        super.initialize();
    }

    private void initMaps() {
        primaryByName = new HashMap();
        secondaryByName = new HashMap();
        primaryByName.put("sun-web.xml", "WEB-INF/sun-web.xml");
        primaryByName.put("sun-ejb-jar.xml", "META-INF/sun-ejb-jar.xml");
        secondaryByName.put("sun-cmp-mappings.xml", "META-INF/sun-cmp-mappings.xml");
        primaryByName.put("sun-application.xml", "META-INF/sun-application.xml");
        primaryByName.put("sun-application-client.xml", "META-INF/sun-application-client.xml");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)ConfigDataLoader.class, (String)"LBL_LoaderName");
    }

    protected String actionsContext() {
        return "Loaders/xml/sun-dd/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject fo) throws DataObjectExistsException, IOException {
        if (this.isPrimaryDescriptor(fo)) {
            return new ConfigDataObject(fo, (MultiFileLoader)this);
        }
        return new SecondaryConfigDataObject(fo, (MultiFileLoader)this);
    }

    private boolean isPrimaryDescriptor(FileObject fo) {
        String filename = fo.getNameExt();
        return this.getPrimaryByName(filename) != null;
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        File secondary;
        FileObject secondaryFO;
        File primary;
        Lookup l;
        J2eeModuleProvider projectModule;
        if (fo.isFolder()) {
            return null;
        }
        String ext = fo.getExt();
        String filename = fo.getNameExt();
        FileObject primaryFO = null;
        String secondaryName = null;
        if (this.getPrimaryByName(filename) != null || ext.equals(GENERIC_EXTENSION)) {
            primaryFO = fo;
        } else if (this.getPrimaryBySecondaryName(filename) != null) {
            secondaryName = filename;
        }
        if (primaryFO == null && secondaryName == null) {
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner != null && (projectModule = (J2eeModuleProvider)(l = owner.getLookup()).lookup(J2eeModuleProvider.class)) != null && (primaryFO != null ? (primaryFO = projectModule.findDeploymentConfigurationFile(filename)) != null && (primary = FileUtil.toFile((FileObject)primaryFO)) != null && primary.equals(FileUtil.toFile((FileObject)fo)) : (secondaryFO = projectModule.findDeploymentConfigurationFile(secondaryName)) != null && (secondary = FileUtil.toFile((FileObject)secondaryFO)) != null && secondary.equals(FileUtil.toFile((FileObject)fo)))) {
            return fo;
        }
        return null;
    }

    private String getPrimaryByName(String name) {
        return (String)primaryByName.get(name);
    }

    private String getPrimaryBySecondaryName(String name) {
        return (String)secondaryByName.get(name);
    }
}

