/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.Constants;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseModuleRef;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigParser;
import org.netbeans.modules.j2ee.sun.share.configbean.DCBFactoryMgr;
import org.netbeans.modules.j2ee.sun.share.configbean.DConfigBeanProperties;
import org.netbeans.modules.j2ee.sun.share.configbean.DConfigBeanUIFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.J2EEBaseVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.J2EEVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Snippet;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;

public abstract class Base
implements Constants,
DConfigBean,
XpathListener,
DConfigBeanUIFactory {
    protected static final ResourceBundle bundle;
    public static final String DISPLAY_NAME = "displayName";
    public static final String DIRTY_PROPERTY = "dirty";
    public static final Object GenericOldValue;
    private DDBean dDBean;
    private Base parent;
    private String baseXpath;
    protected String descriptorElement;
    private Boolean isValid = null;
    private ErrorMessageDB errorMessageDB = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private PropertyChangeListener validationListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("validationStateChanged".equals(evt.getPropertyName())) {
                Base.this.validationStateChanged((Boolean)evt.getNewValue());
            }
        }
    };
    private static int identitySource;
    private String identity;
    private int dirtyFlag;
    private Map namedBeanCache = new HashMap(11);
    private static Collection commonAppBeanSpecs;
    protected List validationFieldList = new ArrayList();
    private static char XPATH_SEPCHAR;
    private DDBean secondary;
    private Set children = new LinkedHashSet();
    private Map dcbChildGroupMap = null;
    private List groupDCBList = null;
    private Base dcbHead = null;
    private static final Map defaultXPathToFactory;
    private DCBFactoryMgr factoryMgrInstance = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String id) {
    }

    public void setDirty() {
        int oldDirtyFlag = this.dirtyFlag++;
        this.getPCS().firePropertyChange(DIRTY_PROPERTY, oldDirtyFlag, this.dirtyFlag);
    }

    public void firePropertyChange(String propertyName, Object oldProperty, Object newProperty) {
        this.getPCS().firePropertyChange(propertyName, oldProperty, newProperty);
    }

    protected Base() {
        this.identity = Integer.toString(++identitySource);
    }

    protected void init(DDBean dDBean, Base parent) throws ConfigurationException {
        this.dDBean = dDBean;
        this.parent = parent;
        this.baseXpath = dDBean.getXpath();
        this.updateValidationFieldList();
        dDBean.addXpathListener(dDBean.getXpath(), (XpathListener)this);
        this.getMessageDB().addPropertyChangeListener(this.validationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        this.getMessageDB().removePropertyChangeListener(this.validationListener);
        this.dDBean.removeXpathListener(this.dDBean.getXpath(), (XpathListener)this);
        Base base = this;
        synchronized (base) {
            this.errorMessageDB = null;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = null;
    }

    protected String getDescriptorElement() {
        return this.descriptorElement;
    }

    protected void setDescriptorElement(String element) {
        this.descriptorElement = element;
    }

    protected String getComponentName() {
        return null;
    }

    protected String getAbsoluteXpath(String field) {
        StringBuffer buf = new StringBuffer(this.baseXpath.length() + field.length() + 1);
        buf.append(this.baseXpath);
        buf.append("/");
        buf.append(field);
        return buf.toString();
    }

    protected boolean requiresJndiName() {
        return J2EEVersion.J2EE_1_4.compareSpecification(this.getJ2EEModuleVersion()) >= 0;
    }

    protected void saveNamedBeans(String type, String nameProperty, CommonDDBean[] data) {
        if (data != null && data.length > 0) {
            HashMap<String, CommonDDBean> dataMap = new HashMap<String, CommonDDBean>(data.length * 3);
            for (int i = 0; i < data.length; ++i) {
                String beanName = (String)data[i].getValue(nameProperty);
                if (!Utils.notEmpty(beanName)) continue;
                dataMap.put(beanName, data[i]);
            }
            this.namedBeanCache.put(type, dataMap);
        }
    }

    protected CommonDDBean removeNamedBean(String type, String beanName) {
        CommonDDBean result = null;
        Map dataMap = this.getNamedBeanMap(type);
        if (dataMap != null) {
            result = (CommonDDBean)dataMap.remove(beanName);
        }
        return result;
    }

    protected Map getNamedBeanMap(String type) {
        return (Map)this.namedBeanCache.get(type);
    }

    protected void saveAllNamedBeans(CommonDDBean parentBean) {
        Iterator iter = this.getNamedBeanSpecs().iterator();
        while (iter.hasNext()) {
            NamedBean beanSpec = (NamedBean)iter.next();
            try {
                Object[] data = parentBean.getValues(beanSpec.getType());
                if (data instanceof CommonDDBean[]) {
                    this.saveNamedBeans(beanSpec.getType(), beanSpec.getPropertyName(), (CommonDDBean[])data);
                    continue;
                }
                if (data == null) continue;
            }
            catch (Exception ex) {}
        }
    }

    protected void restoreAllNamedBeans(CommonDDBean parentBean, String version) {
        Iterator iter = this.getNamedBeanSpecs().iterator();
        while (iter.hasNext()) {
            NamedBean beanSpec = (NamedBean)iter.next();
            Map beanMap = this.getNamedBeanMap(beanSpec.getType());
            this.restoreNamedBeans(beanMap, beanSpec.getType(), parentBean, version);
        }
    }

    protected void restoreNamedBeans(Map beanMap, String parentPropertyName, CommonDDBean parentBean, String version) {
        if (beanMap != null && beanMap.size() > 0) {
            Iterator beanIter = beanMap.entrySet().iterator();
            while (beanIter.hasNext()) {
                try {
                    Map.Entry entry = beanIter.next();
                    CommonDDBean bean = (CommonDDBean)entry.getValue();
                    parentBean.addValue(parentPropertyName, (Object)bean.cloneVersion(version));
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void updateNamedBeanCache(String type) {
        String name;
        if (this.parent != null && Utils.notEmpty(name = this.getComponentName())) {
            this.parent.removeNamedBean(type, name);
        }
    }

    protected Collection getNamedBeanSpecs() {
        return Collections.EMPTY_LIST;
    }

    protected static Collection getCommonNamedBeanSpecs() {
        return commonAppBeanSpecs;
    }

    protected final synchronized ErrorMessageDB getMessageDB() {
        if (this.errorMessageDB == null) {
            this.errorMessageDB = ErrorMessageDB.createMessageDB();
        }
        return this.errorMessageDB;
    }

    protected void updateValidationFieldList() {
    }

    public void validationStateChanged(Boolean newState) {
        this.isValid = newState;
        this.getPCS().firePropertyChange(DISPLAY_NAME, "", this.getDisplayName());
    }

    public boolean isValid() {
        if (this.isValid == null) {
            boolean tempValid = this.validateFields(true);
            this.isValid = tempValid;
        }
        return this.isValid;
    }

    public boolean validateFields(boolean shortCircuit) {
        ErrorMessageDB messageDB = this.getMessageDB();
        boolean result = true;
        messageDB.clearErrors();
        Iterator iter = this.validationFieldList.iterator();
        while (iter.hasNext() && (result || !shortCircuit)) {
            boolean fieldResult = this.validateField((String)iter.next());
            result = result && fieldResult;
        }
        this.isValid = result;
        return result;
    }

    public boolean validateField(String fieldId) {
        return true;
    }

    public void fireXpathEvent(XpathEvent xpe) {
    }

    public J2EEBaseVersion getJ2EEModuleVersion() {
        Base parent = this.getParent();
        if (parent != null) {
            return this.getParent().getJ2EEModuleVersion();
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("getJ2EEModuleVersion() called on child DConfigBean with null parent: " + this));
        return null;
    }

    public ASDDVersion getAppServerVersion() {
        Base parent = this.getParent();
        if (parent != null) {
            return this.getParent().getAppServerVersion();
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("getAppServerVersion() called on child DConfigBean with null parent: " + this));
        return null;
    }

    protected DDBean getNameDD(String nameXpath) throws ConfigurationException {
        DDBean nameDD = null;
        DDBean[] beans = this.getDDBean().getChildBean(nameXpath);
        if (beans.length != 1) {
            Object[] args = new Object[]{this.getDDBean().getXpath(), nameXpath};
            if (beans.length > 1) {
                throw Utils.makeCE("ERR_DDBeanHasDuplicateRequiredXpaths", args, null);
            }
            throw Utils.makeCE("ERR_DDBeanMissingRequiredXpath", args, null);
        }
        nameDD = beans[0];
        return nameDD;
    }

    protected void validateDDBean(DDBean ddBean) throws ConfigurationException {
        if (ddBean == null) {
            throw Utils.makeCE("ERR_DDBeanIsNull", null, null);
        }
        if (ddBean.getXpath() == null) {
            throw Utils.makeCE("ERR_DDBeanHasNullXpath", null, null);
        }
    }

    public DConfigBean getDConfigBean(DDBean dDBean) throws ConfigurationException {
        try {
            jsr88Logger.entering(Base.class.toString(), "getDConfigBean", dDBean);
            this.validateDDBean(dDBean);
            Base dcbResult = this.getDCBInstance(dDBean);
            if (dcbResult == null && (dcbResult = this.getDCBFactoryMgr().createDCB(dDBean, this)) != null) {
                this.putDCBInstance(dcbResult);
                this.addChild(dcbResult);
                Base groupHead = dcbResult.getDCBHead();
                if (groupHead != null) {
                    dcbResult = groupHead;
                }
                this.beanAdded(dcbResult.getDDBean().getXpath());
            }
            return dcbResult;
        }
        catch (AssertionError ex) {
            ConfigurationException ce = new ConfigurationException();
            ce.initCause((Throwable)((Object)ex));
            throw ce;
        }
        catch (RuntimeException ex) {
            throw Utils.makeCE("ERR_UnknownConfigException", null, ex);
        }
    }

    protected void beanAdded(String xpath) {
    }

    protected void beanRemoved(String xpath) {
    }

    public DDBean getDDBean() {
        return this.dDBean;
    }

    public String[] getXpaths() {
        return this.getDCBFactoryMgr().getFactoryKeys();
    }

    public void notifyDDChange(XpathEvent xpathEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
        if (dConfigBean == null) throw new BeanNotFoundException(bundle.getString("ERR_DConfigBeanNotFoundOnRemoveNullDConfigBean"));
        if (dConfigBean.getDDBean() == null) throw new BeanNotFoundException(bundle.getString("ERR_DConfigBeanNotFoundOnRemoveNullDDBean"));
        if (((Base)dConfigBean).getParent() != this) throw new BeanNotFoundException(bundle.getString("ERR_DConfigBeanWrongParentOnRemove"));
        Base beanToRemove = (Base)dConfigBean;
        Object[] children = beanToRemove.getChildren().toArray();
        for (int i = 0; i < children.length; ++i) {
            try {
                beanToRemove.removeDConfigBean((Base)children[i]);
                continue;
            }
            catch (BeanNotFoundException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        DDBean key = dConfigBean.getDDBean();
        beanToRemove = this.removeDCBInstance(key);
        if (beanToRemove != null) {
            if (beanToRemove instanceof BaseRoot) {
                BaseRoot rootBean = (BaseRoot)this.getConfig().getDCBRootCache().remove(key);
                if (rootBean != null && !$assertionsDisabled && rootBean != beanToRemove) {
                    throw new AssertionError();
                }
            } else if (beanToRemove instanceof BaseModuleRef) {
                this.getConfig().getPatchList().remove(key);
            }
        }
        if (beanToRemove == null) {
            Object[] args = new Object[]{dConfigBean.getDDBean(), key.getXpath()};
            throw new BeanNotFoundException(MessageFormat.format(bundle.getString("ERR_DConfigBeanNotFoundOnRemove"), args));
        }
        String beanXpath = beanToRemove.getDDBean().getXpath();
        beanToRemove.cleanup();
        beanToRemove = null;
        this.beanRemoved(beanXpath);
    }

    public void addPropertyChangeListener(PropertyChangeListener pCL) {
        this.propertyChangeSupport.addPropertyChangeListener(pCL);
    }

    public void removePropertyChangeListener(PropertyChangeListener pCL) {
        this.propertyChangeSupport.removePropertyChangeListener(pCL);
    }

    protected PropertyChangeSupport getPCS() {
        return this.propertyChangeSupport;
    }

    protected VetoableChangeSupport getVCS() {
        return this.vetoableChangeSupport;
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public Base getParent() {
        return this.parent;
    }

    protected ConfigParser getParser() {
        BaseRoot dcbRoot;
        Base parent = this.getParent();
        if (parent != null) {
            return parent.getParser();
        }
        SunONEDeploymentConfiguration config = this.getConfig();
        if (config != null && (dcbRoot = config.getMasterDCBRoot()) != null) {
            return dcbRoot.getParser();
        }
        return null;
    }

    abstract Collection getSnippets();

    abstract boolean loadFromPlanFile(SunONEDeploymentConfiguration var1);

    public void addToGraphs(Map map, CommonDDBean bbCurrent, String bbKey) {
        jsr88Logger.entering(this.getClass().toString(), "addToGraphs");
        String uriText = this.getUriText();
        Collection snippets = this.getSnippets();
        boolean isFirst = true;
        CommonDDBean newCurrentBean = null;
        String newSnippetKey = "";
        Iterator iter = snippets.iterator();
        while (iter.hasNext()) {
            try {
                CommonDDBean bean = null;
                Snippet s = (Snippet)iter.next();
                if (!s.hasDDSnippet()) continue;
                String snippetKey = Utils.getFQNKey(uriText, s.getFileName());
                if (snippetKey.compareTo(bbKey) == 0) {
                    bean = s.mergeIntoRovingDD(bbCurrent);
                } else if (map.containsKey(snippetKey)) {
                    try {
                        bean = s.mergeIntoRootDD((CommonDDBean)map.get(snippetKey));
                    }
                    catch (UnsupportedOperationException ex) {
                        jsr88Logger.finest("Invalid Snippet:  Snippet Class: " + s.getClass().getName());
                        CommonDDBean parent = (CommonDDBean)map.get(snippetKey);
                        jsr88Logger.finest("Parent Bean: " + (parent != null ? parent.getClass().getName() : "(null -- ack!)"));
                        jsr88Logger.finest("Snippet Key: " + snippetKey);
                        jsr88Logger.finest("Snippet Property Name: " + s.getPropertyName());
                        throw ex;
                    }
                } else {
                    bean = s.getDDSnippet();
                    if (bean != null) {
                        map.put(snippetKey, bean);
                    }
                }
                if (!isFirst) continue;
                newCurrentBean = bean;
                newSnippetKey = snippetKey;
                isFirst = false;
            }
            catch (Exception ex) {
                jsr88Logger.log(Level.SEVERE, "Base.newAddToGraph() -- exception processing bean", ex);
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        Collection childList = this.getChildren();
        iter = childList.iterator();
        while (iter.hasNext()) {
            Base childDCB = (Base)iter.next();
            childDCB.addToGraphs(map, this.processParentBean(newCurrentBean, childDCB), newSnippetKey);
        }
        jsr88Logger.exiting(this.getClass().toString(), "addToGraphs");
    }

    protected CommonDDBean processParentBean(CommonDDBean bean, DConfigBean child) {
        return bean;
    }

    Collection getChildren() {
        return this.children;
    }

    public String getUriText() {
        if (this.parent != null) {
            return this.parent.getUriText();
        }
        return "";
    }

    static String cleanDDBeanText(DDBean dDBean) {
        String candidate = null;
        try {
            if (dDBean == null) {
                return candidate;
            }
            candidate = dDBean.getText();
            if (null == candidate || candidate.length() == 0) {
                return candidate;
            }
            if (!candidate.startsWith("<?xml")) {
                return candidate;
            }
            String xpath = dDBean.getXpath();
            if (null == xpath || xpath.length() == 0) {
                return candidate;
            }
            int lindex = xpath.lastIndexOf(XPATH_SEPCHAR);
            if (lindex > -1) {
                String finalEl = xpath.substring(++lindex);
                finalEl = "<" + finalEl + ">";
                int elementPos = candidate.indexOf(finalEl);
                if (elementPos < 0) {
                    return candidate;
                }
                String retVal = candidate.substring(elementPos + finalEl.length());
                if (retVal.length() < finalEl.length() + 1) {
                    return retVal;
                }
                retVal = retVal.substring(0, retVal.length() - (finalEl.length() + 2));
                return retVal;
            }
        }
        catch (RuntimeException ex) {
            jsr88Logger.throwing("Base", "cleanDDBeanText", ex);
        }
        return candidate;
    }

    protected void addChild(DConfigBean bean) {
        this.children.add(bean);
    }

    protected boolean removeChild(DConfigBean bean) {
        return this.children.remove(bean);
    }

    void setSecondary(DDBean secondary) {
        this.secondary = secondary;
    }

    public SunONEDeploymentConfiguration getConfig() {
        if (null != this.parent) {
            return this.parent.getConfig();
        }
        return null;
    }

    public DConfigBeanProperties getUICustomization(DConfigBean self) {
        return new DConfigBeanProperties(){

            public String getDisplayName() {
                return Base.this.getDisplayName();
            }

            public String getHelpId() {
                return Base.this.getHelpId();
            }
        };
    }

    public String getDisplayName() {
        String name = this.getComponentName();
        Object[] args = new Object[]{Utils.notEmpty(name) ? name : this.getDescriptorElement()};
        String pattern = bundle.getString(this.isValid() ? "LBL_BeanDisplayName" : "LBL_BeanDisplayNameBroken");
        return MessageFormat.format(pattern, args);
    }

    public abstract String getHelpId();

    protected void putDCBInstance(Base base) {
        SunONEDeploymentConfiguration config;
        DDBean key = base.getDDBean();
        if (key != null && (config = this.getConfig()) != null) {
            Map cache = config.getDCBCache();
            Object existingDCB = cache.get(key);
            if (existingDCB != null) {
                // empty if block
            }
            cache.put(key, base);
        }
    }

    protected Base getDCBInstance(DDBean key) {
        Map cache;
        Object o;
        Base result = null;
        SunONEDeploymentConfiguration config = this.getConfig();
        if (config != null && (o = (cache = config.getDCBCache()).get(key)) != null && o instanceof Base) {
            result = (Base)o;
        }
        return result;
    }

    protected Base removeDCBInstance(Base base) {
        return this.removeDCBInstance(base.getDDBean());
    }

    protected Base removeDCBInstance(DDBean key) {
        Map cache;
        Object o;
        Base result = null;
        SunONEDeploymentConfiguration config = this.getConfig();
        if (config != null && (o = (cache = config.getDCBCache()).remove(key)) != null && o instanceof Base) {
            result = (Base)o;
        }
        return result;
    }

    protected Base getDCBGroup(DDBean dDBean) {
        Base dcbResult = null;
        if (this.dcbChildGroupMap != null) {
            dcbResult = (Base)this.dcbChildGroupMap.get(dDBean.getXpath());
        }
        return dcbResult;
    }

    protected void addDCBGroup(Base dcb) {
        if (this.dcbChildGroupMap == null) {
            this.dcbChildGroupMap = new HashMap(7);
        }
        if (this.getDCBGroup(dcb.getDDBean()) == null) {
            this.dcbChildGroupMap.put(dcb.getDDBean().getXpath(), dcb);
        }
    }

    protected void initGroup(DDBean dDBean, Base parent) {
        if (parent != null) {
            Base dcb = parent.getDCBGroup(dDBean);
            if (dcb != null) {
                this.dcbHead = dcb;
                this.dcbHead.addDCBToGroup(this);
            } else {
                this.dcbHead = this;
                this.addDCBToGroup(this);
                parent.addDCBGroup(this);
            }
        }
    }

    private void addDCBToGroup(Base dcb) {
        if (this.groupDCBList == null) {
            this.groupDCBList = new ArrayList(10);
        }
        this.groupDCBList.add(dcb);
    }

    protected Base getDCBHead() {
        return this.dcbHead;
    }

    protected Map getXPathToFactoryMap() {
        return defaultXPathToFactory;
    }

    DCBFactoryMgr getDCBFactoryMgr() {
        if (this.factoryMgrInstance == null) {
            this.factoryMgrInstance = new DCBFactoryMgr(this.getXPathToFactoryMap(), this.getDDBean().getXpath());
        }
        return this.factoryMgrInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String constructFileName() {
        String ddXpath = this.dDBean.getXpath();
        StringBuffer fname = new StringBuffer(32);
        fname.append("sun-");
        if (null == ddXpath) throw new IllegalStateException("null Xpath value");
        if (ddXpath.startsWith("/ejb-jar")) {
            fname.append("ejb-jar");
        } else if (ddXpath.startsWith("/web-app")) {
            fname.append("web");
        } else if (ddXpath.startsWith("/application")) {
            if (ddXpath.indexOf("client") > -1) {
                fname.append("application-client");
            } else {
                fname.append("application");
            }
        } else if (ddXpath.startsWith("/connector")) {
            fname.append("connector");
        } else {
            String mess = MessageFormat.format(bundle.getString("ERR_InvalidXPathValueUsage"), ddXpath);
            throw new IllegalStateException(mess);
        }
        fname.append(".xml");
        return fname.toString();
    }

    static {
        $assertionsDisabled = !Base.class.desiredAssertionStatus();
        bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.Bundle");
        GenericOldValue = new Object();
        identitySource = 0;
        commonAppBeanSpecs = new ArrayList();
        commonAppBeanSpecs.add(new NamedBean("EjbRef", "EjbRefName"));
        commonAppBeanSpecs.add(new NamedBean("MessageDestinationRef", "MessageDestinationRefName"));
        commonAppBeanSpecs.add(new NamedBean("ResourceEnvRef", "ResourceEnvRefName"));
        commonAppBeanSpecs.add(new NamedBean("ResourceRef", "ResRefName"));
        commonAppBeanSpecs.add(new NamedBean("ServiceRef", "ServiceRefName"));
        XPATH_SEPCHAR = (char)47;
        defaultXPathToFactory = new HashMap();
    }

    protected static class NameBasedFinder
    implements ConfigFinder {
        private String propertyName;
        private String propertyValue;
        private Class beanType;

        public NameBasedFinder(String propName, String propValue, Class type) {
            this.propertyName = propName;
            this.propertyValue = propValue;
            this.beanType = type;
        }

        public Object find(Object obj) {
            CommonDDBean result = null;
            CommonDDBean root = (CommonDDBean)obj;
            String[] props = root.findPropertyValue(this.propertyName, (Object)this.propertyValue);
            for (int i = 0; i < props.length; ++i) {
                CommonDDBean candidate = root.getPropertyParent(props[i]);
                if (!this.beanType.isInstance(candidate)) continue;
                result = candidate;
                break;
            }
            return result;
        }
    }

    abstract class DefaultSnippet
    implements Snippet {
        DefaultSnippet() {
        }

        public abstract CommonDDBean getDDSnippet();

        public BaseBean getCmpDDSnippet() {
            return null;
        }

        public boolean hasDDSnippet() {
            return true;
        }

        public String getFileName() {
            return Base.this.constructFileName();
        }

        public CommonDDBean mergeIntoRootDD(CommonDDBean ddRoot) {
            throw new UnsupportedOperationException();
        }

        public CommonDDBean mergeIntoRovingDD(CommonDDBean ddParent) {
            CommonDDBean newBean = this.getDDSnippet();
            if (newBean != null) {
                if (ddParent != null) {
                    String propertyName = this.getPropertyName();
                    if (propertyName != null) {
                        ddParent.addValue(propertyName, (Object)newBean);
                    } else {
                        Constants.jsr88Logger.severe("No property name for " + Base.this.getClass());
                    }
                } else {
                    Constants.jsr88Logger.severe("mergeIntoRovingDD() called with null parent (called on root bean?)");
                }
            } else {
                Constants.jsr88Logger.severe("No snippet to merge for " + Base.this.getClass());
            }
            return newBean;
        }

        public String getPropertyName() {
            return null;
        }
    }

    protected static class NamedBean {
        private final String type;
        private final String propertyName;

        public NamedBean(String t, String pn) {
            this.type = t;
            this.propertyName = pn;
        }

        public String getType() {
            return this.type;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

