/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyVetoException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.app.SunApplication;
import org.netbeans.modules.j2ee.sun.dd.api.app.Web;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseModuleRef;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;

public class WebAppRef
extends BaseModuleRef {
    private DDBean contextRootDD = null;
    private String contextRoot;

    protected void init(DDBean dDBean, Base parent) throws ConfigurationException {
        super.init(dDBean, parent);
        this.contextRootDD = this.getNameDD("context-root");
        this.loadFromPlanFile(this.getConfig());
    }

    protected void initModuleUri(DDBean dDBean) {
        DDBean[] uriBeans = dDBean.getChildBean("web-uri");
        if (uriBeans.length > 0) {
            this.setModuleUri(uriBeans[0]);
        } else {
            this.setModuleUri(null);
        }
    }

    public String getTitleFragment() {
        return bundle.getString("LBL_WebTitleFragment");
    }

    public String getWebUri() {
        return this.getModuleUri();
    }

    public String getContextRoot() {
        String result = null;
        result = this.contextRoot == null || this.contextRoot.length() == 0 && this.contextRootDD != null ? this.contextRootDD.getText() : this.contextRoot;
        return result;
    }

    public void setContextRoot(String newContextRoot) throws PropertyVetoException {
        if (newContextRoot != null) {
            newContextRoot = newContextRoot.replace(' ', '_');
        }
        if (newContextRoot != null) {
            try {
                String result = "";
                String[] s = newContextRoot.split("/");
                for (int i = 0; i < s.length; ++i) {
                    result = result + URLEncoder.encode(s[i], "UTF-8");
                    if (i == s.length - 1) continue;
                    result = result + "/";
                }
                newContextRoot = result;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String oldContextRoot = this.contextRoot;
        this.getVCS().fireVetoableChange("contextRoot", oldContextRoot, newContextRoot);
        this.contextRoot = newContextRoot;
        this.getPCS().firePropertyChange("contextRoot", oldContextRoot, this.contextRoot);
    }

    public String getHelpId() {
        return "AS_CFG_WebAppRef";
    }

    Collection getSnippets() {
        ArrayList<1> snippets = new ArrayList<1>();
        Base.DefaultSnippet snipOne = new Base.DefaultSnippet(){

            public CommonDDBean getDDSnippet() {
                Web web = WebAppRef.this.getConfig().getStorageFactory().createWeb();
                web.setWebUri(WebAppRef.this.getWebUri());
                web.setContextRoot(WebAppRef.this.getContextRoot());
                return web;
            }

            public boolean hasDDSnippet() {
                return Utils.notEmpty(WebAppRef.this.contextRoot);
            }

            public String getPropertyName() {
                return "Web";
            }
        };
        snippets.add(snipOne);
        return snippets;
    }

    boolean loadFromPlanFile(SunONEDeploymentConfiguration config) {
        String uriText = this.getUriText();
        Web beanGraph = (Web)config.getBeans(uriText, this.constructFileName(), this.getParser(), new WebAppRefFinder());
        this.clearProperties();
        if (beanGraph != null) {
            String cr = beanGraph.getContextRoot();
            if (Utils.notEmpty(cr) && cr.compareTo(this.getContextRoot()) != 0) {
                this.contextRoot = cr;
            }
        } else {
            this.setDefaultProperties();
        }
        return beanGraph != null;
    }

    protected void clearProperties() {
        this.contextRoot = null;
    }

    protected void setDefaultProperties() {
    }

    private class WebAppRefFinder
    implements ConfigFinder {
        private WebAppRefFinder() {
        }

        public Object find(Object obj) {
            Web result = null;
            String webUri = WebAppRef.this.getWebUri();
            if (obj instanceof SunApplication && webUri != null) {
                SunApplication sa = (SunApplication)obj;
                Web[] webModules = sa.getWeb();
                for (int i = 0; i < webModules.length; ++i) {
                    if (webUri.compareTo(webModules[i].getWebUri()) != 0) continue;
                    result = webModules[i];
                    break;
                }
            }
            return result;
        }
    }
}

