/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ErrorSupportClient;

public class ErrorSupport
implements ErrorSupportClient {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private List errorList;
    private JPanel errorPanel;
    private JComponent focusedComponent;
    private ErrorSupportClient client;

    public ErrorSupport() {
        this.initialize();
        this.client = this;
    }

    public ErrorSupport(ErrorSupportClient client) {
        this.initialize();
        this.client = client;
    }

    private void initialize() {
        this.errorList = new ArrayList();
        this.errorPanel = null;
        this.focusedComponent = null;
    }

    public void showErrors() {
        Container parentPanel;
        this.removeAllErrors();
        Collection errors = this.client.getErrors();
        if (errors != null) {
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) continue;
                this.addError((String)object);
            }
        }
        if ((parentPanel = this.client.getErrorPanelParent()) != null) {
            if (this.errorList.size() != 0) {
                if (this.errorPanel == null) {
                    this.errorPanel = new JPanel(new GridBagLayout());
                    parentPanel.add((Component)this.errorPanel, this.client.getErrorPanelConstraints());
                } else {
                    this.errorPanel.removeAll();
                }
                Iterator iter = this.errorList.iterator();
                while (iter.hasNext()) {
                    String message = (String)iter.next();
                    JLabel label = new JLabel();
                    label.setIcon(BaseCustomizer.errorMessageIcon);
                    label.setText(message);
                    label.getAccessibleContext().setAccessibleName(bundle.getString("ASCN_ErrorMessage"));
                    label.getAccessibleContext().setAccessibleDescription(message);
                    label.setForeground(this.getMessageForegroundColor());
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.gridwidth = 0;
                    constraints.fill = 2;
                    constraints.weightx = 1.0;
                    this.errorPanel.add((Component)label, constraints);
                }
            } else if (this.errorPanel != null) {
                parentPanel.remove(this.errorPanel);
                this.errorPanel = null;
            }
            parentPanel.validate();
        }
    }

    public boolean hasErrors() {
        return this.errorList.size() != 0;
    }

    public void addError(String error) {
        this.errorList.add(error);
    }

    public void addError(JComponent focusedComponent, String error) {
        this.setFocusedComponent(focusedComponent);
        this.errorList.add(error);
    }

    public void setFocusedComponent(JComponent comp) {
        this.focusedComponent = comp;
    }

    public JComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    public void removeAllErrors() {
        this.errorList.clear();
        this.focusedComponent = null;
    }

    public Collection getErrors() {
        return null;
    }

    public Container getErrorPanelParent() {
        return null;
    }

    public GridBagConstraints getErrorPanelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 11, 11);
        return gridBagConstraints;
    }

    public Color getMessageForegroundColor() {
        return BaseCustomizer.getErrorForegroundColor();
    }
}

