/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;

public class LocaleMapping
implements Comparable {
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private Locale locale;
    private String displayText;
    private boolean textOutOfDate;
    private static SortedMap sortedLocaleMappings = LocaleMapping.getSortedAvailableLocaleMappings();

    public LocaleMapping(Locale l) {
        this.locale = l;
        this.displayText = this.buildDisplayText();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof LocaleMapping) {
            LocaleMapping lm = (LocaleMapping)o;
            result = this.locale.equals(lm.getLocale());
        }
        return result;
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public String toString() {
        if (this.textOutOfDate) {
            this.displayText = this.buildDisplayText();
        }
        return this.displayText;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void updateDisplayText() {
        this.textOutOfDate = true;
    }

    private String buildDisplayText() {
        Object[] args = new Object[]{this.locale.toString(), this.locale.getDisplayName()};
        String result = MessageFormat.format(webappBundle.getString("LBL_LocaleComboBoxDisplayText"), args);
        if (result == null || result.length() == 0) {
            result = webappBundle.getString("LBL_UnnamedLocale");
        }
        this.textOutOfDate = false;
        return result;
    }

    public int compareTo(Object obj) {
        int result = -1;
        if (obj instanceof LocaleMapping) {
            LocaleMapping targetMapping = (LocaleMapping)obj;
            result = this.locale.toString().compareTo(targetMapping.getLocale().toString());
        }
        return result;
    }

    public static SortedMap getSortedAvailableLocaleMappings() {
        if (sortedLocaleMappings == null) {
            Locale[] isoInstalledLocales = Locale.getAvailableLocales();
            sortedLocaleMappings = new TreeMap(new LocaleComparator());
            for (int i = 0; i < isoInstalledLocales.length; ++i) {
                sortedLocaleMappings.put(isoInstalledLocales[i], new LocaleMapping(isoInstalledLocales[i]));
            }
        }
        return sortedLocaleMappings;
    }

    public static LocaleMapping getLocaleMapping(Locale l) {
        return (LocaleMapping)sortedLocaleMappings.get(l);
    }

    public static LocaleMapping getLocaleMapping(String ls) {
        return (LocaleMapping)sortedLocaleMappings.get(LocaleMapping.getLocale(ls));
    }

    public static Locale getLocale(String localeSpec) {
        String[] parts;
        Locale result = null;
        if (localeSpec != null && (parts = localeSpec.split("_", 3)).length >= 1) {
            String language = parts[0];
            if (language == null) {
                language = "";
            }
            if (parts.length >= 2) {
                String country = parts[1];
                if (country == null) {
                    country = "";
                }
                if (parts.length >= 3) {
                    String variant = parts[2];
                    if (variant == null) {
                        variant = "";
                    }
                    result = new Locale(language, country, variant);
                } else {
                    result = new Locale(language, country);
                }
            } else {
                result = new Locale(language);
            }
        }
        return result;
    }

    public static class LocaleComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int result = -1;
            if (o1 instanceof Locale && o2 instanceof Locale) {
                Locale l1 = (Locale)o1;
                Locale l2 = (Locale)o2;
                result = l1.toString().compareTo(l2.toString());
            }
            return result;
        }
    }
}

