/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.SessionConfigSubBean;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;

public class WebAppSessionConfigPanel
extends JPanel
implements TableModelListener {
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private static final TextMapping[] persistenceTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("memory", webappBundle.getString("MEMORY_PERSISTENCE_TYPE")), new TextMapping("file", webappBundle.getString("FILE_PERSISTENCE_TYPE")), new TextMapping("ha", webappBundle.getString("HA_PERSISTENCE_TYPE")), new TextMapping("mmap", webappBundle.getString("MMAP_PERSISTENCE_TYPE")), new TextMapping("replicated", webappBundle.getString("REPLICATED_PERSISTENCE_TYPE")), new TextMapping("s1ws60", webappBundle.getString("S1WS60_PERSISTENCE_TYPE")), new TextMapping("custom", webappBundle.getString("CUSTOM_PERSISTENCE_TYPE"))};
    private WebAppRootCustomizer masterPanel;
    private DefaultComboBoxModel persistenceTypeModel;
    private GenericTableModel mgrPropertiesModel;
    private GenericTablePanel mgrPropertiesPanel;
    private GenericTableModel storePropertiesModel;
    private GenericTablePanel storePropertiesPanel;
    private GenericTableModel sessionPropertiesModel;
    private GenericTablePanel sessionPropertiesPanel;
    private GenericTableModel cookiePropertiesModel;
    private GenericTablePanel cookiePropertiesPanel;
    private JComboBox jComboPersistenceType;
    private JLabel jLblPersistenceType;
    private JLabel jLblSessionManager;
    private JTabbedPane propertyTabbedPanel;
    private JPanel sessionMgrPanel;

    public WebAppSessionConfigPanel(WebAppRootCustomizer src) {
        this.masterPanel = src;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.sessionMgrPanel = new JPanel();
        this.jLblSessionManager = new JLabel();
        this.jLblPersistenceType = new JLabel();
        this.jComboPersistenceType = new JComboBox();
        this.propertyTabbedPanel = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_WebAppSessionConfigTab"));
        this.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_WebAppSessionConfigTab"));
        this.sessionMgrPanel.setLayout(new GridBagLayout());
        this.jLblSessionManager.setText(webappBundle.getString("LBL_SessionManager"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.sessionMgrPanel.add((Component)this.jLblSessionManager, gridBagConstraints);
        this.jLblPersistenceType.setLabelFor(this.jComboPersistenceType);
        this.jLblPersistenceType.setText(webappBundle.getString("LBL_PersistenceType_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.sessionMgrPanel.add((Component)this.jLblPersistenceType, gridBagConstraints);
        this.jComboPersistenceType.setPrototypeDisplayValue("Ay");
        this.jComboPersistenceType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebAppSessionConfigPanel.this.jComboPersistenceTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.sessionMgrPanel.add((Component)this.jComboPersistenceType, gridBagConstraints);
        this.jComboPersistenceType.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_PersistenceType"));
        this.jComboPersistenceType.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_PersistenceType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sessionMgrPanel, gridBagConstraints);
        this.propertyTabbedPanel.setTabPlacement(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertyTabbedPanel, gridBagConstraints);
    }

    private void jComboPersistenceTypeActionPerformed(ActionEvent evt) {
        TextMapping type = (TextMapping)this.persistenceTypeModel.getSelectedItem();
        WebAppRoot theBean = this.masterPanel.getBean();
        if (theBean != null) {
            SessionConfigSubBean sessonConfigBean = theBean.getSessionConfigBean();
            try {
                sessonConfigBean.setPersistenceType(type.getXMLString());
            }
            catch (PropertyVetoException ex) {
                this.persistenceTypeModel.setSelectedItem(this.getPersistenceTypeMapping(sessonConfigBean.getPersistenceType()));
            }
        }
    }

    void initUserComponents() {
        this.persistenceTypeModel = new DefaultComboBoxModel();
        for (int i = 0; i < persistenceTypes.length; ++i) {
            this.persistenceTypeModel.addElement(persistenceTypes[i]);
        }
        this.jComboPersistenceType.setModel(this.persistenceTypeModel);
        ArrayList<GenericTableModel.TableEntry> tableColumns = new ArrayList<GenericTableModel.TableEntry>(3);
        tableColumns.add(new GenericTableModel.AttributeEntry("Name", commonBundle.getString("LBL_Name"), true));
        tableColumns.add(new GenericTableModel.AttributeEntry("Value", commonBundle.getString("LBL_Value"), true));
        tableColumns.add(new GenericTableModel.ValueEntry("Description", commonBundle.getString("LBL_Description")));
        this.mgrPropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, tableColumns);
        this.mgrPropertiesPanel = new GenericTablePanel(this.mgrPropertiesModel, webappBundle, "ManagerProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationManagerProperty", PropertyListMapping.getPropertyList("ConfigManagerProperties"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new GridBagLayout());
        holderPanel.add((Component)this.mgrPropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(webappBundle.getString("TAB_ManagerProperties"), holderPanel);
        this.storePropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, tableColumns);
        this.storePropertiesPanel = new GenericTablePanel(this.storePropertiesModel, webappBundle, "StoreProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationStoreProperty", PropertyListMapping.getPropertyList("ConfigStoreProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        holderPanel = new JPanel();
        holderPanel.setLayout(new GridBagLayout());
        holderPanel.add((Component)this.storePropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(webappBundle.getString("TAB_StoreProperties"), holderPanel);
        this.sessionPropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, tableColumns);
        this.sessionPropertiesPanel = new GenericTablePanel(this.sessionPropertiesModel, webappBundle, "SessionProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationSessionProperty", PropertyListMapping.getPropertyList("ConfigSessionProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        holderPanel = new JPanel();
        holderPanel.setLayout(new GridBagLayout());
        holderPanel.add((Component)this.sessionPropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(webappBundle.getString("TAB_SessionProperties"), holderPanel);
        this.cookiePropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, tableColumns);
        this.cookiePropertiesPanel = new GenericTablePanel(this.cookiePropertiesModel, webappBundle, "CookieProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationCookieProperty", PropertyListMapping.getPropertyList("ConfigCookieProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        holderPanel = new JPanel();
        holderPanel.setLayout(new GridBagLayout());
        holderPanel.add((Component)this.cookiePropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(webappBundle.getString("TAB_CookieProperties"), holderPanel);
    }

    public void addListeners() {
        this.mgrPropertiesModel.addTableModelListener(this);
        this.storePropertiesModel.addTableModelListener(this);
        this.sessionPropertiesModel.addTableModelListener(this);
        this.cookiePropertiesModel.addTableModelListener(this);
    }

    public void removeListeners() {
        this.mgrPropertiesModel.removeTableModelListener(this);
        this.storePropertiesModel.removeTableModelListener(this);
        this.sessionPropertiesModel.removeTableModelListener(this);
        this.cookiePropertiesModel.removeTableModelListener(this);
    }

    public void initFields(WebAppRoot theBean) {
        ASDDVersion asVersion = theBean.getAppServerVersion();
        SessionConfigSubBean sessonConfigBean = theBean.getSessionConfigBean();
        this.persistenceTypeModel.setSelectedItem(this.getPersistenceTypeMapping(sessonConfigBean.getPersistenceType()));
        this.mgrPropertiesPanel.setModel((CommonDDBean)sessonConfigBean.getManagerProperties(), asVersion);
        this.storePropertiesPanel.setModel((CommonDDBean)sessonConfigBean.getStoreProperties(), asVersion);
        this.sessionPropertiesPanel.setModel((CommonDDBean)sessonConfigBean.getSessionProperties(), asVersion);
        this.cookiePropertiesPanel.setModel((CommonDDBean)sessonConfigBean.getCookieProperties(), asVersion);
    }

    private TextMapping getPersistenceTypeMapping(String xmlKey) {
        TextMapping result = persistenceTypes[0];
        if (xmlKey == null) {
            xmlKey = "";
        }
        for (int i = 0; i < persistenceTypes.length; ++i) {
            if (persistenceTypes[i].getXMLString().compareTo(xmlKey) != 0) continue;
            result = persistenceTypes[i];
            break;
        }
        return result;
    }

    public void tableChanged(TableModelEvent e) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            bean.setDirty();
        }
    }

    public String getHelpId() {
        String result = "AS_CFG_SessionConfigurationManager";
        switch (this.propertyTabbedPanel.getSelectedIndex()) {
            case 3: {
                result = "AS_CFG_SessionConfigurationCookie";
                break;
            }
            case 2: {
                result = "AS_CFG_SessionConfigurationSession";
                break;
            }
            case 1: {
                result = "AS_CFG_SessionConfigurationStore";
            }
        }
        return result;
    }

    public ValidationError.Partition getPartition() {
        switch (this.propertyTabbedPanel.getSelectedIndex()) {
            case 3: {
                return ValidationError.PARTITION_SESSION_COOKIE;
            }
            case 2: {
                return ValidationError.PARTITION_SESSION_SESSION;
            }
            case 1: {
                return ValidationError.PARTITION_SESSION_STORE;
            }
        }
        return ValidationError.PARTITION_SESSION_MANAGER;
    }
}

