/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;

class NodeFactoryPool
extends FolderInstance {
    static final FilterFactory[] EMPTY = new FilterFactory[0];
    ElementNodeFactory base;
    LinkedList explicit;
    FilterFactory[] factories = EMPTY;
    ElementNodeFactory head;
    boolean initialized;

    NodeFactoryPool(DataFolder storage, ElementNodeFactory base) {
        super(storage);
        this.base = base;
        this.head = base;
    }

    final Object sync() {
        return this.base;
    }

    ElementNodeFactory getHead() {
        if (!this.initialized) {
            this.recreate();
            this.waitFinished();
            this.initialized = true;
        }
        return this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        ArrayList<Object> l = new ArrayList<Object>(cookies.length);
        for (int i = 0; i < cookies.length; ++i) {
            try {
                Object o = cookies[i].instanceCreate();
                if (!(o instanceof FilterFactory)) continue;
                l.add(o);
                continue;
            }
            catch (IOException ex) {
                this.logError(ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                this.logError(ex);
            }
        }
        Object object = this.sync();
        synchronized (object) {
            ElementNodeFactory f = this.relinkFactories(l);
            this.factories = l.toArray(new FilterFactory[l.size()]);
            this.head = f;
            return this.head;
        }
    }

    private ElementNodeFactory relinkFactories(Collection first) {
        ElementNodeFactory previous = this.base;
        FilterFactory f = null;
        LinkedList next = this.explicit;
        if (first == null) {
            first = Arrays.asList(this.factories);
        }
        Iterator it = first.iterator();
        while (it.hasNext()) {
            f = (FilterFactory)it.next();
            f.attachTo(previous);
            previous = f;
        }
        if (next != null) {
            it = next.iterator();
            while (it.hasNext()) {
                f = (FilterFactory)it.next();
                f.attachTo(previous);
                previous = f;
            }
        }
        return f != null ? f : this.base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFactory(FilterFactory f) {
        Object object = this.sync();
        synchronized (object) {
            if (this.explicit == null) {
                this.explicit = new LinkedList();
            }
            this.explicit.add(f);
            this.head = this.relinkFactories(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFactory(FilterFactory f) {
        Object object = this.sync();
        synchronized (object) {
            if (!this.explicit.remove(f)) {
                return;
            }
            this.relinkFactories(null);
        }
    }

    void logError(Exception ex) {
        ErrorManager.getDefault().notify((Throwable)ex);
    }
}

