/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.breakpoints;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.web.debug.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JspLineBreakpoint
extends Breakpoint {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    public static final String PROP_LINE_NUMBER = LineBreakpoint.PROP_LINE_NUMBER;
    public static final String PROP_URL = LineBreakpoint.PROP_URL;
    public static final String PROP_CONDITION = LineBreakpoint.PROP_CONDITION;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend = 2;
    private String printText;
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private LineBreakpoint javalb;

    public JspLineBreakpoint() {
    }

    public JspLineBreakpoint(String url, int lineNumber) {
        this.url = url;
        this.lineNumber = lineNumber;
        String pt = NbBundle.getMessage(JspLineBreakpoint.class, (String)"CTL_Default_Print_Text");
        this.printText = Utilities.replaceString((String)pt, (String)"{jspName}", (String)Utils.getJspName(url));
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        Utils.getEM().log("jsp url: " + url);
        String filter = Utils.getClassFilter(url);
        Utils.getEM().log("filter: " + filter);
        this.javalb = LineBreakpoint.create((String)filter, (int)lineNumber);
        this.javalb.setStratum("JSP");
        this.javalb.setSourceName(Utils.getJspName(url));
        this.javalb.setSourcePath(Utils.getJspPath(url));
        this.javalb.setHidden(true);
        this.javalb.setPrintText(this.printText);
        String context = Utils.getContextPath(url);
        String condition = "request.getContextPath().equals(\"" + context + "\")";
        this.javalb.setCondition(condition);
        Utils.getEM().log("condition: " + condition);
        d.addBreakpoint((Breakpoint)this.javalb);
        this.setURL(url);
        this.setLineNumber(lineNumber);
    }

    public static JspLineBreakpoint create(String url, int lineNumber) {
        return new JspLineBreakpoint(url, lineNumber);
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        if (s == this.suspend) {
            return;
        }
        int old = this.suspend;
        this.suspend = s;
        if (this.javalb != null) {
            this.javalb.setSuspend(s);
        }
        this.firePropertyChange(PROP_SUSPEND, new Integer(old), new Integer(s));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        if (h == this.hidden) {
            return;
        }
        boolean old = this.hidden;
        this.hidden = h;
        this.firePropertyChange(PROP_HIDDEN, old, h);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        if (this.printText == printText) {
            return;
        }
        String old = this.printText;
        this.printText = printText;
        if (this.javalb != null) {
            this.javalb.setPrintText(printText);
        }
        this.firePropertyChange(PROP_PRINT_TEXT, old, printText);
    }

    protected void dispose() {
        if (this.javalb != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.javalb);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (this.javalb != null) {
            this.javalb.disable();
        }
        this.firePropertyChange(PROP_ENABLED, Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.javalb != null) {
            this.javalb.enable();
        }
        this.firePropertyChange(PROP_ENABLED, Boolean.FALSE, Boolean.TRUE);
    }

    public void setURL(String url) {
        if (url == this.url || url != null && this.url != null && url.equals(this.url)) {
            return;
        }
        String old = url;
        this.url = url;
        this.firePropertyChange(PROP_URL, old, url);
    }

    public String getURL() {
        return this.url;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int ln) {
        if (ln == this.lineNumber) {
            return;
        }
        int old = this.lineNumber;
        this.lineNumber = ln;
        if (this.javalb != null) {
            this.javalb.setLineNumber(ln);
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(this.getLineNumber()));
    }

    public void setCondition(String c) {
        if (c != null) {
            c = c.trim();
        }
        if (c == this.condition || c != null && this.condition != null && this.condition.equals(c)) {
            return;
        }
        String old = this.condition;
        this.condition = c;
        if (this.javalb != null) {
            this.javalb.setCondition(c);
        }
        this.firePropertyChange(PROP_CONDITION, old, this.condition);
    }

    public String getCondition() {
        return this.condition;
    }

    public String toString() {
        return "JspLineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    public LineBreakpoint getJavalb() {
        return this.javalb;
    }

    public void setJavalb(LineBreakpoint javalb) {
        this.javalb = javalb;
    }

    public void setGroupName(String newGroupName) {
        super.setGroupName(newGroupName);
        this.javalb.setGroupName(newGroupName);
    }
}

