/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddDriverDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class AddDriverAction
extends DatabaseAction {
    static final long serialVersionUID = -109193000951395612L;

    public void performAction(Node[] activatedNodes) {
        new AddDriverDialogDisplayer().showDialog();
    }

    public static final class AddDriverDialogDisplayer {
        private Dialog dialog;
        private JDBCDriver driver;

        public void showDialog() {
            final AddDriverDialog dlgPanel = new AddDriverDialog();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == DialogDescriptor.OK_OPTION) {
                        String name = dlgPanel.getDisplayName();
                        List drvLoc = dlgPanel.getDriverLocation();
                        String drvClass = dlgPanel.getDriverClass();
                        StringBuffer err = new StringBuffer();
                        if (drvLoc.size() < 1) {
                            err.append(DatabaseAction.bundle().getString("AddDriverDialog_MissingFile"));
                        }
                        if (drvClass == null || drvClass.equals("")) {
                            if (err.length() > 0) {
                                err.append(", ");
                            }
                            err.append(DatabaseAction.bundle().getString("AddDriverDialog_MissingClass"));
                        }
                        if (err.length() > 0) {
                            String message = MessageFormat.format(DatabaseAction.bundle().getString("AddDriverDialog_ErrorMessage"), err.toString());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
                            return;
                        }
                        if (AddDriverDialogDisplayer.this.dialog != null) {
                            AddDriverDialogDisplayer.this.dialog.dispose();
                        }
                        if (name == null || name.equals("")) {
                            name = drvClass;
                        }
                        try {
                            AddDriverDialogDisplayer.this.driver = JDBCDriver.create(name, name, drvClass, drvLoc.toArray(new URL[drvLoc.size()]));
                            JDBCDriverManager.getDefault().addDriver(AddDriverDialogDisplayer.this.driver);
                        }
                        catch (DatabaseException exc) {
                            // empty catch block
                        }
                    }
                }
            };
            DialogDescriptor descriptor = new DialogDescriptor((Object)dlgPanel, DatabaseAction.bundle().getString("AddDriverDialogTitle"), true, actionListener);
            Object[] closingOptions = new Object[]{DialogDescriptor.CANCEL_OPTION};
            descriptor.setClosingOptions(closingOptions);
            this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            this.dialog.show();
        }
    }
}

