/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class ConnectionDialog {
    private transient ConnectionDialogMediator mediator;
    private transient JTabbedPane tabs;
    private transient Exception storedExp;
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    final DialogDescriptor descriptor;
    final Dialog dialog;

    public ConnectionDialog(ConnectionDialogMediator mediator, FocusablePanel basePane, JPanel extendPane, String dlgTitle, ActionListener actionListener, ChangeListener tabListener) {
        if (basePane.equals(extendPane)) {
            throw new IllegalArgumentException("The basePane and extendPane must not equal!");
        }
        this.mediator = mediator;
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                ConnectionDialog.this.descriptor.setValid(false);
            }

            public void connectionStep(String step) {
            }

            public void connectionFinished() {
                ConnectionDialog.this.descriptor.setValid(true);
            }

            public void connectionFailed() {
                ConnectionDialog.this.descriptor.setValid(true);
            }
        };
        mediator.addConnectionProgressListener(progressListener);
        PropertyChangeListener propChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName == null || propertyName.equals("valid")) {
                    ConnectionDialog.this.updateValid();
                }
            }
        };
        mediator.addPropertyChangeListener(propChangeListener);
        this.tabs = new JTabbedPane(1);
        this.tabs.addChangeListener(tabListener);
        this.tabs.addTab(this.bundle.getString("BasePanelTitle"), null, basePane, this.bundle.getString("BasePanelHint"));
        this.tabs.addTab(this.bundle.getString("ExtendPanelTitle"), null, extendPane, this.bundle.getString("ExtendPanelHint"));
        this.tabs.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_ConnectDialogA11yName"));
        this.tabs.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ConnectDialogA11yDesc"));
        this.descriptor = new DialogDescriptor((Object)this.tabs, dlgTitle, true, actionListener);
        Object[] closingOptions = new Object[]{DialogDescriptor.CANCEL_OPTION};
        this.descriptor.setClosingOptions(closingOptions);
        this.updateValid();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        basePane.initializeFocus();
        this.dialog.setVisible(false);
    }

    public void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void setVisible(boolean mode) {
        this.dialog.setVisible(mode);
    }

    public void setSelectedComponent(JPanel panel) {
        this.tabs.setSelectedComponent(panel);
    }

    public void setException(Exception e) {
        this.storedExp = e;
    }

    public boolean isException() {
        return this.storedExp != null;
    }

    private void updateValid() {
        boolean valid = this.mediator.getValid();
        this.descriptor.setValid(valid);
        this.tabs.setEnabledAt(1, valid);
    }

    public static abstract class FocusablePanel
    extends JPanel {
        public abstract void initializeFocus();
    }
}

