/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.applet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.NbBundle;

public class AppletSupport {
    private static final SpecificationVersion JDK_15;
    private static final String HTML_EXT = "html";
    private static final String CLASS_EXT = "class";
    private static final String POLICY_FILE_NAME = "applet";
    private static final String POLICY_FILE_EXT = "policy";
    public static Boolean unitTestingSupport_isApplet;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AppletSupport() {
    }

    public static boolean isApplet(FileObject file) {
        if (file == null) {
            return false;
        }
        if (unitTestingSupport_isApplet != null) {
            return unitTestingSupport_isApplet;
        }
        try {
            DataObject classDO = DataObject.find((FileObject)file);
            return AppletSupport.getAppletClassName(classDO.getCookie(SourceCookie.class)) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static String getAppletClassName(Object obj) {
        if (obj == null || !(obj instanceof SourceCookie)) {
            return null;
        }
        SourceCookie cookie = (SourceCookie)obj;
        String fullName = null;
        SourceElement source = cookie.getSource();
        ClassElement[] classes = source.getClasses();
        boolean isApplet = false;
        for (int i = 0; i < classes.length; ++i) {
            JavaClass applet = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("java.applet.Applet");
            JavaClass jApplet = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.swing.JApplet");
            JavaClass javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(classes[i].getName().getFullName());
            if (javaClass instanceof UnresolvedClass || !javaClass.isSubTypeOf((ClassDefinition)applet) && !javaClass.isSubTypeOf((ClassDefinition)jApplet)) continue;
            fullName = classes[i].getName().getFullName();
            return fullName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject generateHtml(FileObject appletFile, FileObject buildDir, FileObject classesDir) throws IOException {
        FileObject htmlFile = buildDir.getFileObject(appletFile.getName(), HTML_EXT);
        if (htmlFile == null) {
            htmlFile = buildDir.createData(appletFile.getName(), HTML_EXT);
        }
        FileLock lock = htmlFile.lock();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(htmlFile.getOutputStream(lock));
            ClassPath cp = ClassPath.getClassPath((FileObject)appletFile, (String)"classpath/execute");
            ClassPath sp = ClassPath.getClassPath((FileObject)appletFile, (String)"classpath/source");
            String path = FileUtil.getRelativePath((FileObject)sp.findOwnerRoot(appletFile), (FileObject)appletFile);
            path = path.substring(0, path.length() - 5);
            String codebase = FileUtil.getRelativePath((FileObject)buildDir, (FileObject)classesDir);
            if (codebase == null) {
                codebase = classesDir.getURL().toString();
            }
            AppletSupport.fillInFile(writer, path + "." + CLASS_EXT, "codebase=\"" + codebase + "\"");
        }
        finally {
            lock.releaseLock();
            if (writer != null) {
                writer.close();
            }
        }
        return htmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateSecurityPolicy(FileObject projectDir) {
        FileObject policyFile = projectDir.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
        try {
            if (policyFile == null) {
                policyFile = projectDir.createData(POLICY_FILE_NAME, POLICY_FILE_EXT);
            }
            FileLock lock = policyFile.lock();
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(policyFile.getOutputStream(lock));
                AppletSupport.fillInPolicyFile(writer);
            }
            finally {
                lock.releaseLock();
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(1, "Problem when generating applet policy file: " + ioe);
        }
        return policyFile;
    }

    public static URL generateHtmlFileURL(FileObject appletFile, FileObject buildDir, FileObject classesDir, String activePlatform) throws FileStateInvalidException {
        FileObject html = null;
        Object ex = null;
        if (appletFile == null || buildDir == null || classesDir == null) {
            return null;
        }
        try {
            html = AppletSupport.generateHtml(appletFile, buildDir, classesDir);
            if (html != null) {
                return AppletSupport.getHTMLPageURL(html, activePlatform);
            }
            return null;
        }
        catch (IOException iex) {
            return null;
        }
    }

    public static URL getHTMLPageURL(FileObject htmlFile, String activePlatform) {
        if (!$assertionsDisabled && htmlFile == null) {
            throw new AssertionError((Object)"htmlFile cannot be null");
        }
        JavaPlatform platform = J2SEProjectUtil.getActivePlatform(activePlatform);
        boolean workAround6193279 = platform != null && platform.getSpecification().getVersion().compareTo((Object)JDK_15) >= 0;
        URL url = null;
        if (workAround6193279) {
            File f = FileUtil.toFile((FileObject)htmlFile);
            try {
                String path = f.getAbsolutePath();
                if (File.separatorChar != '/') {
                    path = path.replace(File.separatorChar, '/');
                }
                url = new URL("file", null, path);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            try {
                url = htmlFile.getURL();
            }
            catch (FileStateInvalidException f) {
                ErrorManager.getDefault().notify((Throwable)f);
            }
        }
        return url;
    }

    private static void fillInFile(PrintWriter writer, String name, String codebase) {
        ResourceBundle bundle = NbBundle.getBundle((Class)AppletSupport.class);
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.print("   <TITLE>");
        writer.print(bundle.getString("GEN_title"));
        writer.println("</TITLE>");
        writer.println("</HEAD>");
        writer.println("<BODY>\n");
        writer.print(bundle.getString("GEN_warning"));
        writer.print("<H3><HR WIDTH=\"100%\">");
        writer.print(bundle.getString("GEN_header"));
        writer.println("<HR WIDTH=\"100%\"></H3>\n");
        writer.println("<P>");
        if (codebase == null) {
            writer.print("<APPLET code=");
        } else {
            writer.print("<APPLET " + codebase + " code=");
        }
        writer.print("\"");
        writer.print(name);
        writer.print("\"");
        writer.println(" width=350 height=200></APPLET>");
        writer.println("</P>\n");
        writer.print("<HR WIDTH=\"100%\"><FONT SIZE=-1><I>");
        writer.print(bundle.getString("GEN_copy"));
        writer.println("</I></FONT>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.flush();
    }

    private static void fillInPolicyFile(PrintWriter writer) {
        writer.println("grant {");
        writer.println("permission java.security.AllPermission;");
        writer.println("};");
        writer.flush();
    }

    static {
        $assertionsDisabled = !AppletSupport.class.desiredAssertionStatus();
        JDK_15 = new SpecificationVersion("1.5");
        unitTestingSupport_isApplet = null;
    }
}

