/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.WeakListeners;

final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private static final String ANT_NAME = "platform.ant.name";
    private static final String J2SE = "j2se";
    private final PropertyEvaluator evaluator;
    private JavaPlatformManager platformManager;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    static final /* synthetic */ boolean $assertionsDisabled;

    public BootClassPathImplementation(PropertyEvaluator evaluator) {
        if (!$assertionsDisabled && evaluator == null) {
            throw new AssertionError();
        }
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    public synchronized List getResources() {
        if (this.resourcesCache == null) {
            JavaPlatform jp = this.findActivePlatform();
            if (jp != null) {
                ClassPath cp = jp.getBootstrapLibraries();
                List entries = cp.entries();
                ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>(entries.size());
                Iterator it = entries.iterator();
                while (it.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)it.next();
                    result.add(ClassPathSupport.createResource((URL)entry.getURL()));
                }
                this.resourcesCache = Collections.unmodifiableList(result);
            } else {
                this.resourcesCache = Collections.EMPTY_LIST;
            }
        }
        return this.resourcesCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private JavaPlatform findActivePlatform() {
        if (this.platformManager == null) {
            this.platformManager = JavaPlatformManager.getDefault();
            this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
        }
        this.activePlatformName = this.evaluator.getProperty(PLATFORM_ACTIVE);
        JavaPlatform activePlatform = J2SEProjectUtil.getActivePlatform(this.activePlatformName);
        this.isActivePlatformValid = activePlatform != null;
        return activePlatform;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.evaluator && evt.getPropertyName().equals(PLATFORM_ACTIVE)) {
            this.resetCache();
        } else if (evt.getSource() == this.platformManager && "installedPlatforms".equals(evt.getPropertyName()) && this.activePlatformName != null) {
            if (this.isActivePlatformValid) {
                if (J2SEProjectUtil.getActivePlatform(this.activePlatformName) == null) {
                    this.resetCache();
                }
            } else if (J2SEProjectUtil.getActivePlatform(this.activePlatformName) != null) {
                this.resetCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    static {
        $assertionsDisabled = !BootClassPathImplementation.class.desiredAssertionStatus();
    }
}

