/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;
import org.netbeans.swing.tabcontrol.TabData;

public final class SlidingButton
extends JToggleButton {
    public static final String UI_CLASS_ID = "SlidingButtonUI";
    private int orientation;
    private TabData data;
    private Timer blinkTimer = null;
    private boolean blinkState = false;

    public SlidingButton(TabData buttonData, int orientation) {
        super(buttonData.getText(), buttonData.getIcon(), false);
        Object slidingName;
        Component comp = buttonData.getComponent();
        if (comp instanceof JComponent && (slidingName = ((JComponent)comp).getClientProperty("SlidingName")) instanceof String) {
            this.setText((String)slidingName);
        }
        this.orientation = orientation;
        this.data = buttonData;
        this.setFocusable(false);
        this.setRolloverEnabled(true);
        this.setIconTextGap(3);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setMargin(new Insets(0, 3, 0, 3));
        this.setBorderPainted(false);
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.setBlinking(false);
    }

    public String getToolTipText() {
        return this.data.getTooltip();
    }

    public void updateUI() {
        ButtonUI ui = (ButtonUI)UIManager.getUI(this);
        if (ui == null) {
            ui = (ButtonUI)SlidingButtonUI.createUI(this);
        }
        this.setUI(ui);
    }

    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isBlinking() {
        return this.blinkState;
    }

    public void setBlinking(boolean val) {
        if (!val && this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
            boolean wasBlinkState = this.blinkState;
            this.blinkState = false;
            if (wasBlinkState) {
                this.repaint();
            }
        } else if (val && this.blinkTimer == null) {
            this.blinkTimer = new Timer(700, new BlinkListener());
            this.blinkState = true;
            this.blinkTimer.start();
            this.repaint();
        }
    }

    public final boolean isBlinkState() {
        return this.blinkState;
    }

    public final Color getBackground() {
        return this.isBlinkState() ? new Color(252, 250, 244) : super.getBackground();
    }

    public TabData getData() {
        return this.data;
    }

    private class BlinkListener
    implements ActionListener {
        private BlinkListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            SlidingButton.this.blinkState = !SlidingButton.this.blinkState;
            SlidingButton.this.repaint();
        }
    }
}

