/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.file.DefaultFileHandler;
import org.netbeans.lib.cvsclient.file.FileDetails;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.GzippedFileHandler;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.GzipFileContentsRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.UnconfiguredRequestException;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.request.ValidResponsesRequest;
import org.netbeans.lib.cvsclient.request.WrapperSendRequest;
import org.netbeans.lib.cvsclient.response.ErrorMessageResponse;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseFactory;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.DefaultIgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.IgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.netbeans.lib.cvsclient.util.Logger;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class Client
implements ClientServices,
ResponseServices {
    private Connection connection;
    private FileHandler transmitFileHandler;
    private FileHandler gzipFileHandler = new GzippedFileHandler();
    private FileHandler uncompFileHandler = new DefaultFileHandler();
    private boolean dontUseGzipFileHandler;
    private Date modifiedDate;
    private AdminHandler adminHandler;
    private String localPath;
    private boolean isFirstCommand = true;
    private final EventManager eventManager = new EventManager(this);
    private GlobalOptions globalOptions;
    private PrintStream stderr = System.err;
    private boolean abort;
    private ResponseFactory responseFactory;
    private IgnoreFileFilter ignoreFileFilter;
    private Map validRequests = new HashMap();
    private Map wrappersMap = null;
    private boolean initialRequestsSent = false;
    private boolean printConnectionReuseWarning = false;
    private static final Set ALLOWED_CONNECTION_REUSE_REQUESTS;
    private LoggedDataInputStream loggedDataInputStream;
    private LoggedDataOutputStream loggedDataOutputStream;
    private boolean warned;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Client(Connection connection, AdminHandler adminHandler) {
        this.setConnection(connection);
        this.setAdminHandler(adminHandler);
        this.ignoreFileFilter = new DefaultIgnoreFileFilter();
        this.dontUseGzipFileHandler = false;
    }

    public void setErrorStream(PrintStream stderr) {
        this.stderr = stderr;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.initialRequestsSent = false;
        this.setIsFirstCommand(true);
    }

    public AdminHandler getAdminHandler() {
        return this.adminHandler;
    }

    public void setAdminHandler(AdminHandler adminHandler) {
        this.adminHandler = adminHandler;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        localPath = localPath.replace('\\', '/');
        while (localPath.endsWith("/")) {
            localPath = localPath.substring(0, localPath.length() - 1);
        }
        this.localPath = localPath;
    }

    public boolean isFirstCommand() {
        return this.isFirstCommand;
    }

    public void setIsFirstCommand(boolean isFirstCommand) {
        this.isFirstCommand = isFirstCommand;
    }

    public FileHandler getUncompressedFileHandler() {
        return this.uncompFileHandler;
    }

    public void setUncompressedFileHandler(FileHandler uncompFileHandler) {
        this.uncompFileHandler = uncompFileHandler;
    }

    public FileHandler getGzipFileHandler() {
        return this.gzipFileHandler;
    }

    public void setGzipFileHandler(FileHandler gzipFileHandler) {
        this.gzipFileHandler = gzipFileHandler;
    }

    public void dontUseGzipFileHandler() {
        this.setGzipFileHandler(new DefaultFileHandler());
        this.dontUseGzipFileHandler = true;
    }

    public boolean isAborted() {
        return this.abort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ensureConnection() throws AuthenticationException {
        BugLog.getInstance().assertNotNull(this.getConnection());
        if (this.getConnection().isOpen()) {
            return;
        }
        final Throwable[] ex = new Throwable[1];
        final boolean[] opened = new boolean[]{false};
        Runnable probe = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    Client.this.getConnection().open();
                    boolean[] blArray = opened;
                    synchronized (opened) {
                        opened[0] = true;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable e) {
                    Throwable[] throwableArray = ex;
                    synchronized (ex) {
                        ex[0] = e;
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                        return;
                    }
                }
            }
        };
        Thread probeThread = new Thread(probe, "CVS Server Probe");
        probeThread.start();
        try {
            probeThread.join(60000L);
            Throwable[] throwableArray = ex;
            synchronized (ex) {
                Throwable wasEx = ex[0];
                // ** MonitorExit[var6_5] (shouldn't be in output)
                if (wasEx != null) {
                    if (wasEx instanceof CommandAbortedException) {
                        this.abort();
                        return;
                    }
                    if (wasEx instanceof AuthenticationException) {
                        throw (AuthenticationException)wasEx;
                    }
                    if (wasEx instanceof RuntimeException) {
                        throw (RuntimeException)wasEx;
                    }
                    if (wasEx instanceof Error) {
                        throw (Error)wasEx;
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)wasEx);
                    }
                }
                boolean[] blArray = opened;
                synchronized (opened) {
                    boolean wasOpened = opened[0];
                    // ** MonitorExit[var7_10] (shouldn't be in output)
                    if (wasOpened) return;
                    probeThread.interrupt();
                    throw new AuthenticationException("Timeout, no response from server.", "Timeout, no response from server.");
                }
            }
        }
        catch (InterruptedException e) {
            probeThread.interrupt();
            this.abort();
        }
    }

    public void processRequests(List requests) throws IOException, UnconfiguredRequestException, ResponseException, CommandAbortedException {
        LoggedDataOutputStream dos;
        if (requests == null || requests.size() == 0) {
            throw new IllegalArgumentException("[processRequests] requests was either null or empty.");
        }
        if (this.abort) {
            throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
        }
        this.loggedDataInputStream = null;
        this.loggedDataOutputStream = null;
        boolean filterRootRequest = true;
        if (this.isFirstCommand()) {
            this.setIsFirstCommand(false);
            int pos = 0;
            if (!this.initialRequestsSent) {
                pos = this.fillInitialRequests(requests);
                this.initialRequestsSent = true;
                filterRootRequest = false;
            }
            if (this.globalOptions != null) {
                Iterator it = this.globalOptions.createRequestList().iterator();
                while (it.hasNext()) {
                    Request request = (Request)it.next();
                    requests.add(pos++, request);
                }
                if (this.globalOptions.isUseGzip() && this.globalOptions.getCompressionLevel() != 0) {
                    requests.add(pos++, new GzipFileContentsRequest(this.globalOptions.getCompressionLevel()));
                }
            }
        } else if (this.printConnectionReuseWarning && System.getProperty("javacvs.multiple_commands_warning") == null) {
            System.err.println("WARNING TO DEVELOPERS:");
            System.err.println("Please be warned that attempting to reuse one open connection for more commands is not supported by cvs servers very well.");
            System.err.println("You are advised to open a new Connection each time.");
            System.err.println("If you still want to proceed, please do: System.setProperty(\"javacvs.multiple_commands_warning\", \"false\")");
            System.err.println("That will disable this message.");
        }
        if (!ALLOWED_CONNECTION_REUSE_REQUESTS.contains(requests.get(requests.size() - 1).getClass())) {
            this.printConnectionReuseWarning = true;
        }
        boolean fireEnhancedEvents = this.getEventManager().isFireEnhancedEventSet();
        int fileDetailRequestCount = 0;
        if (fireEnhancedEvents) {
            Iterator it = requests.iterator();
            while (it.hasNext()) {
                Request request = (Request)it.next();
                FileDetails fileDetails = request.getFileForTransmission();
                if (fileDetails == null || !fileDetails.getFile().exists()) continue;
                ++fileDetailRequestCount;
            }
            EnhancedMessageEvent event = new EnhancedMessageEvent((Object)this, "Requests_Count", new Integer(fileDetailRequestCount));
            this.getEventManager().fireCVSEvent(event);
        }
        this.loggedDataOutputStream = dos = this.connection.getOutputStream();
        LinkedList<Request> streamModifierRequests = new LinkedList<Request>();
        this.transmitFileHandler = this.getUncompressedFileHandler();
        Iterator it = requests.iterator();
        while (it.hasNext()) {
            File file;
            if (this.abort) {
                throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
            }
            Request request = (Request)it.next();
            if (request instanceof GzipFileContentsRequest && this.dontUseGzipFileHandler) {
                this.stderr.println("Warning: The server is not supporting gzip-file-contents request, no compression is used.");
                continue;
            }
            if (request instanceof RootRequest) {
                if (filterRootRequest) continue;
                filterRootRequest = true;
            }
            String requestString = request.getRequestString();
            dos.writeBytes(requestString);
            request.modifyOutputStream(this.connection);
            if (request.modifiesInputStream()) {
                streamModifierRequests.add(request);
            }
            dos = this.connection.getOutputStream();
            FileDetails fileDetails = request.getFileForTransmission();
            if (fileDetails != null && (file = fileDetails.getFile()).exists()) {
                EnhancedMessageEvent event;
                Logger.logOutput(new String("<Sending file: " + file.getAbsolutePath() + ">\n").getBytes("utf8"));
                if (fireEnhancedEvents) {
                    event = new EnhancedMessageEvent((Object)this, "File_Sent_To_Server", file);
                    this.getEventManager().fireCVSEvent(event);
                    --fileDetailRequestCount;
                }
                if (fileDetails.isBinary()) {
                    this.transmitFileHandler.transmitBinaryFile(file, dos);
                } else {
                    this.transmitFileHandler.transmitTextFile(file, dos);
                }
                if (fireEnhancedEvents && fileDetailRequestCount == 0) {
                    event = new EnhancedMessageEvent((Object)this, "All_Requests_Were_Sent", "Ok");
                    this.getEventManager().fireCVSEvent(event);
                }
            }
            if (!request.isResponseExpected()) continue;
            dos.flush();
            Iterator modifiers = streamModifierRequests.iterator();
            while (modifiers.hasNext()) {
                System.err.println("Modifying the inputstream...");
                Request smRequest = (Request)modifiers.next();
                System.err.println("Request is a: " + smRequest.getClass().getName());
                smRequest.modifyInputStream(this.connection);
            }
            streamModifierRequests.clear();
            this.handleResponse();
        }
        dos.flush();
        this.transmitFileHandler = null;
    }

    private ResponseFactory getResponseFactory() {
        if (this.responseFactory == null) {
            this.responseFactory = new ResponseFactory();
        }
        return this.responseFactory;
    }

    private void handleResponse() throws ResponseException, CommandAbortedException {
        try {
            LoggedDataInputStream dis;
            this.loggedDataInputStream = dis = this.connection.getInputStream();
            int ch = -1;
            try {
                ch = dis.read();
            }
            catch (InterruptedIOException ex) {
                this.abort();
            }
            while (!this.abort && ch != -1) {
                StringBuffer responseNameBuffer = new StringBuffer();
                while (ch != -1 && (char)ch != '\n' && (char)ch != ' ') {
                    responseNameBuffer.append((char)ch);
                    try {
                        ch = dis.read();
                    }
                    catch (InterruptedIOException ex) {
                        this.abort();
                        break;
                    }
                }
                String responseString = responseNameBuffer.toString();
                Response response = this.getResponseFactory().createResponse(responseString);
                response.process(dis, this);
                boolean terminal = response.isTerminalResponse();
                if (terminal && response instanceof ErrorMessageResponse) {
                    ErrorMessageResponse errorResponce = (ErrorMessageResponse)response;
                    String errMsg = errorResponce.getMessage();
                    throw new CommandAbortedException(errMsg, errMsg);
                }
                if (terminal || this.abort) break;
                try {
                    ch = dis.read();
                }
                catch (InterruptedIOException ex) {
                    this.abort();
                    break;
                }
            }
            if (this.abort) {
                String localMsg = CommandException.getLocalMessage("Client.commandAborted", null);
                throw new CommandAbortedException("Aborted during request processing", localMsg);
            }
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(Command command, GlobalOptions globalOptions) throws CommandException, CommandAbortedException, AuthenticationException {
        BugLog.getInstance().assertNotNull(command);
        BugLog.getInstance().assertNotNull(globalOptions);
        this.globalOptions = globalOptions;
        this.getUncompressedFileHandler().setGlobalOptions(globalOptions);
        this.getGzipFileHandler().setGlobalOptions(globalOptions);
        try {
            this.eventManager.addCVSListener(command);
            command.execute(this, this.eventManager);
        }
        finally {
            this.eventManager.removeCVSListener(command);
        }
        return !command.hasFailed();
    }

    public long getCounter() {
        long ret = 0L;
        if (this.loggedDataInputStream != null) {
            ret += this.loggedDataInputStream.getCounter();
        }
        if (this.loggedDataOutputStream != null) {
            ret += this.loggedDataOutputStream.getCounter();
        }
        return ret;
    }

    public String convertPathname(String localDirectory, String repository) {
        int lastIndexOfSlash = repository.lastIndexOf(47);
        String filename = repository.substring(lastIndexOfSlash + 1);
        if (localDirectory.startsWith("./")) {
            localDirectory = localDirectory.substring(1);
        }
        if (localDirectory.startsWith("/")) {
            localDirectory = localDirectory.substring(1);
        }
        return this.getLocalPath() + '/' + localDirectory + filename;
    }

    public String getRepository() {
        return this.connection.getRepository();
    }

    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry) throws IOException {
        String absolutePath = this.localPath + '/' + localDirectory;
        if (repositoryPath.startsWith(this.getRepository())) {
            repositoryPath = repositoryPath.substring(this.getRepository().length() + 1);
        } else if (!this.warned) {
            String warning = "#65188 warning C/S protocol error (section 5.10). It's regurarly observed with cvs 1.12.xx servers.\n";
            warning = warning + "  unexpected pathname=" + repositoryPath + " missing root prefix=" + this.getRepository() + "\n";
            warning = warning + "  relaxing, but who knows all consequences....";
            System.err.println(warning);
            this.warned = true;
        }
        this.adminHandler.updateAdminData(absolutePath, repositoryPath, entry, this.globalOptions);
    }

    public void setNextFileDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getNextFileDate() {
        Date copy = this.modifiedDate;
        this.modifiedDate = null;
        return copy;
    }

    public Entry getEntry(File f) throws IOException {
        return this.adminHandler.getEntry(f);
    }

    public Iterator getEntries(File directory) throws IOException {
        return this.adminHandler.getEntries(directory);
    }

    public boolean exists(File file) {
        return this.adminHandler.exists(file);
    }

    public String getRepositoryForDirectory(String directory) throws IOException {
        try {
            String repository = this.adminHandler.getRepositoryForDirectory(directory, this.getRepository());
            return repository;
        }
        catch (IOException ex) {
            try {
                directory = new File(directory).getCanonicalPath();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            directory = directory.replace('\\', '/');
            while (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            String localPathCanonical = this.getLocalPath();
            try {
                localPathCanonical = new File(this.getLocalPath()).getCanonicalPath();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            localPathCanonical = localPathCanonical.replace('\\', '/');
            while (localPathCanonical.endsWith("/")) {
                localPathCanonical = localPathCanonical.substring(0, localPathCanonical.length() - 1);
            }
            int localPathLength = localPathCanonical.length();
            String repository = directory.length() >= localPathLength ? this.getRepository() + directory.substring(localPathLength) : this.getRepository();
            return repository;
        }
    }

    public String getRepositoryForDirectory(File directory) throws IOException {
        return this.adminHandler.getRepositoryForDirectory(directory.getAbsolutePath(), this.getRepository());
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.adminHandler.setEntry(file, entry);
    }

    public void removeEntry(File file) throws IOException {
        this.adminHandler.removeEntry(file);
    }

    public void removeLocalFile(String pathname) throws IOException {
        this.transmitFileHandler.removeLocalFile(pathname);
    }

    public void removeLocalFile(String pathName, String repositoryName) throws IOException {
        int ind = repositoryName.lastIndexOf(47);
        if (ind <= 0) {
            return;
        }
        String fileName = repositoryName.substring(ind + 1);
        String localFile = pathName + fileName;
        File fileToDelete = new File(this.getLocalPath(), localFile);
        this.removeLocalFile(fileToDelete.getAbsolutePath());
        this.removeEntry(fileToDelete);
    }

    public void renameLocalFile(String pathname, String newName) throws IOException {
        this.transmitFileHandler.renameLocalFile(pathname, newName);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public GlobalOptions getGlobalOptions() {
        return this.globalOptions;
    }

    public synchronized void abort() {
        this.abort = true;
    }

    public Set getAllFiles(File directory) throws IOException {
        return this.adminHandler.getAllFiles(directory);
    }

    public void setIgnoreFileFilter(IgnoreFileFilter ignoreFileFilter) {
        this.ignoreFileFilter = ignoreFileFilter;
    }

    public IgnoreFileFilter getIgnoreFileFilter() {
        return this.ignoreFileFilter;
    }

    public boolean shouldBeIgnored(File directory, String noneCvsFile) {
        if (this.ignoreFileFilter != null) {
            return this.ignoreFileFilter.shouldBeIgnored(directory, noneCvsFile);
        }
        return false;
    }

    public String getStickyTagForDirectory(File directory) {
        return this.adminHandler.getStickyTagForDirectory(directory);
    }

    public void setValidRequests(String requests) {
        StringTokenizer tokenizer = new StringTokenizer(requests);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            this.validRequests.put(token, this);
        }
    }

    private int fillInitialRequests(List requests) {
        int pos = 0;
        requests.add(pos++, new RootRequest(this.getRepository()));
        requests.add(pos++, new UseUnchangedRequest());
        requests.add(pos++, new ValidRequestsRequest());
        requests.add(pos++, new ValidResponsesRequest());
        return pos;
    }

    public void addWrapper(StringPattern pattern, KeywordSubstitutionOptions option) {
        if (this.wrappersMap == null) {
            throw new IllegalArgumentException("This method should be called by WrapperSendResponse only.");
        }
        this.wrappersMap.put(pattern, option);
    }

    public Map getWrappersMap() throws CommandException {
        if (this.wrappersMap == null) {
            this.wrappersMap = new HashMap();
            ArrayList<WrapperSendRequest> requests = new ArrayList<WrapperSendRequest>();
            requests.add(new WrapperSendRequest());
            boolean isFirst = this.isFirstCommand();
            try {
                this.processRequests(requests);
            }
            catch (Exception ex) {
                throw new CommandException(ex, "An error during obtaining server wrappers.");
            }
            finally {
                this.setIsFirstCommand(isFirst);
            }
            this.wrappersMap = Collections.unmodifiableMap(this.wrappersMap);
        }
        return this.wrappersMap;
    }

    static {
        $assertionsDisabled = !Client.class.desiredAssertionStatus();
        ALLOWED_CONNECTION_REUSE_REQUESTS = new HashSet<Class>(Arrays.asList(ExpandModulesRequest.class, WrapperSendRequest.class));
    }

    public static interface Factory {
        public Client createClient();
    }
}

