/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class JEEVerificationProblemMark {
    private String problemId;
    private JEEVerificationContextInfo problemContext;
    private Severity severity = Severity.ERROR;
    private JEEVerificationAnnotation annotation;
    private Annotatable attachedAnnotable;

    public JEEVerificationProblemMark(String problemId, String errorMsg, JEEVerificationContextInfo problemContext) {
        this(problemId, errorMsg, problemContext, Severity.ERROR);
    }

    public JEEVerificationProblemMark(String problemId, String errorMsg, JEEVerificationContextInfo problemContext, Severity severity) {
        this.severity = severity;
        this.problemId = problemId;
        this.problemContext = problemContext;
        if (severity != Severity.HINT) {
            this.annotation = new JEEVerificationAnnotation(errorMsg, severity);
        }
    }

    public String getProblemId() {
        return this.problemId;
    }

    public JEEVerificationContextInfo getProblemContext() {
        return this.problemContext;
    }

    public String toString() {
        String pos = "[unbound]";
        if (this.getAttachedAnnotatable() != null) {
            if (this.getAttachedAnnotatable() instanceof Line.Part) {
                Line.Part linePart = (Line.Part)this.getAttachedAnnotatable();
                pos = "[line=" + Integer.toString(linePart.getLine().getLineNumber()) + ", col=" + linePart.getColumn() + ", len=" + linePart.getLength() + "]";
            } else if (this.getAttachedAnnotatable() instanceof Line) {
                pos = "[line=" + Integer.toString(((Line)this.getAttachedAnnotatable()).getLineNumber()) + "]";
            }
        }
        return pos + " id='" + this.problemId + "', severity=" + (Object)((Object)this.severity);
    }

    public void detach() {
        if (this.annotation != null) {
            this.annotation.detach();
        }
    }

    public void attach(Annotatable ann) {
        if (this.annotation != null) {
            this.annotation.attach(ann);
        } else {
            this.attachedAnnotable = ann;
        }
    }

    Annotatable getAttachedAnnotatable() {
        if (this.annotation != null) {
            return this.annotation.getAttachedAnnotatable();
        }
        if (this.attachedAnnotable == null) {
            throw new IllegalStateException("Problem mark " + this.problemId + " is not attached to sources");
        }
        return this.attachedAnnotable;
    }

    private static class JEEVerificationAnnotation
    extends Annotation {
        private final Severity severity;
        private final String errorMsg;

        public JEEVerificationAnnotation(String errorMsg, Severity severity) {
            this.errorMsg = errorMsg;
            this.severity = severity;
        }

        public String getAnnotationType() {
            return this.severity == Severity.ERROR || this.severity == Severity.PORTABILITY_ERROR ? "org-netbeans-modules-j2ee-verification-PersistenceAPIErrorMark" : "org-netbeans-modules-j2ee-verification-PersistenceAPIWarningMark";
        }

        public String getShortDescription() {
            return this.errorMsg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        HINT,
        ERROR,
        WARNING,
        PORTABILITY_ERROR,
        PORTABILITY_WARNING;

    }
}

