/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ejb;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.Rule;
import org.netbeans.modules.j2ee.verification.RulesEngine;
import org.netbeans.modules.j2ee.verification.RulesRepository;
import org.netbeans.modules.j2ee.verification.TreeWalker;
import org.netbeans.modules.j2ee.verification.ejb.rules.annotation.ValueNotSpecifiedForRemoteAnnotationInterface;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.BIDoesNotExtendsEJBObject;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.BeanHasDifferentLBIandRBI;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.BeanImplementsBI;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.BeanUsesLBIasLBI;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.BeanUsesRBIasRBI;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.HasNoArgConstructor;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.LBIdoesNotExtendRemote;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.LocalAnnotatedBeanHasLBI;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.NoFinalizeMethod;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.NonAbstractClass;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.NonFinalClass;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.PublicClass;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.RemoteAnnotatedBeanHasRBI;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.SBSuperClassisNotSB;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.SFSBdoesNotImplementTimedObject;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.SessionSynchImplementedBySFSBOnly;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.TopLevelClass;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.WSisSLSB;
import org.netbeans.modules.j2ee.verification.ejb.rules.constructor.PublicConstructor;
import org.netbeans.modules.j2ee.verification.ejb.rules.method.BMandRemoteExceptionWarning;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;

public class EJBAPIProblemFinder
extends ProblemFinder {
    private static RulesRepository rulesRepository;

    public void parseDocument() {
        if (!this.isApplicable()) {
            return;
        }
        ProblemFinderContext context = this.getContext();
        JavaClass javaClass = context.getMainJavaClass();
        RulesEngine.ErrorHandler errorHandler = new RulesEngine.ErrorHandler(){

            public void onError(Problem problem, Rule rule) {
                JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark(rule.getId(), problem.getMessage(), problem.getProblemContext(), rule.getSeverity());
                EJBAPIProblemFinder.this.attachProblemMarkToElement(problemMark, problem.getProblemContext().getElement());
                EJBAPIProblemFinder.this.addProblemMark(problemMark);
            }
        };
        RulesEngine rulesEngine = new RulesEngine(errorHandler, context, rulesRepository);
        new TreeWalker(rulesEngine).visitClass(javaClass);
    }

    protected boolean isApplicable() {
        J2eeModule j2eeModule;
        J2eeModuleProvider j2eeModuleProvider;
        Project project;
        ProblemFinderContext context = this.getContext();
        JavaClass javaClass = context.getMainJavaClass();
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        if (fo != null && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && (j2eeModuleProvider = (J2eeModuleProvider)J2eeModuleProvider.class.cast(project.getLookup().lookup(J2eeModuleProvider.class))) != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            Object type = j2eeModule.getModuleType();
            double version = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.EJB.equals(type) && version > 2.1) {
                JEEVerificationAnnotationProvider.tmpDbg("Project module type is EJB 3.0 or higher, so activating EJB verification rules engine.");
                return true;
            }
        }
        return false;
    }

    static {
        try {
            rulesRepository = new RulesRepository();
            rulesRepository.registerClazzRule(NonFinalClass.class.getName());
            rulesRepository.registerClazzRule(NonAbstractClass.class.getName());
            rulesRepository.registerClazzRule(PublicClass.class.getName());
            rulesRepository.registerClazzRule(TopLevelClass.class.getName());
            rulesRepository.registerClazzRule(SBSuperClassisNotSB.class.getName());
            rulesRepository.registerClazzRule(HasNoArgConstructor.class.getName());
            rulesRepository.registerClazzRule(NoFinalizeMethod.class.getName());
            rulesRepository.registerClazzRule(SessionSynchImplementedBySFSBOnly.class.getName());
            rulesRepository.registerClazzRule(BIDoesNotExtendsEJBObject.class.getName());
            rulesRepository.registerClazzRule(BeanHasDifferentLBIandRBI.class.getName());
            rulesRepository.registerClazzRule(LocalAnnotatedBeanHasLBI.class.getName());
            rulesRepository.registerClazzRule(RemoteAnnotatedBeanHasRBI.class.getName());
            rulesRepository.registerClazzRule(BeanUsesLBIasLBI.class.getName());
            rulesRepository.registerClazzRule(BeanUsesRBIasRBI.class.getName());
            rulesRepository.registerClazzRule(WSisSLSB.class.getName());
            rulesRepository.registerClazzRule(SFSBdoesNotImplementTimedObject.class.getName());
            rulesRepository.registerClazzRule(BeanImplementsBI.class.getName());
            rulesRepository.registerClazzRule(LBIdoesNotExtendRemote.class.getName());
            rulesRepository.registerAnnotationRule(ValueNotSpecifiedForRemoteAnnotationInterface.class.getName());
            rulesRepository.registerConstructorRule(PublicConstructor.class.getName());
            rulesRepository.registerMethodRule(BMandRemoteExceptionWarning.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface RuleNames {
        public static final String ValueNotSpecifiedForRemoteAnnotationInterface = "ValueNotSpecifiedForRemoteAnnotationInterface";
        public static final String NonFinalClass = "NonFinalClass";
        public static final String PublicClass = "PublicClass";
        public static final String HasNoArgConstructor = "HasNoArgConstructor";
        public static final String NoFinalizeMethod = "NoFinalizeMethod";
        public static final String SBSuperClassisNotSB = "SBSuperClassisNotSB";
        public static final String NonAbstractClass = "NonAbstractClass";
        public static final String TopLevelClass = "TopLevelClass";
        public static final String PublicConstructor = "PublicConstructor";
        public static final String SessionSynchImplementedBySFSBOnly = "SessionSynchImplementedBySFSBOnly";
        public static final String BIDoesNotExtendsEJBObject = "BIDoesNotExtendsEJBObject";
        public static final String BeanHasDifferentLBIandRBI = "BeanHasDifferentLBIandRBI";
        public static final String LocalAnnotatedBeanHasLBI = "LocalAnnotatedBeanHasLBI";
        public static final String RemoteAnnotatedBeanHasRBI = "RemoteAnnotatedBeanHasRBI";
        public static final String BeanUsesRBIasRBI = "BeanUsesRBIasRBI";
        public static final String BeanUsesLBIasLBI = "BeanUsesLBIasLBI";
        public static final String WSisSLSB = "WSisSLSB";
        public static final String SFSBdoesNotImplementTimedObject = "SFSBdoesNotImplementTimedObject";
        public static final String BeanImplementsBI = "BeanImplementsBI";
        public static final String BMandRemoteExceptionWarning = "BMandRemoteExceptionWarning";
        public static final String LBIdoesNotExtendRemote = "LBIdoesNotExtendRemote";
        public static final String BMnotPartOfRBIandLBI = "BMnotPartOfRBIandLBI";
    }
}

