/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.NamedQuery;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;

public class NamedQueryUnique
extends AbstractRule {
    protected String getMessageKey() {
        return "MSG_NamedQueryUnique";
    }

    public String getId() {
        return "NamedQueryUnique";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        Annotation annotation;
        AnnotationType type;
        if (ctx.isIsEntityClass() && (type = (annotation = (Annotation)Annotation.class.cast(subject)).getType()) != null && "javax.persistence.NamedQuery".equals(type.getName())) {
            return super.isApplicable(subject, ctx);
        }
        return false;
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Annotation annotation = (Annotation)Annotation.class.cast(subject);
            String queryName = NamedQueryUnique.getNameOfQuery(annotation);
            int count = 0;
            EntityMappings entityMapping = ctx.getEntityMapping();
            if (queryName != null && entityMapping != null) {
                for (NamedQuery namedQuery : entityMapping.getNamedQuery()) {
                    if (queryName.equals(namedQuery.getName())) {
                        ++count;
                    }
                    if (count <= 1) continue;
                    return this.createProblem(ctx, subject);
                }
                for (NamedQuery namedQuery : entityMapping.getEntity()) {
                    for (NamedQuery nq : namedQuery.getNamedQuery()) {
                        if (queryName.equals(nq.getName())) {
                            ++count;
                        }
                        if (count <= 1) continue;
                        return this.createProblem(ctx, subject);
                    }
                }
            }
        }
        return null;
    }

    private static String getNameOfQuery(Annotation entity) {
        for (AttributeValue attrValue : entity.getAttributeValues()) {
            InitialValue value;
            if (!"name".equals(attrValue.getName()) || !((value = attrValue.getValue()) instanceof StringLiteral)) continue;
            return ((StringLiteral)StringLiteral.class.cast(value)).getValue();
        }
        return null;
    }
}

