/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ws.checks;

import java.util.MissingResourceException;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

public class OnewayAnnotationChecks
extends ProblemFinder {
    public void parseDocument() {
        JavaClass javaClass = this.getMainJavaClass();
        if (ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.jws.WebService") == null) {
            return;
        }
        Element[] members = javaClass.getContents().toArray(new Element[0]);
        for (int i = 0; i < members.length; ++i) {
            Method method;
            Annotation oneWayAnn;
            if (!(members[i] instanceof Method) || (oneWayAnn = ProblemFindingUtils.findAnnotation((AnnotableElement)(method = (Method)members[i]), "javax.jws.Oneway")) == null) continue;
            this.checkIfIsAWebMethod(javaClass, method, oneWayAnn);
            this.checkIfHasAReturnValue(method, javaClass, oneWayAnn);
            this.checkIfHasNoOutParams(javaClass, method, oneWayAnn);
            this.checkIfDeclaresNoExceptions(javaClass, method, oneWayAnn);
        }
    }

    private void checkIfHasNoOutParams(JavaClass javaClass, Method method, Annotation oneWayAnn) throws MissingResourceException {
        for (Parameter param : method.getParameters()) {
            Annotation annWebParam = ProblemFindingUtils.findAnnotation((AnnotableElement)param, "javax.jws.WebParam");
            if (annWebParam == null) continue;
            for (AttributeValue attr : annWebParam.getAttributeValues()) {
                String modeValue;
                if (!"mode".equals(attr.getName()) || !"OUT".equals(modeValue = ((NamedElement)attr.getValue()).getName()) && !"INOUT".equals(modeValue)) continue;
                JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
                problemContext.setElement((Element)oneWayAnn);
                JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_not_have_out_params", NbBundle.getMessage(this.getClass(), (String)"MSG_OnewayMethodMustNotHaveOutParams"), problemContext);
                this.attachProblemMarkToElement(problemMark, (Element)oneWayAnn);
                this.addProblemMark(problemMark);
            }
        }
    }

    private void checkIfHasAReturnValue(Method method, JavaClass javaClass, Annotation oneWayAnn) throws MissingResourceException {
        if (method.getType() == null || !"void".equals(method.getType().getName())) {
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            problemContext.setElement((Element)oneWayAnn);
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_not_have_return_value", NbBundle.getMessage(this.getClass(), (String)"MSG_OnewayMethodMustNotHaveReturnvalue"), problemContext);
            this.attachProblemMarkToElement(problemMark, (Element)oneWayAnn);
            this.addProblemMark(problemMark);
        }
    }

    private void checkIfIsAWebMethod(JavaClass javaClass, Method method, Annotation oneWayAnn) throws MissingResourceException {
        if (ProblemFindingUtils.findAnnotation((AnnotableElement)method, "javax.jws.WebMethod") == null) {
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            problemContext.setElement((Element)oneWayAnn);
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_have_corresponding_webmethod", NbBundle.getMessage(this.getClass(), (String)"MSG_OnewayMustHaveCorrespondingWebmethod"), problemContext);
            this.attachProblemMarkToElement(problemMark, (Element)oneWayAnn);
            this.addProblemMark(problemMark);
        }
    }

    private void checkIfDeclaresNoExceptions(JavaClass javaClass, Method method, Annotation oneWayAnn) {
        if (method.getExceptions() != null && method.getExceptions().size() > 0) {
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            problemContext.setElement((Element)oneWayAnn);
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_not_declare_exceptions", NbBundle.getMessage(this.getClass(), (String)"MSG_OnewayMustNotDeclareExceptions"), problemContext);
            this.attachProblemMarkToElement(problemMark, (Element)oneWayAnn);
            this.addProblemMark(problemMark);
        }
    }
}

