/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.classpath.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class ProjectClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener,
Runnable {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final File projectFolder;
    private List resources;
    private final PropertyEvaluator evaluator;
    private boolean dirty = false;
    private final List propertyNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectClassPathImplementation(File projectFolder, String[] propertyNames, PropertyEvaluator evaluator) {
        if (!($assertionsDisabled || projectFolder != null && propertyNames != null && evaluator != null)) {
            throw new AssertionError();
        }
        this.projectFolder = projectFolder;
        this.evaluator = evaluator;
        this.propertyNames = Arrays.asList(propertyNames);
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    public synchronized List getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop != null && !this.propertyNames.contains(evt.getPropertyName())) {
            return;
        }
        if (!this.dirty) {
            this.dirty = true;
            ProjectManager.mutex().postReadRequest((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.dirty = false;
        List newRoots = this.getPath();
        boolean fire = false;
        ProjectClassPathImplementation projectClassPathImplementation = this;
        synchronized (projectClassPathImplementation) {
            if (this.resources != null && !((Object)this.resources).equals(newRoots)) {
                this.resources = newRoots;
                fire = true;
            }
        }
        if (fire) {
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List getPath() {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        Iterator it = this.propertyNames.iterator();
        while (it.hasNext()) {
            String prop = this.evaluator.getProperty((String)it.next());
            if (prop == null) continue;
            String[] pieces = PropertyUtils.tokenizePath((String)prop);
            for (int i = 0; i < pieces.length; ++i) {
                File f = PropertyUtils.resolveFile((File)this.projectFolder, (String)pieces[i]);
                try {
                    URL entry = f.toURI().toURL();
                    if (FileUtil.isArchiveFile((URL)entry) || f.isFile() && f.length() < 4L) {
                        entry = FileUtil.getArchiveRoot((URL)entry);
                    } else if (!f.exists()) {
                        if (!$assertionsDisabled && entry.toExternalForm().endsWith("/")) {
                            throw new AssertionError(f);
                        }
                        entry = new URL(entry.toExternalForm() + "/");
                    } else if (f.isFile()) {
                        ErrorManager.getDefault().log(65536, "ProjectClassPathImplementation: file: " + f.getAbsolutePath() + " is not a valid archive file.");
                        continue;
                    }
                    result.add(ClassPathSupport.createResource((URL)entry));
                    continue;
                }
                catch (MalformedURLException mue) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)mue);
                    }
                    continue;
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    static {
        $assertionsDisabled = !ProjectClassPathImplementation.class.desiredAssertionStatus();
    }
}

