/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonGeneralFinishVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class CommonGeneralFinishPanel
extends ResourceWizardPanel {
    private CommonGeneralFinishVisualPanel component;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private String[] groupNames;
    private boolean setupValid = true;

    public CommonGeneralFinishPanel(ResourceConfigHelper helper, Wizard wizardInfo, String[] groupNames) {
        this.helper = helper;
        this.wizardInfo = wizardInfo;
        this.groupNames = groupNames;
    }

    public Component getComponent() {
        if (this.component == null) {
            FieldGroup[] groups = new FieldGroup[this.groupNames.length];
            for (int i = 0; i < this.groupNames.length; ++i) {
                groups[i] = FieldGroupHelper.getFieldGroup(this.wizardInfo, this.groupNames[i]);
            }
            String panelType = null;
            if (this.wizardInfo.getName().equals("mail-resource")) {
                panelType = "_MAIL";
            }
            this.component = new CommonGeneralFinishVisualPanel(this, groups, panelType);
        }
        return this.component;
    }

    public boolean createNew() {
        if (this.component == null) {
            return false;
        }
        return this.component.createNew();
    }

    public String getResourceName() {
        return this.wizardInfo.getName();
    }

    public HelpCtx getHelp() {
        if (this.wizardInfo.getName().equals("mail-resource")) {
            return new HelpCtx("AS_Wiz_Mail_general");
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public ResourceConfigHelper getHelper() {
        return this.helper;
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(this.bundle.getString("Empty_String"));
        if (this.component != null && this.component.jLabels != null && this.component.jFields != null) {
            for (int i = 0; i < this.component.jLabels.length; ++i) {
                String from;
                String user;
                String host;
                String jLabel = this.component.jLabels[i].getText();
                if (jLabel.equals(this.bundle.getString("LBL_jndi-name"))) {
                    String jndiName = ((JTextField)this.component.jFields[i]).getText();
                    if (jndiName == null || jndiName.length() == 0) {
                        this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
                        return false;
                    }
                    if (!ResourceUtils.isLegalResourceName(jndiName)) {
                        return false;
                    }
                    if (!ResourceUtils.isUniqueFileName(jndiName, this.helper.getData().getTargetFileObject(), "mail/mySession")) {
                        this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
                        return false;
                    }
                }
                if (!this.wizardInfo.getName().equals("mail-resource")) continue;
                if (jLabel.equals(this.bundle.getString("LBL_host")) && ((host = ((JTextField)this.component.jFields[i]).getText()) == null || host.length() == 0)) {
                    this.setErrorMessage(this.bundle.getString("Err_EmptyValue"), jLabel);
                    return false;
                }
                if (jLabel.equals(this.bundle.getString("LBL_user")) && ((user = ((JTextField)this.component.jFields[i]).getText()) == null || user.length() == 0)) {
                    this.setErrorMessage(this.bundle.getString("Err_EmptyValue"), jLabel);
                    return false;
                }
                if (!jLabel.equals(this.bundle.getString("LBL_from")) || (from = ((JTextField)this.component.jFields[i]).getText()) != null && from.length() != 0) continue;
                this.setErrorMessage(this.bundle.getString("Err_EmptyValue"), jLabel);
                return false;
            }
        }
        return true;
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    public void readSettings(Object settings) {
        this.wizDescriptor = (WizardDescriptor)settings;
        if (this.wizardInfo.getName().equals("mail-resource")) {
            TemplateWizard wizard = (TemplateWizard)settings;
            String targetName = wizard.getTargetName();
            FileObject resFolder = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
            this.helper.getData().setTargetFileObject(resFolder);
            if (resFolder != null) {
                targetName = ResourceUtils.createUniqueFileName(targetName, resFolder, "mail/mySession");
                this.helper.getData().setTargetFile(targetName);
                if (this.component == null) {
                    this.getComponent();
                }
                this.component.setHelper(this.helper);
            } else {
                this.setupValid = false;
            }
        }
    }

    public void initData() {
        this.component.initData();
    }

    private boolean setupValid() {
        return this.setupValid;
    }
}

