/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.IOException;
import javax.sql.DataSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.spi.ejbjar.CarImplementation;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class JarContainerImpl
extends EnterpriseReferenceContainer {
    private Project webProject;
    private AntProjectHelper antHelper;
    private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";
    private AppClient webApp;

    public JarContainerImpl(Project p, ReferenceHelper helper, AntProjectHelper antHelper) {
        this.webProject = p;
        this.antHelper = antHelper;
    }

    public void setServiceLocatorName(String serviceLocator) throws IOException {
        EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
        ep.setProperty(SERVICE_LOCATOR_PROPERTY, serviceLocator);
        this.antHelper.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject(this.webProject);
    }

    public ResourceRef createResourceRef(String className) throws IOException {
        ResourceRef ref = null;
        try {
            ref = (ResourceRef)this.getAppClient().createBean("ResourceRef");
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException();
            ioe.initCause(cnfe);
            throw ioe;
        }
        return ref;
    }

    public MessageDestinationRef createDestinationRef(String className) throws IOException {
        MessageDestinationRef ref = null;
        try {
            ref = (MessageDestinationRef)this.getAppClient().createBean("MessageDestinationRef");
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException();
            ioe.initCause(cnfe);
            throw ioe;
        }
        return ref;
    }

    public String addResourceRef(ResourceRef ref, String referencingClass) throws IOException {
        String resourceRefName = ref.getResRefName();
        AppClient ac = this.getAppClient();
        if (DataSource.class.getName().equals(ref.getResType())) {
            ResourceRef[] refs = ac.getResourceRef();
            for (int i = 0; i < refs.length; ++i) {
                boolean canCompareDefDesc;
                String newDefaultDescription = ref.getDefaultDescription();
                String existingDefaultDescription = refs[i].getDefaultDescription();
                boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                if (!DataSource.class.getName().equals(refs[i].getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(refs[i].getResRefName())) continue;
                return refs[i].getResRefName();
            }
        }
        if (!JarContainerImpl.isResourceRefUsed(ac, ref)) {
            resourceRefName = this.getUniqueName(ac, "ResourceRef", "ResRefName", ref.getResRefName());
            ref.setResRefName(resourceRefName);
            this.getAppClient().addResourceRef(ref);
            this.writeDD();
        }
        return resourceRefName;
    }

    public String addEjbLocalReference(EjbLocalRef localRef, String referencedClassName, AntArtifact target) throws IOException {
        return this.addReference(localRef, target);
    }

    public String addEjbReferernce(EjbRef ref, String referenceClassName, AntArtifact target) throws IOException {
        return this.addReference(ref, target);
    }

    public String addDestinationRef(MessageDestinationRef ref, String referencingClass) throws IOException {
        String refName = this.getUniqueName(this.getAppClient(), "MessageDestinationRef", "MessageDestinationRefName", ref.getMessageDestinationRefName());
        ref.setMessageDestinationRefName(refName);
        try {
            this.getAppClient().addMessageDestinationRef(ref);
            this.writeDD();
        }
        catch (VersionNotSupportedException ex) {
            // empty catch block
        }
        return refName;
    }

    public String getServiceLocatorName() {
        EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
        return ep.getProperty(SERVICE_LOCATOR_PROPERTY);
    }

    private AppClient getAppClient() throws IOException {
        if (this.webApp == null) {
            CarImplementation jp = (CarImplementation)this.webProject.getLookup().lookup(CarImplementation.class);
            FileObject fo = jp.getDeploymentDescriptor();
            this.webApp = DDProvider.getDefault().getDDRoot(fo);
        }
        return this.webApp;
    }

    private String getUniqueName(AppClient wa, String beanName, String property, String originalValue) {
        String proposedValue = originalValue;
        int index = 1;
        while (wa.findBeanByName(beanName, property, proposedValue) != null) {
            proposedValue = originalValue + Integer.toString(index++);
        }
        return proposedValue;
    }

    private void writeDD() throws IOException {
        CarImplementation jp = (CarImplementation)this.webProject.getLookup().lookup(CarImplementation.class);
        if (JarContainerImpl.isDescriptorMandatory(jp.getJ2eePlatformVersion())) {
            FileObject fo = jp.getDeploymentDescriptor();
            this.getAppClient().write(fo);
        }
    }

    private String addReference(Object ref, AntArtifact target) throws IOException {
        ProjectClassPathExtender cpExtender;
        String refName = null;
        AppClient webApp = this.getAppClient();
        if (ref instanceof EjbRef) {
            EjbRef ejbRef = (EjbRef)ref;
            refName = this.getUniqueName(this.getAppClient(), "EjbRef", "EjbRefName", ejbRef.getEjbRefName());
            ejbRef.setEjbRefName(refName);
            try {
                EjbRef newRef = (EjbRef)webApp.createBean("EjbRef");
                try {
                    newRef.setAllDescriptions(ejbRef.getAllDescriptions());
                }
                catch (VersionNotSupportedException ex) {
                    newRef.setDescription(ejbRef.getDefaultDescription());
                }
                newRef.setEjbRefName(ejbRef.getEjbRefName());
                newRef.setEjbRefType(ejbRef.getEjbRefType());
                newRef.setHome(ejbRef.getHome());
                newRef.setRemote(ejbRef.getRemote());
                this.getAppClient().addEjbRef(newRef);
            }
            catch (ClassNotFoundException ex) {}
        } else if (ref instanceof EjbLocalRef) {
            System.err.println("### UNSUPPORTED ###");
        }
        if ((cpExtender = (ProjectClassPathExtender)this.webProject.getLookup().lookup(ProjectClassPathExtender.class)) != null) {
            try {
                AntArtifactChooser.ArtifactItem[] artifactItems = new AntArtifactChooser.ArtifactItem[1];
                cpExtender.addAntArtifact(target, target.getArtifactLocations()[0].normalize());
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        } else {
            ErrorManager.getDefault().log("WebProjectClassPathExtender not found in the project lookup of project: " + this.webProject.getProjectDirectory().getPath());
        }
        this.writeDD();
        return refName;
    }

    private static boolean isDescriptorMandatory(String j2eeVersion) {
        return "1.3".equals(j2eeVersion) || "1.4".equals(j2eeVersion);
    }

    private static boolean isResourceRefUsed(AppClient ac, ResourceRef resRef) {
        String resRefName = resRef.getResRefName();
        String resRefType = resRef.getResType();
        for (ResourceRef existingRef : ac.getResourceRef()) {
            if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
            return true;
        }
        return false;
    }
}

