/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.j2ee.deployment.config.Utils;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class DebugAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Debug");
    }

    protected void performAction(Node[] nodes) {
        DebugAction.performActionImpl(nodes);
    }

    protected boolean enable(Node[] nodes) {
        return DebugAction.enableImpl(nodes);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            final ServerInstance si = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (si == null) continue;
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String title = NbBundle.getMessage(DebugAction.class, (String)"LBL_Debugging", (Object)si.getDisplayName());
                    ProgressUI progressUI = new ProgressUI(title, false);
                    try {
                        progressUI.start();
                        si.startDebug(progressUI);
                    }
                    catch (ServerException ex) {
                        String msg = ex.getLocalizedMessage();
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    finally {
                        progressUI.finish();
                    }
                }
            });
        }
    }

    private static boolean enableImpl(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance si = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (si != null && si.getServerState() == 2 && si.isDebugSupported()) continue;
            return false;
        }
        return true;
    }

    public static class OutputAction
    extends AbstractAction
    implements ServerInstance.StateListener {
        private static final String ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/debug.png";
        private static final String PROP_ENABLED = "enabled";
        private Node node;

        public OutputAction(Node node) {
            super(NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutput"), new ImageIcon(Utilities.loadImage((String)ICON)));
            this.putValue("ShortDescription", NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutputDesc"));
            this.node = node;
            ServerInstance si = (ServerInstance)node.getCookie(ServerInstance.class);
            si.addStateListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            DebugAction.performActionImpl(new Node[]{this.node});
        }

        public boolean isEnabled() {
            return DebugAction.enableImpl(new Node[]{this.node});
        }

        public void stateChanged(int oldState, int newState) {
            Utils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    OutputAction.this.firePropertyChange(OutputAction.PROP_ENABLED, null, OutputAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }
}

