/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.test;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import org.netbeans.lib.gjast.ASScanner;
import org.netbeans.lib.java.parser.JScanner;

public final class DumpIdentifiers {
    static /* synthetic */ Class class$org$netbeans$lib$gjast$test$DumpIdentifiers;

    public static void main(String[] args) {
        String sourceLevel = "1.4";
        boolean lite = false;
        if (args.length == 0) {
            System.err.println("java DumpASTree [-source <level>] [-lite] <file> [<file> ...]");
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-source")) {
                sourceLevel = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-lite")) {
                lite = true;
                ++i;
                continue;
            }
            DumpIdentifiers.dump(args[i++], sourceLevel, lite);
        }
    }

    public static void dump(String filename, String sourceLevel, boolean lite) {
        try {
            FileReader fileIn = new FileReader(filename);
            JScanner scanner = ASScanner.Factory.newScanner(fileIn, sourceLevel, lite);
            DumpIdentifiers.dump(filename, scanner);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void dump(String filename, JScanner scanner) throws IOException {
        int token;
        System.out.println("Dumping " + filename + "\n");
        int ids = 0;
        HashSet<String> hashSet = new HashSet<String>(2048, 0.5f);
        IntSet intSet = new IntSet();
        while ((token = scanner.yylex()) != 0) {
            boolean newHash;
            boolean newID;
            if (token != 361) continue;
            String id = scanner.yytext();
            int hash = id.hashCode();
            int yyhash = scanner.yyhash();
            System.out.print(Integer.toString(++ids) + " \"" + id + "\" yyhash=" + scanner.yyhash());
            if (yyhash != hash) {
                System.out.print(" hash=" + id.hashCode() + " !!!");
            }
            if ((newID = hashSet.add(id)) != (newHash = intSet.add(hash))) {
                System.out.print(" set mismatch: newID=" + newID + " newHash=" + newHash + " !!!");
            }
            System.out.println();
        }
    }

    static class IntSet {
        Entry[] table;
        int size;
        static final int LOAD_FACTOR = 2;
        static final int GROWTH_FACTOR = 2;
        static final /* synthetic */ boolean $assertionsDisabled;

        public IntSet() {
            this(2048);
        }

        public IntSet(int capacity) {
            this.table = new Entry[capacity];
        }

        public boolean add(int x) {
            Entry e;
            if (this.contains(x)) {
                return false;
            }
            if (this.size > this.table.length / 2) {
                this.resize();
            }
            int h = IntSet.hash(x);
            int idx = IntSet.indexFor(h, this.table.length);
            this.table[idx] = e = new Entry(x, h, this.table[idx]);
            ++this.size;
            return true;
        }

        private void resize() {
            Entry[] newt = new Entry[this.table.length * 2];
            for (int i = 0; i < this.table.length; ++i) {
                Entry e = this.table[i];
                while (e != null) {
                    int idx = IntSet.indexFor(e.hash, newt.length);
                    Entry eNext = e.next;
                    e.next = newt[idx];
                    newt[idx] = e;
                    e = eNext;
                }
            }
            this.table = newt;
            System.out.println("IntSet: table doubled to " + this.table.length);
        }

        public boolean contains(int x) {
            int h = IntSet.hash(x);
            Entry e = this.table[IntSet.indexFor(h, this.table.length)];
            while (e != null) {
                if (e.value == x) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        public int[] toArray() {
            int[] arr = new int[this.size];
            int n = 0;
            for (int i = 0; i < this.table.length; ++i) {
                Entry e = this.table[i];
                while (e != null) {
                    arr[n++] = e.value;
                    e = e.next;
                }
            }
            if (!$assertionsDisabled && n != this.size) {
                throw new AssertionError();
            }
            return arr;
        }

        static int hash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        static int indexFor(int h, int length) {
            return h & length - 1;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$lib$gjast$test$DumpIdentifiers == null ? (class$org$netbeans$lib$gjast$test$DumpIdentifiers = DumpIdentifiers.class$("org.netbeans.lib.gjast.test.DumpIdentifiers")) : class$org$netbeans$lib$gjast$test$DumpIdentifiers).desiredAssertionStatus();
        }

        static class Entry {
            int value;
            int hash;
            Entry next;

            Entry(int v, int h, Entry n) {
                this.value = v;
                this.hash = h;
                this.next = n;
            }
        }
    }
}

