/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractTreeDocument;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;
import org.netbeans.tax.spec.Document;

public class TreeDocument
extends AbstractTreeDocument
implements TreeDocumentRoot {
    public static final String PROP_VERSION = "version";
    public static final String PROP_ENCODING = "encoding";
    public static final String PROP_STANDALONE = "standalone";
    private TreeEventManager eventManager;
    private String version;
    private String encoding;
    private String standalone;
    private TreeDocumentType documentType;
    private TreeElement rootElement;

    public TreeDocument(String version, String encoding, String standalone) throws InvalidArgumentException {
        this.checkVersion(version);
        this.checkEncoding(encoding);
        this.checkStandalone(standalone);
        this.checkHeader(version, encoding, standalone);
        this.version = version;
        this.encoding = encoding;
        this.standalone = standalone;
        this.eventManager = new TreeEventManager();
        this.documentType = null;
        this.rootElement = null;
    }

    public TreeDocument() throws InvalidArgumentException {
        this(null, null, null);
    }

    protected TreeDocument(TreeDocument document, boolean deep) {
        super(document, deep);
        this.version = document.version;
        this.encoding = document.encoding;
        this.standalone = document.standalone;
        this.eventManager = new TreeEventManager(document.eventManager);
    }

    public Object clone(boolean deep) {
        return new TreeDocument(this, deep);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeDocument peer = (TreeDocument)object;
        if (!Util.equals(this.getVersion(), peer.getVersion())) {
            return false;
        }
        if (!Util.equals(this.getEncoding(), peer.getEncoding())) {
            return false;
        }
        if (!Util.equals(this.getStandalone(), peer.getStandalone())) {
            return false;
        }
        if (!Util.equals(this.documentType, peer.documentType)) {
            return false;
        }
        return Util.equals(this.rootElement, peer.rootElement);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDocument::merge: " + treeObject);
        }
        super.merge(treeObject);
        TreeDocument peer = (TreeDocument)treeObject;
        try {
            this.setVersionImpl(peer.getVersion());
            this.setEncodingImpl(peer.getEncoding());
            this.setStandaloneImpl(peer.getStandalone());
        }
        catch (Exception exc) {
            throw new CannotMergeException(treeObject, exc);
        }
        TreeEventManager manager = this.getEventManager();
        if (manager != null) {
            manager.setFirePolicy((short)1);
        }
    }

    public final String getVersion() {
        return this.version;
    }

    private final void setVersionImpl(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        this.firePropertyChange(PROP_VERSION, oldVersion, newVersion);
    }

    public final void setVersion(String newVersion) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.version, newVersion)) {
            return;
        }
        this.checkReadOnly();
        this.checkVersion(newVersion);
        this.checkHeader(newVersion, this.encoding, this.standalone);
        this.setVersionImpl(newVersion);
    }

    protected final void checkVersion(String version) throws InvalidArgumentException {
        TreeUtilities.checkDocumentVersion(version);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    private final void setEncodingImpl(String newEncoding) {
        String oldEncoding = this.encoding;
        this.encoding = newEncoding;
        this.firePropertyChange(PROP_ENCODING, oldEncoding, newEncoding);
    }

    public final void setEncoding(String newEncoding) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.encoding, newEncoding)) {
            return;
        }
        this.checkReadOnly();
        this.checkEncoding(newEncoding);
        this.checkHeader(this.version, newEncoding, this.standalone);
        this.setEncodingImpl(newEncoding);
    }

    protected final void checkEncoding(String encoding) throws InvalidArgumentException {
        TreeUtilities.checkDocumentEncoding(encoding);
    }

    public final String getStandalone() {
        return this.standalone;
    }

    private final void setStandaloneImpl(String newStandalone) {
        String oldStandalone = this.standalone;
        this.standalone = newStandalone;
        this.firePropertyChange(PROP_STANDALONE, oldStandalone, newStandalone);
    }

    public final void setStandalone(String newStandalone) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.standalone, newStandalone)) {
            return;
        }
        this.checkReadOnly();
        this.checkStandalone(newStandalone);
        this.checkHeader(this.version, this.encoding, newStandalone);
        this.setStandaloneImpl(newStandalone);
    }

    protected final void checkStandalone(String standalone) throws InvalidArgumentException {
        TreeUtilities.checkDocumentStandalone(standalone);
    }

    public final void setHeader(String newVersion, String newEncoding, String newStandalone) throws ReadOnlyException, InvalidArgumentException {
        boolean setStandalone;
        boolean setVersion = !Util.equals(this.version, newVersion);
        boolean setEncoding = !Util.equals(this.encoding, newEncoding);
        boolean bl = setStandalone = !Util.equals(this.standalone, newStandalone);
        if (!(setVersion || setEncoding || setStandalone)) {
            return;
        }
        this.checkReadOnly();
        if (setVersion) {
            this.checkVersion(newVersion);
        }
        if (setEncoding) {
            this.checkEncoding(newEncoding);
        }
        if (setStandalone) {
            this.checkStandalone(newStandalone);
        }
        this.checkHeader(newVersion, newEncoding, newStandalone);
        if (setVersion) {
            this.setVersionImpl(newVersion);
        }
        if (setEncoding) {
            this.setEncodingImpl(newEncoding);
        }
        if (setStandalone) {
            this.setStandaloneImpl(newStandalone);
        }
    }

    protected final void checkHeader(String version, String encoding, String standalone) throws InvalidArgumentException {
        if (version == null && (encoding != null || standalone != null)) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_document_header"), new NullPointerException());
        }
    }

    public final TreeEventManager getRootEventManager() {
        return this.eventManager;
    }

    public final TreeDocumentType getDocumentType() {
        return this.documentType;
    }

    public final void setDocumentType(TreeDocumentType newDocumentType) throws ReadOnlyException, InvalidArgumentException {
        if (newDocumentType == null) {
            this.removeChild(this.documentType);
        } else if (this.documentType == null) {
            if (this.rootElement == null) {
                this.appendChild(newDocumentType);
            } else {
                this.insertChildAt(newDocumentType, 0);
            }
        } else {
            this.replaceChild(this.documentType, newDocumentType);
        }
    }

    public final TreeElement getDocumentElement() {
        return this.rootElement;
    }

    public final void setDocumentElement(TreeElement newElement) throws ReadOnlyException, InvalidArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeDocument::setDocumentElement: oldDocumentElement = " + this.rootElement);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("            ::setDocumentElement: newDocumentElement = " + newElement);
        }
        if (newElement == null) {
            this.removeChild(this.rootElement);
        } else if (this.rootElement == null) {
            this.appendChild(newElement);
        } else {
            this.replaceChild(this.rootElement, newElement);
        }
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected class ChildListContentManager
    extends AbstractTreeDocument.ChildListContentManager {
        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeDocument.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(Document.Child.class, obj);
        }

        public void objectInserted(TreeObject obj) {
            block10: {
                super.objectInserted(obj);
                try {
                    if (obj instanceof TreeDocumentType) {
                        if (TreeDocument.this.documentType != null && TreeDocument.this.documentType != obj) {
                            TreeDocument.this.removeChild(TreeDocument.this.documentType);
                        }
                        TreeDocument.this.documentType = (TreeDocumentType)obj;
                    } else if (obj instanceof TreeElement) {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("\nTreeDocument::ChildListContentManager::objectInserted: obj = " + obj);
                        }
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("            ::                       ::objectInserted: old root element = " + TreeDocument.this.rootElement);
                        }
                        if (TreeDocument.this.rootElement != null && TreeDocument.this.rootElement != obj) {
                            TreeDocument.this.removeChild(TreeDocument.this.rootElement);
                        }
                        TreeDocument.this.rootElement = (TreeElement)obj;
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("            ::                       ::objectInserted: NEW root element = " + TreeDocument.this.rootElement);
                        }
                    }
                }
                catch (Exception exc) {
                    if (!Util.THIS.isLoggable()) break block10;
                    Util.THIS.debug("TreeDocument::ChildListContentManager.objectInserted", exc);
                }
            }
        }

        public void objectRemoved(TreeObject obj) {
            super.objectRemoved(obj);
            if (TreeDocument.this.documentType == obj) {
                TreeDocument.this.documentType = null;
            } else if (TreeDocument.this.rootElement == obj) {
                TreeDocument.this.rootElement = null;
            }
        }
    }
}

