/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;

public class CompoundFinder
implements JCFinder {
    private List finders;
    private Class kitClass;
    private static JCField artificialField = new JavaCompletion.BaseField(JavaCompletion.CLASS_CLASS, "class", JavaCompletion.CLASS_TYPE, 1);

    public CompoundFinder(List finders, Class kitClass) {
        this.finders = finders;
        this.kitClass = kitClass;
        Iterator it = finders.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof JCBaseFinder)) continue;
            ((JCBaseFinder)o).setParentFinder(this);
        }
    }

    public List findClasses(JCPackage pkg, String name, boolean exactMatch) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this.finders.size(); ++i) {
            JCFinder finder = (JCFinder)this.finders.get(i);
            if (pkg == null) {
                ret.addAll(finder.findClasses(null, name, exactMatch));
                continue;
            }
            List l = finder.findPackages(pkg.getName(), true, false);
            if (l.size() != 1) continue;
            JCPackage packageFromFinder = (JCPackage)l.iterator().next();
            ret.addAll(finder.findClasses(packageFromFinder, name, exactMatch));
        }
        Collections.sort(ret, this.getNaturalSort() ? JCBaseFinder.NATURAL_MEMBER_NAME_COMPARATOR : JCBaseFinder.CLASS_NAME_COMPARATOR);
        return ret;
    }

    public List findFields(JCClass c, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        List something = null;
        for (int i = this.finders.size(); i > 0; --i) {
            List ret = ((JCFinder)this.finders.get(i - 1)).findFields(c, name, exactMatch, staticOnly, inspectOuterClasses);
            if (ret == null || ret.size() <= 0) continue;
            if (ret.size() == 1 && ret.get(0).equals(artificialField)) {
                something = ret;
                continue;
            }
            return ret;
        }
        if (something != null) {
            return something;
        }
        return new ArrayList();
    }

    public List findMethods(JCClass c, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        for (int i = this.finders.size(); i > 0; --i) {
            List ret = ((JCFinder)this.finders.get(i - 1)).findMethods(c, name, exactMatch, staticOnly, inspectOuterClasses);
            if (ret == null || ret.size() <= 0) continue;
            return ret;
        }
        return new ArrayList();
    }

    public List findPackages(String name, boolean exactMatch, boolean subPackages) {
        TreeSet ret = this.getNaturalSort() ? new TreeSet(JCBaseFinder.INSENSITIVE_CLASS_NAME_COMPARATOR) : new TreeSet();
        for (int i = 0; i < this.finders.size(); ++i) {
            ret.addAll(((JCFinder)this.finders.get(i)).findPackages(name, exactMatch, subPackages));
        }
        return new ArrayList(ret);
    }

    public JCClass getExactClass(String classFullName) {
        for (int i = this.finders.size(); i > 0; --i) {
            JCClass cls = ((JCFinder)this.finders.get(i - 1)).getExactClass(classFullName);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    public JCPackage getExactPackage(String packageName) {
        for (int i = this.finders.size(); i > 0; --i) {
            JCPackage pkg = ((JCFinder)this.finders.get(i - 1)).getExactPackage(packageName);
            if (pkg == null) continue;
            return pkg;
        }
        return null;
    }

    private boolean getNaturalSort() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
    }
}

