/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTypeSchemaWsdlParser
implements DocumentTypeParser {
    private static XPath xpath = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, String> prefixes = new HashMap<String, String>();

    @Override
    public boolean accept(String mimeType) {
        if (mimeType != null && mimeType.equalsIgnoreCase(Utilities.DocumentTypesEnum.schema.toString())) {
            return true;
        }
        return mimeType != null && mimeType.equalsIgnoreCase(Utilities.DocumentTypesEnum.wsdl.toString());
    }

    @Override
    public List<String> getAllLocationOfReferencedEntities(FileObject fob) throws Exception {
        return this.getAllLocationOfReferencedEntities(FileUtil.toFile((FileObject)fob));
    }

    private void initXpath() throws Exception {
        if (xpath == null) {
            xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this.getNamespaceContext());
            xpath.compile("//xsd:schema/xsd:import/@schemaLocation");
            xpath.compile("//xsd:schema/xsd:include/@schemaLocation");
            xpath.compile("//xsd:schema/xsd:redefine/@schemaLocation");
            xpath.compile("//wsdl:definitions/wsdl:import/@location");
            xpath.compile("/wsdl:definitions");
            xpath.compile("/xsd:schema");
        }
    }

    private NamespaceContext getNamespaceContext() {
        this.namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        this.namespaces.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.prefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        return new Utilities.HashNamespaceResolver(this.namespaces, this.prefixes);
    }

    private Node getDOMTree(File parsedFile) throws Exception {
        DocumentBuilderFactory dbfact = DocumentBuilderFactory.newInstance();
        dbfact.setNamespaceAware(true);
        FileObject parsedFileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)parsedFile));
        Document node = dbfact.newDocumentBuilder().parse(parsedFileObject.getInputStream());
        return node;
    }

    @Override
    public List<String> getAllLocationOfReferencedEntities(File parsedFile) throws Exception {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        this.initXpath();
        Node documentNode = this.getDOMTree(parsedFile);
        String locationExpression = "//xsd:schema/xsd:import/@schemaLocation";
        NodeList nodes = (NodeList)xpath.evaluate(locationExpression, documentNode, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            for (i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                result.add(node.getNodeValue());
            }
        }
        if ((nodes = (NodeList)xpath.evaluate(locationExpression = "//xsd:schema/xsd:include/@schemaLocation", documentNode, XPathConstants.NODESET)) != null && nodes.getLength() > 0) {
            for (i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i).getNodeValue());
            }
        }
        if ((nodes = (NodeList)xpath.evaluate(locationExpression = "//xsd:schema/xsd:redefine/@schemaLocation", documentNode, XPathConstants.NODESET)) != null && nodes.getLength() > 0) {
            for (i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i).getNodeValue());
            }
        }
        if ((nodes = (NodeList)xpath.evaluate(locationExpression = "//wsdl:definitions/wsdl:import/@location", documentNode, XPathConstants.NODESET)) != null && nodes.getLength() > 0) {
            for (i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i).getNodeValue());
            }
        }
        return result;
    }

    public String getFileExtensionByParsing(File parsedFile) throws Exception {
        Object result = null;
        this.initXpath();
        Node documentNode = this.getDOMTree(parsedFile);
        String locationExpression = "/xsd:schema";
        NodeList nodes = (NodeList)xpath.evaluate(locationExpression, documentNode, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            return "xsd";
        }
        locationExpression = "/wsdl:definitions";
        nodes = (NodeList)xpath.evaluate(locationExpression, documentNode, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            return "wsdl";
        }
        return "xml";
    }

    public static void main(String[] args) throws Exception {
        DocumentTypeSchemaWsdlParser dtsp = new DocumentTypeSchemaWsdlParser();
        System.out.println(dtsp.getFileExtensionByParsing(new File("D:\\temp\\xml\\maindoc\\UBL-Order-1.0.xsd")));
        System.out.println(dtsp.getFileExtensionByParsing(new File("C:\\Documents and Settings\\girix\\JavaApplication5\\src\\javaapplication5\\newuntitled.wsdl")));
        System.out.println(dtsp.getFileExtensionByParsing(new File("C:\\Documents and Settings\\girix\\Desktop\\ToDo.txt")));
    }
}

