/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsActionsProvider;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class LineBreakpointCustomizeAction
extends NodeAction {
    static LineBreakpoint getCurrentBreakpoint() {
        URL currentURL;
        String currentURLStr = EditorContextBridge.getCurrentURL();
        if (currentURLStr == null) {
            return null;
        }
        try {
            currentURL = new URL(currentURLStr);
        }
        catch (MalformedURLException muex) {
            return null;
        }
        int lineNumber = EditorContextBridge.getCurrentLineNumber();
        if (lineNumber < 0) {
            return null;
        }
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bs.length; ++i) {
            URL url;
            if (!(bs[i] instanceof LineBreakpoint)) continue;
            LineBreakpoint lb = (LineBreakpoint)bs[i];
            try {
                url = new URL(lb.getURL());
            }
            catch (MalformedURLException muex) {
                continue;
            }
            if (!currentURL.equals(url) || lineNumber != lb.getLineNumber()) continue;
            return lb;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enable(null);
    }

    protected boolean enable(Node[] activatedNodes) {
        LineBreakpoint lb = LineBreakpointCustomizeAction.getCurrentBreakpoint();
        return lb != null;
    }

    public String getName() {
        return NbBundle.getMessage((Class)LineBreakpointCustomizeAction.class, (String)"CTL_customize");
    }

    protected void performAction(Node[] activatedNodes) {
        LineBreakpoint lb = LineBreakpointCustomizeAction.getCurrentBreakpoint();
        if (lb == null) {
            return;
        }
        BreakpointsActionsProvider.customize((Breakpoint)lb);
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

