/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class EnumConstantsFilter
extends VariablesFilterAdapter {
    public String[] getSupportedTypes() {
        return new String[0];
    }

    public String[] getSupportedAncestors() {
        return new String[]{"java.lang.Enum"};
    }

    public boolean isLeaf(TreeModel original, Variable variable) throws UnknownTypeException {
        return true;
    }

    public Object getValueAt(TableModel original, Variable variable, String columnID) throws UnknownTypeException {
        ObjectVariable ov = (ObjectVariable)variable;
        if (columnID == "LocalsValue" || columnID == "WatchValue") {
            try {
                return ov.getToStringValue();
            }
            catch (InvalidExpressionException ex) {
                return ex.getLocalizedMessage();
            }
        }
        if (columnID == "LocalsType" || columnID == "WatchType") {
            String typeName = ov.getType();
            int idx = typeName.lastIndexOf("$");
            if (idx != -1) {
                return typeName.substring(idx + 1);
            }
            idx = typeName.lastIndexOf(".");
            if (idx != -1) {
                return typeName.substring(idx + 1);
            }
        }
        return original.getValueAt((Object)variable, columnID);
    }
}

