/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.w3c.dom.Element;

final class Classpaths
implements ClassPathProvider,
AntProjectListener,
PropertyChangeListener {
    private static final ErrorManager err;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private final Map classpaths = new HashMap();
    private final Map mutablePathImpls = new HashMap();
    private final Map mutableClassPathImpl2ClassPath = new HashMap();
    private Map registeredClasspaths = null;
    private static final String[] TYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Classpaths(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        helper.addAntProjectListener((AntProjectListener)this);
        evaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ClassPath findClassPath(final FileObject file, final String type) {
        return (ClassPath)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                return Classpaths.this.findClassPathImpl(file, type);
            }
        });
    }

    private synchronized ClassPath findClassPathImpl(FileObject file, String type) {
        WeakHashMap<FileObject, ClassPath> classpathsByType = (WeakHashMap<FileObject, ClassPath>)this.classpaths.get(type);
        if (classpathsByType == null) {
            classpathsByType = new WeakHashMap<FileObject, ClassPath>();
            this.classpaths.put(type, classpathsByType);
        }
        Iterator it = classpathsByType.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FileObject root = (FileObject)entry.getKey();
            if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return (ClassPath)entry.getValue();
        }
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (java == null) {
            return null;
        }
        List compilationUnits = Util.findSubElements((Element)java);
        it = compilationUnits.iterator();
        while (it.hasNext()) {
            Element compilationUnitEl = (Element)((Object)it.next());
            if (!$assertionsDisabled && !compilationUnitEl.getLocalName().equals("compilation-unit")) {
                throw new AssertionError(compilationUnitEl);
            }
            List packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
            Iterator it2 = packageRoots.iterator();
            while (it2.hasNext()) {
                FileObject root = (FileObject)it2.next();
                if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                ClassPath cp = this.getPath(compilationUnitEl, packageRoots, type);
                it2 = packageRoots.iterator();
                while (it2.hasNext()) {
                    FileObject root2 = (FileObject)it2.next();
                    classpathsByType.put(root2, cp);
                }
                return cp;
            }
        }
        return null;
    }

    public synchronized void opened() {
        if (this.registeredClasspaths != null) {
            return;
        }
        HashMap _registeredClasspaths = new HashMap();
        for (int i = 0; i < TYPES.length; ++i) {
            String type = TYPES[i];
            _registeredClasspaths.put(type, new HashSet());
        }
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (java == null) {
            return;
        }
        List compilationUnits = Util.findSubElements((Element)java);
        Iterator it = compilationUnits.iterator();
        while (it.hasNext()) {
            Element compilationUnitEl = (Element)it.next();
            if (!$assertionsDisabled && !compilationUnitEl.getLocalName().equals("compilation-unit")) {
                throw new AssertionError(compilationUnitEl);
            }
            List packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
            for (int i = 0; i < TYPES.length; ++i) {
                FileObject root;
                String type = TYPES[i];
                WeakHashMap<FileObject, ClassPath> classpathsByType = (WeakHashMap<FileObject, ClassPath>)this.classpaths.get(type);
                if (classpathsByType == null) {
                    classpathsByType = new WeakHashMap<FileObject, ClassPath>();
                    this.classpaths.put(type, classpathsByType);
                }
                Set registeredClasspathsOfType = (Set)_registeredClasspaths.get(type);
                if (!$assertionsDisabled && registeredClasspathsOfType == null) {
                    throw new AssertionError();
                }
                ClassPath cp = null;
                Iterator it2 = packageRoots.iterator();
                while (cp == null && it2.hasNext()) {
                    root = (FileObject)it2.next();
                    cp = (ClassPath)classpathsByType.get(root);
                }
                if (cp == null) {
                    cp = this.getPath(compilationUnitEl, packageRoots, type);
                    it2 = packageRoots.iterator();
                    while (it2.hasNext()) {
                        root = (FileObject)it2.next();
                        classpathsByType.put(root, cp);
                    }
                }
                if (!$assertionsDisabled && cp == null) {
                    throw new AssertionError();
                }
                registeredClasspathsOfType.add(cp);
            }
        }
        if (err.isLoggable(1)) {
            err.log("classpaths for " + this.helper.getProjectDirectory() + ": " + this.classpaths);
        }
        this.registeredClasspaths = _registeredClasspaths;
        GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
        for (int i = 0; i < TYPES.length; ++i) {
            String type = TYPES[i];
            Set registeredClasspathsOfType = (Set)this.registeredClasspaths.get(type);
            gpr.register(type, registeredClasspathsOfType.toArray(new ClassPath[registeredClasspathsOfType.size()]));
        }
    }

    private synchronized void registerNewClasspath(String type, ClassPath cp) {
        if (this.registeredClasspaths == null) {
            return;
        }
        Set s = (Set)this.registeredClasspaths.get(type);
        s.add(cp);
        GlobalPathRegistry.getDefault().register(type, new ClassPath[]{cp});
    }

    public synchronized void closed() {
        if (this.registeredClasspaths == null) {
            return;
        }
        GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
        for (int i = 0; i < TYPES.length; ++i) {
            String type = TYPES[i];
            Set registeredClasspathsOfType = (Set)this.registeredClasspaths.get(type);
            gpr.unregister(type, registeredClasspathsOfType.toArray(new ClassPath[registeredClasspathsOfType.size()]));
        }
        this.registeredClasspaths = null;
    }

    static List findPackageRootNames(Element compilationUnitEl) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = Util.findSubElements((Element)compilationUnitEl).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!e.getLocalName().equals("package-root")) continue;
            String location = Util.findText((Element)e);
            names.add(location);
        }
        return names;
    }

    static Map findPackageRootsByName(AntProjectHelper helper, PropertyEvaluator evaluator, List packageRootNames) {
        LinkedHashMap<String, FileObject> roots = new LinkedHashMap<String, FileObject>();
        Iterator it = packageRootNames.iterator();
        while (it.hasNext()) {
            File locationFile;
            FileObject locationFileObject;
            String location = (String)it.next();
            String locationEval = evaluator.evaluate(location);
            if (locationEval == null || (locationFileObject = FileUtil.toFileObject((File)(locationFile = helper.resolveFile(locationEval)))) == null) continue;
            if (FileUtil.isArchiveFile((FileObject)locationFileObject)) {
                locationFileObject = FileUtil.getArchiveRoot((FileObject)locationFileObject);
            }
            roots.put(location, locationFileObject);
        }
        return roots;
    }

    private static List findPackageRoots(AntProjectHelper helper, PropertyEvaluator evaluator, List packageRootNames) {
        return new ArrayList(Classpaths.findPackageRootsByName(helper, evaluator, packageRootNames).values());
    }

    public static List findPackageRoots(AntProjectHelper helper, PropertyEvaluator evaluator, Element compilationUnitEl) {
        return Classpaths.findPackageRoots(helper, evaluator, Classpaths.findPackageRootNames(compilationUnitEl));
    }

    private ClassPath getPath(Element compilationUnitEl, List packageRoots, String type) {
        if (type.equals("classpath/source") || type.equals("classpath/compile") || type.equals("classpath/execute") || type.equals("classpath/boot")) {
            ClassPath cp;
            MutableClassPathImplementation impl;
            List packageRootNames = Classpaths.findPackageRootNames(compilationUnitEl);
            HashMap<List, MutableClassPathImplementation> mutablePathImplsByType = (HashMap<List, MutableClassPathImplementation>)this.mutablePathImpls.get(type);
            if (mutablePathImplsByType == null) {
                mutablePathImplsByType = new HashMap<List, MutableClassPathImplementation>();
                this.mutablePathImpls.put(type, mutablePathImplsByType);
            }
            if ((impl = (MutableClassPathImplementation)mutablePathImplsByType.get(packageRootNames)) == null) {
                impl = new MutableClassPathImplementation(packageRootNames, type, compilationUnitEl);
                mutablePathImplsByType.put(packageRootNames, impl);
            }
            if ((cp = (ClassPath)this.mutableClassPathImpl2ClassPath.get(impl)) == null) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)impl);
                this.mutableClassPathImpl2ClassPath.put(impl, cp);
                this.registerNewClasspath(type, cp);
            }
            return cp;
        }
        return null;
    }

    private List createSourcePath(List packageRootNames) {
        ArrayList<URL> roots = new ArrayList<URL>(packageRootNames.size());
        Iterator it = packageRootNames.iterator();
        while (it.hasNext()) {
            String location = (String)it.next();
            String locationEval = this.evaluator.evaluate(location);
            if (locationEval == null) continue;
            roots.add(this.createClasspathEntry(locationEval));
        }
        return roots;
    }

    private List createCompileClasspath(Element compilationUnitEl) {
        Iterator it = Util.findSubElements((Element)compilationUnitEl).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!e.getLocalName().equals("classpath") || !e.getAttribute("mode").equals("compile")) continue;
            return this.createClasspath(e);
        }
        return Collections.EMPTY_LIST;
    }

    private List createClasspath(Element classpathEl) {
        String cpEval;
        String cp = Util.findText((Element)classpathEl);
        if (cp == null) {
            cp = "";
        }
        if ((cpEval = this.evaluator.evaluate(cp)) == null) {
            return null;
        }
        String[] path = PropertyUtils.tokenizePath((String)cpEval);
        URL[] pathURL = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            pathURL[i] = this.createClasspathEntry(path[i]);
        }
        return Arrays.asList(pathURL);
    }

    private URL createClasspathEntry(String text) {
        URL entry;
        File entryFile = this.helper.resolveFile(text);
        try {
            entry = entryFile.toURI().toURL();
        }
        catch (MalformedURLException x) {
            throw new AssertionError((Object)x);
        }
        if (FileUtil.isArchiveFile((URL)entry)) {
            return FileUtil.getArchiveRoot((URL)entry);
        }
        String entryS = entry.toExternalForm();
        if (!entryS.endsWith("/")) {
            try {
                return new URL(entryS + '/');
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
        }
        return entry;
    }

    private List createExecuteClasspath(List packageRoots, Element compilationUnitEl) {
        Iterator it = Util.findSubElements((Element)compilationUnitEl).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!e.getLocalName().equals("classpath") || !e.getAttribute("mode").equals("execute")) continue;
            return this.createClasspath(e);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(this.createCompileClasspath(compilationUnitEl));
        boolean foundBuiltTos = false;
        Iterator builtTos = Util.findSubElements((Element)compilationUnitEl).iterator();
        while (builtTos.hasNext()) {
            Element builtTo = (Element)builtTos.next();
            if (!builtTo.getLocalName().equals("built-to")) continue;
            foundBuiltTos = true;
            String rawtext = Util.findText((Element)builtTo);
            if (!$assertionsDisabled && rawtext == null) {
                throw new AssertionError((Object)"Must have nonempty text inside <built-to>");
            }
            String text = this.evaluator.evaluate(rawtext);
            if (text == null) continue;
            urls.add(this.createClasspathEntry(text));
        }
        if (!foundBuiltTos) {
            urls.addAll(this.createSourcePath(packageRoots));
        }
        return urls;
    }

    private List createBootClasspath(Element compilationUnitEl) {
        Iterator it = Util.findSubElements((Element)compilationUnitEl).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!e.getLocalName().equals("classpath") || !e.getAttribute("mode").equals("boot")) continue;
            return this.createClasspath(e);
        }
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform platform = jpm.getDefaultPlatform();
        it = Util.findSubElements((Element)compilationUnitEl).iterator();
        block1: while (it.hasNext()) {
            int i;
            Element e = (Element)it.next();
            if (!e.getLocalName().equals("source-level")) continue;
            String level = Util.findText((Element)e);
            Specification spec = new Specification("j2se", new SpecificationVersion(level));
            JavaPlatform[] matchingPlatforms = jpm.getPlatforms(null, spec);
            if (matchingPlatforms.length <= 0) break;
            platform = matchingPlatforms[0];
            for (i = 0; i < matchingPlatforms.length; ++i) {
                if (matchingPlatforms[i].getJavadocFolders().isEmpty()) continue;
                platform = matchingPlatforms[i];
                break;
            }
            for (i = 0; i < matchingPlatforms.length; ++i) {
                if (matchingPlatforms[i].getSourceFolders().getRoots().length <= 0) continue;
                platform = matchingPlatforms[i];
                break block1;
            }
        }
        if (platform != null) {
            List entries = platform.getBootstrapLibraries().entries();
            ArrayList<URL> urls = new ArrayList<URL>(entries.size());
            Iterator it2 = entries.iterator();
            while (it2.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it2.next();
                urls.add(entry.getURL());
            }
            return urls;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"JavaPlatformManager has no default platform");
        }
        return Collections.EMPTY_LIST;
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.pathsChanged();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.pathsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pathsChanged() {
        Classpaths classpaths = this;
        synchronized (classpaths) {
            this.classpaths.clear();
        }
        Iterator it1 = this.mutablePathImpls.values().iterator();
        while (it1.hasNext()) {
            Map m = (Map)it1.next();
            Iterator it2 = m.values().iterator();
            while (it2.hasNext()) {
                MutableClassPathImplementation impl = (MutableClassPathImplementation)it2.next();
                impl.change();
            }
        }
    }

    static {
        $assertionsDisabled = !Classpaths.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance(Classpaths.class.getName());
        TYPES = new String[]{"classpath/source", "classpath/boot", "classpath/execute", "classpath/compile"};
    }

    private final class MutableClassPathImplementation
    implements ClassPathImplementation {
        private final List packageRootNames;
        private final String type;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private List roots;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MutableClassPathImplementation(List packageRootNames, String type, Element initialCompilationUnit) {
            this.packageRootNames = packageRootNames;
            this.type = type;
            this.initRoots(initialCompilationUnit);
        }

        private Element findCompilationUnit() {
            Element java = Classpaths.this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
            if (java == null) {
                return null;
            }
            List compilationUnits = Util.findSubElements((Element)java);
            Iterator it = compilationUnits.iterator();
            while (it.hasNext()) {
                Element compilationUnitEl = (Element)it.next();
                if (!$assertionsDisabled && !compilationUnitEl.getLocalName().equals("compilation-unit")) {
                    throw new AssertionError(compilationUnitEl);
                }
                if (!((Object)this.packageRootNames).equals(Classpaths.findPackageRootNames(compilationUnitEl))) continue;
                return compilationUnitEl;
            }
            return null;
        }

        private void initRoots(Element compilationUnitEl) {
            if (compilationUnitEl == null) {
                this.roots = Collections.EMPTY_LIST;
                return;
            }
            if (this.type.equals("classpath/source")) {
                this.roots = Classpaths.this.createSourcePath(this.packageRootNames);
            } else if (this.type.equals("classpath/compile")) {
                this.roots = Classpaths.this.createCompileClasspath(compilationUnitEl);
            } else if (this.type.equals("classpath/execute")) {
                this.roots = Classpaths.this.createExecuteClasspath(this.packageRootNames, compilationUnitEl);
            } else {
                if (!$assertionsDisabled && !this.type.equals("classpath/boot")) {
                    throw new AssertionError((Object)this.type);
                }
                this.roots = Classpaths.this.createBootClasspath(compilationUnitEl);
            }
            if (!$assertionsDisabled && this.roots == null) {
                throw new AssertionError();
            }
        }

        public List getResources() {
            ArrayList<PathResourceImplementation> impls = new ArrayList<PathResourceImplementation>(this.roots.size());
            Iterator it = this.roots.iterator();
            while (it.hasNext()) {
                URL root = (URL)it.next();
                if (!$assertionsDisabled && !root.toExternalForm().endsWith("/")) {
                    throw new AssertionError((Object)("Had bogus roots " + this.roots + " for type " + this.type + " in " + Classpaths.this.helper.getProjectDirectory()));
                }
                impls.add(ClassPathSupport.createResource((URL)root));
            }
            return impls;
        }

        public void change() {
            List oldRoots = this.roots;
            this.initRoots(this.findCompilationUnit());
            if (err.isLoggable(1)) {
                err.log("MutableClassPathImplementation.change: packageRootNames=" + this.packageRootNames + " type=" + this.type + " oldRoots=" + oldRoots + " roots=" + this.roots);
            }
            if (!((Object)this.roots).equals(oldRoots)) {
                this.pcs.firePropertyChange("resources", null, null);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$freeform$Classpaths == null ? (class$org$netbeans$modules$java$freeform$Classpaths = Classpaths.class$("org.netbeans.modules.java.freeform.Classpaths")) : class$org$netbeans$modules$java$freeform$Classpaths).desiredAssertionStatus();
        }
    }
}

