/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMPFieldsNode;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.MethodChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class EntityChildren
extends Children.Keys
implements PropertyChangeListener {
    private static final String REMOTE_KEY = "remote";
    private static final String LOCAL_KEY = "local";
    private static final String CMP_FIELDS = "fields";
    private final Entity model;
    private final ClassPath srcPath;
    private final EntityMethodController controller;
    private final EjbJar jar;
    private final FileObject ddFile;

    public EntityChildren(Entity model, ClassPath srcPath, EjbJar jar, FileObject ddFile) {
        this.srcPath = srcPath;
        this.model = model;
        this.jar = jar;
        this.ddFile = ddFile;
        this.controller = new EntityMethodController(model, srcPath, jar);
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.srcPath.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArrayList<String> keys = new ArrayList<String>();
                if (EntityChildren.this.model.getRemote() != null) {
                    keys.add(EntityChildren.REMOTE_KEY);
                }
                if (EntityChildren.this.model.getLocal() != null) {
                    keys.add(EntityChildren.LOCAL_KEY);
                }
                if ("Container".equals(EntityChildren.this.model.getPersistenceType())) {
                    keys.add(EntityChildren.CMP_FIELDS);
                }
                EntityChildren.this.setKeys(keys);
            }
        });
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
        this.srcPath.removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        if (LOCAL_KEY.equals(key)) {
            MethodChildren c = new MethodChildren(this.controller, this.model, this.controller.getLocalInterfaces(), true, this.ddFile);
            MethodsNode n = new MethodsNode((EntityAndSession)this.model, this.jar, this.srcPath, (Children)c, true);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/LocalMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_LocalMethods"));
            return new Node[]{n};
        }
        if (REMOTE_KEY.equals(key)) {
            MethodChildren c = new MethodChildren(this.controller, this.model, this.controller.getRemoteInterfaces(), false, this.ddFile);
            MethodsNode n = new MethodsNode((EntityAndSession)this.model, this.jar, this.srcPath, (Children)c, false);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/RemoteMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_RemoteMethods"));
            return new Node[]{n};
        }
        if (CMP_FIELDS.equals(key)) {
            CMPFieldsNode n = new CMPFieldsNode(this.controller, this.model, this.jar, this.ddFile);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/CMFieldContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EntityChildren.class, (String)"LBL_CMPFields"));
            return new Node[]{n};
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EntityChildren.this.updateKeys();
            }
        });
    }
}

