/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.NodeDisplayPanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategyPanel;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class CallEjbPanel
extends JPanel {
    public static final String IS_VALID = "CallEjbPanel_isValid";
    private Set refNameSet;
    private NodeDisplayPanel nodeDisplayPanel;
    private ServiceLocatorStrategyPanel slPanel;
    private NodeAcceptor nodeAcceptor;
    private Project project;
    private JavaClass beanClass;
    private FileObject srcFile;
    private String ejbName;
    private JCheckBox convertToRuntime;
    private JPanel displayPanel;
    private JTextField errorField;
    private ButtonGroup intefaceButtonGroup;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JRadioButton localRadioButton;
    private JTextField referenceNameTextField;
    private JRadioButton remoteRadioButton;
    private JPanel serviceLocatorPanel;

    public CallEjbPanel(Node rootNode, String lastLocator, JavaClass beanClass) {
        this.initComponents();
        this.srcFile = JavaModel.getFileObject((Resource)beanClass.getResource());
        this.project = FileOwnerQuery.getOwner((FileObject)this.srcFile);
        this.beanClass = beanClass;
        this.refNameSet = Collections.EMPTY_SET;
        this.nodeAcceptor = new NodeAcceptorImpl();
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.srcFile);
        if (ejbModule != null) {
            try {
                EjbJar ejbJar = DDProvider.getDefault().getMergedDDRoot(ejbModule.getMetadataUnit());
                EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                if (enterpriseBeans != null) {
                    Ejb[] ejbs = enterpriseBeans.getEjbs();
                    for (int i = 0; i < ejbs.length; ++i) {
                        int j;
                        if (!ejbs[i].getEjbClass().equals(beanClass.getName())) continue;
                        String displayName = ejbs[i].getDefaultDisplayName();
                        this.ejbName = displayName == null ? ejbs[i].getEjbName() : displayName;
                        EjbRef[] ejbRefs = ejbs[i].getEjbRef();
                        EjbLocalRef[] ejbLocalRefs = ejbs[i].getEjbLocalRef();
                        this.refNameSet = new HashSet(ejbRefs.length + ejbLocalRefs.length);
                        for (j = 0; j < ejbRefs.length; ++j) {
                            this.refNameSet.add(ejbRefs[j].getEjbRefName());
                        }
                        for (j = 0; j < ejbLocalRefs.length; ++j) {
                            this.refNameSet.add(ejbLocalRefs[j].getEjbRefName());
                        }
                    }
                }
            }
            catch (IOException e) {
                this.refNameSet = Collections.EMPTY_SET;
            }
        }
        this.setErrorFieldColor(true);
        this.nodeDisplayPanel = new NodeDisplayPanel(rootNode);
        this.nodeDisplayPanel.setBorder(new EtchedBorder());
        this.displayPanel.add(this.nodeDisplayPanel);
        this.nodeDisplayPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                Node[] nodes = CallEjbPanel.this.nodeDisplayPanel.getSelectedNodes();
                if (nodes.length == 0) {
                    return;
                }
                EjbReference ejbReference = (EjbReference)nodes[0].getCookie(EjbReference.class);
                if (ejbReference != null) {
                    CallEjbPanel.this.generateName(ejbReference, CallEjbPanel.this.remoteRadioButton.isSelected(), nodes[0]);
                }
                CallEjbPanel.this.validateReferences();
            }
        });
        this.referenceNameTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CallEjbPanel.this.validateReferences();
            }
        });
        this.slPanel = new ServiceLocatorStrategyPanel(lastLocator);
        this.slPanel.getUnreferencedServiceLocator().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CallEjbPanel.this.validateReferences();
            }
        });
        this.slPanel.getClassName().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CallEjbPanel.this.validateReferences();
            }

            public void removeUpdate(DocumentEvent e) {
                CallEjbPanel.this.validateReferences();
            }

            public void changedUpdate(DocumentEvent e) {
                CallEjbPanel.this.validateReferences();
            }
        });
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
        this.validateReferences();
    }

    public void disableServiceLocator() {
        this.serviceLocatorPanel.setVisible(false);
    }

    private void setErrorFieldColor(boolean error) {
        if (error) {
            Color c = UIManager.getColor("nb.errorForeground");
            this.errorField.setForeground(c == null ? new Color(89, 79, 191) : c);
        } else {
            Color c = UIManager.getColor("nb.warningForeground");
            this.errorField.setForeground(c == null ? Color.DARK_GRAY : c);
        }
    }

    private void setErrorMessage(String message) {
        this.setErrorFieldColor(true);
        this.setMessage(message);
    }

    private void setWarningMessage(String message) {
        this.setErrorFieldColor(false);
        this.setMessage(message);
    }

    private void setMessage(String message) {
        if (message == null) {
            message = " ";
        }
        this.errorField.setText(message);
        this.errorField.setToolTipText(message);
        this.errorField.setCaretPosition(0);
    }

    public void validateReferences() {
        boolean nodeAccepted = this.nodeAcceptor.acceptNodes(this.nodeDisplayPanel.getSelectedNodes());
        if (this.slPanel.getUnreferencedServiceLocator().isSelected() && this.slPanel.getClassName().getText().trim().equals("") || !nodeAccepted) {
            this.firePropertyChange(IS_VALID, true, false);
        } else {
            this.firePropertyChange(IS_VALID, false, true);
        }
    }

    private void initComponents() {
        this.intefaceButtonGroup = new ButtonGroup();
        this.serviceLocatorPanel = new JPanel();
        this.convertToRuntime = new JCheckBox();
        this.displayPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.errorField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.referenceNameTextField = new JTextField();
        this.localRadioButton = new JRadioButton();
        this.remoteRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_CallEJBPanel"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_CallEJBPanel"));
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        this.convertToRuntime.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ConvertToRuntimeMneumonic").charAt(0));
        this.convertToRuntime.setSelected(true);
        this.convertToRuntime.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ConvertToRuntime"));
        this.serviceLocatorPanel.add((Component)this.convertToRuntime, "South");
        this.convertToRuntime.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallEjbPanel.class, (String)"ACSD_ConvertToRuntime"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.serviceLocatorPanel, gridBagConstraints);
        this.displayPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.displayPanel, gridBagConstraints);
        this.displayPanel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_DisplayPanel"));
        this.displayPanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACSD_DisplayPanel"));
        jLabel1.setLabelFor(this.displayPanel);
        jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ModuleMustBeInSameApplication"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel1, gridBagConstraints);
        this.errorField.setBackground(this.getBackground());
        this.errorField.setEditable(false);
        this.errorField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.errorField, gridBagConstraints);
        this.errorField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_ErrorField"));
        this.errorField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_ErrorField"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("MN_ReferenceName").charAt(0));
        this.jLabel2.setLabelFor(this.referenceNameTextField);
        this.jLabel2.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferenceName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferencedInterface"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.referenceNameTextField, gridBagConstraints);
        this.referenceNameTextField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ReferenceName"));
        this.referenceNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ReferenceName"));
        this.intefaceButtonGroup.add(this.localRadioButton);
        this.localRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("MN_Local").charAt(0));
        this.localRadioButton.setSelected(true);
        this.localRadioButton.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_Local"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.localRadioButton, gridBagConstraints);
        this.localRadioButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Local"));
        this.localRadioButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Local"));
        this.intefaceButtonGroup.add(this.remoteRadioButton);
        this.remoteRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("MN_Remote").charAt(0));
        this.remoteRadioButton.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_Remote"));
        this.remoteRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CallEjbPanel.this.remoteRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.remoteRadioButton, gridBagConstraints);
        this.remoteRadioButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Remote"));
        this.remoteRadioButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Remote"));
    }

    private void remoteRadioButtonItemStateChanged(ItemEvent evt) {
        this.validateReferences();
    }

    public boolean convertToRuntime() {
        return this.convertToRuntime.isSelected();
    }

    public Node getEjb() {
        Node[] selectedNodes = this.nodeDisplayPanel.getSelectedNodes();
        return selectedNodes.length > 0 ? selectedNodes[0] : null;
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    public String getReferenceName() {
        return this.referenceNameTextField.getText();
    }

    public boolean isRemoteInterfaceSelected() {
        return this.remoteRadioButton.isSelected();
    }

    private void generateName(EjbReference ejbReference, boolean remote, Node selectedNode) {
        String name;
        if (ejbReference.getClientJarTarget() == null) {
            this.referenceNameTextField.setText("");
            return;
        }
        if (remote) {
            boolean targetIsJavaSE = Utils.isTargetJavaSE(this.beanClass);
            if (targetIsJavaSE && Utils.isJavaEE5orHigher(this.project)) {
                Feature ejbRefClass = (Feature)selectedNode.getLookup().lookup(Feature.class);
                name = ejbRefClass.getName();
            } else {
                name = targetIsJavaSE ? ejbReference.createRef().getHome() : ejbReference.createRef().getEjbRefName();
            }
        } else {
            name = ejbReference.createLocalRef().getEjbRefName();
        }
        int uniquifier = 1;
        String newName = name;
        while (this.refNameSet.contains(newName)) {
            newName = name + String.valueOf(uniquifier++);
        }
        this.referenceNameTextField.setText(name);
    }

    private class NodeAcceptorImpl
    implements NodeAcceptor {
        private NodeAcceptorImpl() {
        }

        public boolean acceptNodes(Node[] nodes) {
            CallEjbPanel.this.setErrorMessage(" ");
            if (nodes.length == 0) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_SelectOneEJB"));
                return false;
            }
            if (nodes.length > 1) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_MoreEJBsSelected"));
                return false;
            }
            Feature member = (Feature)nodes[0].getLookup().lookup(Feature.class);
            if (!(member instanceof JavaClass)) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NodeIsNotEJB"));
                return false;
            }
            if (((JavaClass)member).equals(CallEjbPanel.this.beanClass)) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_CannotCallItself", (Object)CallEjbPanel.this.ejbName));
                return false;
            }
            if (!this.hasJarArtifact(member)) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_EJBNotInDistributionArchive"));
                return false;
            }
            if (nodes[0].getCookie(EjbReference.class) == null) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferencesNotSupported"));
                return false;
            }
            if (!this.acceptInterfaces(nodes)) {
                return false;
            }
            if (!this.validateRefName()) {
                return false;
            }
            DataObject dataObject = (DataObject)nodes[0].getCookie(DataObject.class);
            if (dataObject == null) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NoSourcesForBean"));
                return false;
            }
            Project nodeProject = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            if (!(CallEjbPanel.this.isRemoteInterfaceSelected() || nodeProject.equals(CallEjbPanel.this.project) || Utils.areInSameJ2EEApp(CallEjbPanel.this.project, nodeProject))) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NotInSameEarOrProject"));
                return false;
            }
            if (!CallEjbPanel.this.isRemoteInterfaceSelected() && Utils.isAppClient(CallEjbPanel.this.project)) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_CannotCallLocalInAC"));
                return false;
            }
            if (!CallEjbPanel.this.isRemoteInterfaceSelected() && Utils.isTargetJavaSE(CallEjbPanel.this.beanClass)) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_CannotCallLocalInJSE"));
                return false;
            }
            if (!Utils.isJavaEE5orHigher(CallEjbPanel.this.project) && Utils.isJavaEE5orHigher(nodeProject)) {
                CallEjbPanel.this.setWarningMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_JEESpecificationLevelsDiffer"));
            }
            return true;
        }

        private boolean acceptInterfaces(Node[] nodes) {
            EjbReference ejbReference = (EjbReference)nodes[0].getCookie(EjbReference.class);
            if (ejbReference == null) {
                return false;
            }
            boolean shouldEnableLocal = ejbReference.supportsLocalInvocation();
            boolean shouldEnableRemote = ejbReference.supportsRemoteInvocation();
            CallEjbPanel.this.localRadioButton.setEnabled(shouldEnableLocal);
            CallEjbPanel.this.remoteRadioButton.setEnabled(shouldEnableRemote);
            if (!shouldEnableLocal && !shouldEnableRemote) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferencesNotSupported"));
                return false;
            }
            if (shouldEnableLocal && !shouldEnableRemote) {
                CallEjbPanel.this.localRadioButton.setSelected(true);
            } else if (!shouldEnableLocal && shouldEnableRemote) {
                CallEjbPanel.this.remoteRadioButton.setSelected(true);
            }
            CallEjbPanel.this.setErrorMessage(" ");
            return true;
        }

        private boolean hasJarArtifact(Feature feature) {
            if (feature != null) {
                Project nodeProject = FileOwnerQuery.getOwner((FileObject)CallEjbPanel.this.srcFile);
                if (nodeProject.equals(CallEjbPanel.this.project)) {
                    return true;
                }
                return AntArtifactQuery.findArtifactsByType((Project)nodeProject, (String)"jar").length > 0;
            }
            return false;
        }

        private boolean validateRefName() {
            String refName = CallEjbPanel.this.referenceNameTextField.getText();
            if (CallEjbPanel.this.refNameSet.contains(refName)) {
                CallEjbPanel.this.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"ERR_ReferenceNameExists", (Object)refName));
                return false;
            }
            return true;
        }
    }
}

