/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.io.StringReader;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.JavaParser;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.expr.SimpleNode;

public class Expression {
    public static final String LANGUAGE_JAVA_1_4 = "1.4.0";
    public static final String LANGUAGE_JAVA_1_5 = "1.5.0";
    private String strExpression;
    private String language;
    private SimpleNode root;

    public static Expression parse(String expr, String language) throws ParseException {
        StringReader reader = new StringReader(expr);
        try {
            JavaParser parser = new JavaParser(reader);
            parser.setTargetJDK(language);
            SimpleNode root = parser.Expression();
            Expression expression = new Expression(expr, language, root);
            return expression;
        }
        catch (Error e) {
            throw new ParseException(e.getMessage());
        }
        finally {
            reader.close();
        }
    }

    private Expression(String expression, String language, SimpleNode root) {
        this.strExpression = expression;
        this.language = language;
        this.root = root;
    }

    public Evaluator evaluator(EvaluationContext context) {
        return new Evaluator(this, context);
    }

    SimpleNode getRoot() {
        return this.root;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExpression() {
        return this.strExpression;
    }
}

