/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.util.Iterator;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class AccessibilityQuery {
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(AccessibilityQueryImplementation.class));

    private AccessibilityQuery() {
    }

    public static Boolean isPubliclyAccessible(FileObject pkg) {
        if (!pkg.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + pkg);
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            AccessibilityQueryImplementation aqi = (AccessibilityQueryImplementation)it.next();
            Boolean b = aqi.isPubliclyAccessible(pkg);
            if (b == null) continue;
            return b;
        }
        return null;
    }
}

