/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class SourceForBinaryQuery {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(SourceForBinaryQuery.class.getName());
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(SourceForBinaryQueryImplementation.class));
    private static final Result EMPTY_RESULT = new EmptyResult();

    private SourceForBinaryQuery() {
    }

    public static Result findSourceRoots(URL binaryRoot) {
        if (FileUtil.isArchiveFile((URL)binaryRoot)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + binaryRoot);
        }
        if (!binaryRoot.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("Folder URL must end with '/'. Was: " + binaryRoot);
        }
        boolean log = ERR.isLoggable(1);
        if (log) {
            ERR.log("SFBQ.findSourceRoots: " + binaryRoot);
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            SourceForBinaryQueryImplementation impl = (SourceForBinaryQueryImplementation)it.next();
            Result result = impl.findSourceRoots(binaryRoot);
            if (result == null) continue;
            if (log) {
                ERR.log("  got result " + Arrays.asList(result.getRoots()) + " from " + impl);
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    private static final class EmptyResult
    implements Result {
        private static final FileObject[] NO_ROOTS = new FileObject[0];

        EmptyResult() {
        }

        public FileObject[] getRoots() {
            return NO_ROOTS;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    public static interface Result {
        public FileObject[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

