/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.faces;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.shale.remoting.faces.BasicResponseWriter;

public class ResponseFactory {
    public ResponseStream getResponseStream(FacesContext context, String contentType) {
        ResponseStream stream = context.getResponseStream();
        if (stream == null) {
            stream = this.createResponseStream(context, contentType);
            context.setResponseStream(stream);
        }
        return stream;
    }

    public ResponseWriter getResponseWriter(FacesContext context, String contentType) {
        ResponseWriter writer = context.getResponseWriter();
        if (writer == null) {
            writer = this.createResponseWriter(context, contentType);
            context.setResponseWriter(writer);
        }
        return writer;
    }

    protected ResponseStream createResponseStream(FacesContext context, String contentType) {
        OutputStream stream;
        Object response = context.getExternalContext().getResponse();
        if (contentType != null) {
            try {
                Method method = response.getClass().getMethod("setContentType", String.class);
                method.invoke(response, contentType);
            }
            catch (IllegalAccessException e) {
                throw new FacesException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FacesException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new FacesException((Throwable)e);
            }
        }
        try {
            String methodName = response instanceof HttpServletResponse ? "getOutputStream" : "getPortletOutputStream";
            Method method = response.getClass().getMethod(methodName, new Class[0]);
            stream = (OutputStream)method.invoke(response, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FacesException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new FacesException((Throwable)e);
        }
        return this.renderKit(context).createResponseStream(stream);
    }

    protected ResponseWriter createResponseWriter(FacesContext context, String contentType) {
        Writer writer;
        Object response = context.getExternalContext().getResponse();
        if (contentType != null) {
            try {
                Method method = response.getClass().getMethod("setContentType", String.class);
                method.invoke(response, contentType);
            }
            catch (IllegalAccessException e) {
                throw new FacesException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FacesException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new FacesException((Throwable)e);
            }
        }
        try {
            String methodName = "getWriter";
            Method method = response.getClass().getMethod(methodName, new Class[0]);
            writer = (Writer)method.invoke(response, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FacesException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new FacesException((Throwable)e);
        }
        if ("text/html".equals(contentType)) {
            return this.renderKit(context).createResponseWriter(writer, contentType, null);
        }
        return new BasicResponseWriter(writer, contentType, null);
    }

    protected RenderKit renderKit(FacesContext context) {
        String renderKitId = null;
        UIViewRoot root = context.getViewRoot();
        if (root != null) {
            renderKitId = root.getRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return factory.getRenderKit(context, renderKitId);
    }
}

