/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.config.model.NavigationCase;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;

public class JSFEditorUtilities {
    protected static final int XML_ELEMENT = 4;
    protected static final int XML_TEXT = 1;
    public static final String END_LINE = System.getProperty("line.separator");

    public static String getNavigationRule(BaseDocument doc, int offset) {
        try {
            TokenItem token;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            for (token = sup.getTokenChain(offset, offset + 1); token != null && (token.getTokenID().getNumericID() != 4 || !token.getImage().equals("<navigation-rule") && !token.getImage().equals("<managed-bean")); token = token.getPrevious()) {
            }
            if (token != null && token.getImage().equals("<navigation-rule")) {
                while (token != null && (token.getTokenID().getNumericID() != 4 || !token.getImage().equals("</navigation-rule") && !token.getImage().equals("<from-view-id"))) {
                    token = token.getNext();
                }
                if (token != null && token.getImage().equals("<from-view-id")) {
                    for (token = token.getNext(); !(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">")); token = token.getNext()) {
                    }
                    while (token != null && token.getTokenID().getNumericID() != 1 && token.getTokenID().getNumericID() == 4) {
                        token = token.getNext();
                    }
                    if (token != null && token.getTokenID().getNumericID() == 1) {
                        return token.getImage().trim();
                    }
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    public static int[] getNavigationRuleDefinition(BaseDocument doc, String ruleName) {
        try {
            String text = doc.getText(0, doc.getLength());
            int offset = text.indexOf(ruleName);
            int start = 0;
            int end = 0;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            while (offset != -1) {
                TokenItem token = sup.getTokenChain(offset, offset + 1);
                if (token != null && token.getTokenID().getNumericID() == 1) {
                    while (token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().equals(">"))) {
                        token = token.getPrevious();
                    }
                    if (token != null && token.getImage().equals("<from-view-id")) {
                        while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals("<navigation-rule"))) {
                            token = token.getPrevious();
                        }
                        if (token != null && token.getImage().equals("<navigation-rule")) {
                            start = token.getOffset();
                            for (token = sup.getTokenChain(offset, offset + 1); !(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals("</navigation-rule")); token = token.getNext()) {
                            }
                            if (token != null && token.getImage().equals("</navigation-rule")) {
                                while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">"))) {
                                    token = token.getNext();
                                }
                                if (token != null && token.getImage().equals(">")) {
                                    end = token.getOffset() + 1;
                                    return new int[]{start, end};
                                }
                            }
                            return new int[]{start, text.length()};
                        }
                    }
                }
                offset = text.indexOf(ruleName, offset + ruleName.length());
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return new int[]{-1, -1};
    }

    public static int[] getConverterDefinition(BaseDocument doc, String converterForClass) {
        try {
            String text = doc.getText(0, doc.getLength());
            int offset = text.indexOf(converterForClass);
            int start = 0;
            int end = 0;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            while (offset != -1) {
                TokenItem token = sup.getTokenChain(offset, offset + 1);
                if (token != null && token.getTokenID().getNumericID() == 1) {
                    while (token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().equals(">"))) {
                        token = token.getPrevious();
                    }
                    if (token != null && token.getImage().equals("<converter-for-class")) {
                        while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals("<converter"))) {
                            token = token.getPrevious();
                        }
                        if (token != null && token.getImage().equals("<converter")) {
                            start = token.getOffset();
                            for (token = sup.getTokenChain(offset, offset + 1); !(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals("</converter")); token = token.getNext()) {
                            }
                            if (token != null && token.getImage().equals("</converter")) {
                                while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">"))) {
                                    token = token.getNext();
                                }
                                if (token != null && token.getImage().equals(">")) {
                                    end = token.getOffset() + 1;
                                    return new int[]{start, end};
                                }
                            }
                            return new int[]{start, text.length()};
                        }
                    }
                }
                offset = text.indexOf(converterForClass, offset + converterForClass.length());
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return new int[]{-1, -1};
    }

    public static int writeCaseIntoRule(BaseDocument doc, String fromViewID, NavigationCase navigationCase) throws IOException {
        int possition = -1;
        int[] definition = JSFEditorUtilities.getNavigationRuleDefinition(doc, fromViewID);
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        String sBean = JSFEditorUtilities.addNewLines((BaseBean)navigationCase);
        try {
            if (definition[0] > -1 && definition[1] < doc.getLength()) {
                TokenItem token;
                for (token = sup.getTokenChain(definition[1] - 2, definition[1] - 1); !(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">")); token = token.getPrevious()) {
                }
                if (token != null) {
                    possition = JSFEditorUtilities.writeString(doc, sBean, token.getOffset());
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return possition;
    }

    public static int writeBean(BaseDocument doc, BaseBean bean, String element) throws IOException {
        String sBean = JSFEditorUtilities.addNewLines(bean);
        int possition = -1;
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        try {
            TokenItem token;
            String findString;
            int offset;
            String docText = doc.getText(0, doc.getLength());
            if (docText.indexOf("<faces-config") == -1) {
                doc.insertString(doc.getLength(), "<faces-config>" + END_LINE + "</faces-config>", null);
                docText = doc.getText(0, doc.getLength());
            }
            if ((offset = docText.lastIndexOf(findString = "</" + element)) == -1) {
                offset = docText.length() - 2;
            }
            if (offset < docText.length() - 2 && token != null && token.getTokenID().getNumericID() == 4) {
                for (token = sup.getTokenChain(offset, offset + 1); !(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">")); token = token.getNext()) {
                }
                if (token != null) {
                    possition = JSFEditorUtilities.writeString(doc, sBean, token.getOffset());
                }
            } else {
                if (token != null && token.getImage().equals(">")) {
                    token = token.getPrevious();
                }
                while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">"))) {
                    token = token.getPrevious();
                }
                if (token != null) {
                    possition = JSFEditorUtilities.writeString(doc, sBean, token.getOffset());
                }
            }
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return possition;
    }

    private static String addNewLines(BaseBean bean) throws IOException {
        StringWriter sWriter = new StringWriter();
        bean.writeNode((Writer)sWriter);
        String sBean = sWriter.toString();
        sBean = sBean.replaceAll("><", ">" + END_LINE + "<");
        return sBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeString(BaseDocument doc, String text, int offset) {
        int formatLength = 0;
        try {
            doc.atomicLock();
            offset = doc.getFormatter().indentNewLine((Document)doc, offset + 1);
            doc.insertString(offset, text, null);
            formatLength = doc.getFormatter().reformat(doc, offset, offset + text.length() - 1);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        finally {
            doc.atomicUnlock();
        }
        return offset + formatLength + 1;
    }

    public static int[] getManagedBeanDefinition(BaseDocument doc, String beanName) {
        try {
            String text = doc.getText(0, doc.getLength());
            int offset = text.indexOf(beanName);
            int start = 0;
            int end = 0;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            while (offset != -1) {
                TokenItem token = sup.getTokenChain(offset, offset + 1);
                if (token != null && token.getTokenID().getNumericID() == 1) {
                    while (token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().equals(">"))) {
                        token = token.getPrevious();
                    }
                    if (token != null && token.getImage().equals("<managed-bean-name")) {
                        while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals("<managed-bean"))) {
                            token = token.getPrevious();
                        }
                        if (token != null && token.getImage().equals("<managed-bean")) {
                            start = token.getOffset();
                            for (token = sup.getTokenChain(offset, offset + 1); !(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals("</managed-bean")); token = token.getNext()) {
                            }
                            if (token != null && token.getImage().equals("</managed-bean")) {
                                while (!(token == null || token.getTokenID().getNumericID() == 4 && token.getImage().equals(">"))) {
                                    token = token.getNext();
                                }
                                if (token != null && token.getImage().equals(">")) {
                                    end = token.getOffset() + 1;
                                    return new int[]{start, end};
                                }
                            }
                            return new int[]{start, text.length()};
                        }
                    }
                }
                offset = text.indexOf(beanName, offset + beanName.length());
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return new int[]{-1, -1};
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(CloneableEditorSupport.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static BaseDocument getBaseDocument(JSFConfigDataObject config) {
        BaseDocument document = null;
        CloneableEditorSupport editor = JSFEditorUtilities.findCloneableEditorSupport((DataObject)config);
        if (editor != null && (document = (BaseDocument)editor.getDocument()) == null) {
            Object ep = null;
            CreateXMLPane run = new CreateXMLPane();
            try {
                SwingUtilities.invokeAndWait(run);
                document = new BaseDocument(run.getPane().getEditorKit().getClass(), false);
                String text = "";
                text = JSFFrameworkProvider.readResource(config.getPrimaryFile().getInputStream(), "UTF-8");
                document.remove(0, document.getLength());
                document.insertString(0, text, null);
            }
            catch (InterruptedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (FileNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return document;
    }

    private static class CreateXMLPane
    implements Runnable {
        JEditorPane ep;

        private CreateXMLPane() {
        }

        public void run() {
            this.ep = new JEditorPane("text/xml", "");
        }

        public JEditorPane getPane() {
            return this.ep;
        }
    }
}

