/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.options.indentation.IndentationModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class IndentationPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private JCheckBox cbExpandTabs = new JCheckBox();
    private JCheckBox cbAddStar = new JCheckBox();
    private JCheckBox cbNewLine = new JCheckBox();
    private JCheckBox cbSpace = new JCheckBox();
    private JSpinner tfStatementIndent = new JSpinner();
    private JSpinner tfIndent = new JSpinner();
    private JEditorPane epPreview = new JEditorPane();
    private IndentationModel model;
    private String originalText;
    private boolean listen = false;
    private boolean changed = false;

    public IndentationPanel() {
        IndentationPanel.loc(this.cbExpandTabs, "Expand_Tabs");
        IndentationPanel.loc(this.cbAddStar, "Add_Leading_Star");
        IndentationPanel.loc(this.cbNewLine, "Add_New_Line");
        IndentationPanel.loc(this.cbSpace, "Add_Space");
        this.epPreview.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Preview"));
        this.epPreview.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Preview"));
        this.epPreview.setBorder(new EtchedBorder());
        this.cbNewLine.addActionListener(this);
        this.cbAddStar.addActionListener(this);
        this.cbExpandTabs.addActionListener(this);
        this.cbSpace.addActionListener(this);
        this.tfStatementIndent.setModel(new SpinnerNumberModel(8, 1, 50, 1));
        this.tfStatementIndent.addChangeListener(this);
        this.tfIndent.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.tfIndent.addChangeListener(this);
        this.epPreview.setEnabled(false);
        FormLayout layout = new FormLayout("p, 5dlu, 30dlu, 10dlu, p:g", "p, 5dlu, p, 5dlu, p, 5dlu, p, 10dlu, p, 3dlu, f:p:g");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints lc = new CellConstraints();
        CellConstraints cc = new CellConstraints();
        builder.addLabel(IndentationPanel.loc("Statement_Indent"), lc.xy(1, 1), (Component)this.tfStatementIndent, cc.xy(3, 1));
        builder.addLabel(IndentationPanel.loc("Indent"), lc.xy(1, 3), (Component)this.tfIndent, cc.xy(3, 3));
        builder.add((Component)this.cbExpandTabs, cc.xy(5, 1));
        builder.add((Component)this.cbAddStar, cc.xy(5, 3));
        builder.add((Component)this.cbNewLine, cc.xy(5, 5));
        builder.add((Component)this.cbSpace, cc.xy(5, 7));
        builder.addLabel(IndentationPanel.loc("Preview"), lc.xyw(1, 9, 5), (Component)this.epPreview, cc.xyw(1, 11, 5, "f, f"));
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)IndentationPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)IndentationPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)IndentationPanel.loc("CTL_" + key));
        }
    }

    private void updatePreview() {
        this.model.setJavaFormatLeadingStarInComment(this.cbAddStar.isSelected());
        this.model.setJavaFormatNewlineBeforeBrace(this.cbNewLine.isSelected());
        this.model.setJavaFormatSpaceBeforeParenthesis(this.cbSpace.isSelected());
        this.model.setExpandTabs(this.cbExpandTabs.isSelected());
        this.model.setJavaFormatStatementContinuationIndent((Integer)this.tfStatementIndent.getValue());
        this.model.setSpacesPerTab((Integer)this.tfIndent.getValue());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndentationPanel.this.epPreview.setText(IndentationPanel.this.originalText);
                Document doc = IndentationPanel.this.epPreview.getDocument();
                if (doc instanceof BaseDocument) {
                    try {
                        ((BaseDocument)doc).getFormatter().reformat((BaseDocument)doc, 0, ((BaseDocument)doc).getEndPosition().getOffset() - 1);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.listen) {
            return;
        }
        this.updatePreview();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        this.updatePreview();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void update() {
        this.model = new IndentationModel();
        if (this.originalText == null) {
            InputStream is = this.getClass().getResourceAsStream("/org/netbeans/modules/options/indentation/indentationExample");
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer();
            try {
                String line = r.readLine();
                while (line != null) {
                    sb.append(line).append('\n');
                    line = r.readLine();
                }
                this.originalText = new String(sb);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.listen = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndentationPanel.this.epPreview.setContentType("text/x-java");
                IndentationPanel.this.cbExpandTabs.setSelected(IndentationPanel.this.model.isExpandTabs());
                IndentationPanel.this.cbAddStar.setSelected(IndentationPanel.this.model.getJavaFormatLeadingStarInComment());
                IndentationPanel.this.cbNewLine.setSelected(IndentationPanel.this.model.getJavaFormatNewlineBeforeBrace());
                IndentationPanel.this.cbSpace.setSelected(IndentationPanel.this.model.getJavaFormatSpaceBeforeParenthesis());
                IndentationPanel.this.tfIndent.setValue(IndentationPanel.this.model.getSpacesPerTab());
                IndentationPanel.this.tfStatementIndent.setValue(IndentationPanel.this.model.getJavaFormatStatementContinuationIndent());
                IndentationPanel.this.listen = true;
                IndentationPanel.this.updatePreview();
            }
        });
    }

    public void applyChanges() {
    }

    public void cancel() {
        if (this.model != null) {
            this.model.revertChanges();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }
}

