/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.netbeans.modules.options.keymap.EditorBridge;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.openide.ErrorManager;

public class KeymapModel {
    private LayersBridge layersBridge = new LayersBridge();
    private EditorBridge editorBridge = new EditorBridge();
    private ErrorManager log = ErrorManager.getDefault().getInstance(KeymapModel.class.getName());
    private Map categoryToActions = new HashMap();
    private Map keyMaps = new HashMap();
    private Map keyMapDefaults = new HashMap();
    private Map sharedActions = new HashMap();

    public KeymapModel() {
        Iterator it = this.getActionCategories().iterator();
        while (it.hasNext()) {
            this.getActions((String)it.next());
        }
    }

    public Set getActionCategories() {
        HashSet result = new HashSet();
        result.addAll(this.layersBridge.getActions().keySet());
        result.addAll(this.editorBridge.getActions().keySet());
        return Collections.unmodifiableSet(result);
    }

    public Set getActions(String category) {
        if (!this.categoryToActions.containsKey(category)) {
            Set actions = new HashSet();
            Set s = (Set)this.layersBridge.getActions().get(category);
            if (s != null) {
                actions.addAll(s);
            }
            if ((s = (Set)this.editorBridge.getActions().get(category)) != null) {
                actions = this.mergeActions(s, actions);
            }
            this.categoryToActions.put(category, actions);
        }
        return (Set)this.categoryToActions.get(category);
    }

    public void refreshActions() {
        this.categoryToActions = new HashMap();
        this.editorBridge.refreshActions();
    }

    public String getCurrentProfile() {
        return this.editorBridge.getCurrentProfile();
    }

    public void setCurrentProfile(String profile) {
        this.editorBridge.setCurrentProfile(profile);
    }

    public List getProfiles() {
        return this.layersBridge.getProfiles();
    }

    public boolean isCustomProfile(String profile) {
        return this.editorBridge.isCustomProfile(profile);
    }

    public Map getKeymap(String profile) {
        if (!this.keyMaps.containsKey(profile)) {
            this.keyMaps.put(profile, this.mergeShortcuts(this.editorBridge.readKeymap(profile), this.layersBridge.getKeymap(profile)));
        }
        return (Map)this.keyMaps.get(profile);
    }

    public Map getKeymapDefaults(String profile) {
        if (!this.keyMapDefaults.containsKey(profile)) {
            this.keyMapDefaults.put(profile, this.mergeShortcuts(this.editorBridge.readKeymap(profile), this.layersBridge.getKeymap(profile)));
        }
        return (Map)this.keyMapDefaults.get(profile);
    }

    public void deleteProfile(String profile) {
        this.layersBridge.deleteProfile(profile);
        this.editorBridge.deleteProfile(profile);
    }

    public void changeKeymap(String profile, Map actionToShortcuts) {
        this.log("changeKeymap.actionToShortcuts", actionToShortcuts.entrySet());
        HashMap m = new HashMap(this.getKeymap(profile));
        m.putAll(actionToShortcuts);
        this.keyMaps.put(profile, m);
        this.log("changeKeymap.m", m.entrySet());
        this.layersBridge.saveKeymap(profile, m);
        this.editorBridge.saveKeymap(profile, m);
    }

    private void log(String name, Collection items) {
        if (!this.log.isLoggable(1)) {
            return;
        }
        this.log.log(1, name);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            this.log.log(1, "  " + item);
        }
    }

    private Set mergeActions(Collection editorActions, Collection layersActions) {
        String id;
        Iterator it;
        HashSet<ActionImpl> result = new HashSet<ActionImpl>();
        HashMap<String, ActionImpl> idToAction = new HashMap<String, ActionImpl>();
        if (editorActions != null) {
            it = editorActions.iterator();
            while (it.hasNext()) {
                ActionImpl action = (ActionImpl)it.next();
                id = action.getDelegatingActionId();
                if (id != null) {
                    idToAction.put(id, action);
                    continue;
                }
                result.add(action);
            }
        }
        if (layersActions != null) {
            it = layersActions.iterator();
            while (it.hasNext()) {
                ActionImpl layersAction = (ActionImpl)it.next();
                id = layersAction.getId();
                if (!idToAction.containsKey(id)) {
                    result.add(layersAction);
                    continue;
                }
                ActionImpl editorAction = (ActionImpl)idToAction.remove(id);
                CompoundAction compoundAction = new CompoundAction(editorAction, layersAction);
                result.add(compoundAction);
                this.sharedActions.put(editorAction, compoundAction);
                this.sharedActions.put(layersAction, compoundAction);
            }
        }
        result.addAll(idToAction.values());
        return result;
    }

    private Map mergeShortcuts(Map editorActions, Map layersActions) {
        Set shortcuts;
        ActionImpl action;
        HashMap<ActionImpl, Set> result = new HashMap<ActionImpl, Set>();
        Iterator it = editorActions.keySet().iterator();
        while (it.hasNext()) {
            action = (ActionImpl)it.next();
            shortcuts = (Set)editorActions.get(action);
            if (this.sharedActions.containsKey(action)) {
                action = (CompoundAction)this.sharedActions.get(action);
            }
            result.put(action, shortcuts);
        }
        it = layersActions.keySet().iterator();
        while (it.hasNext()) {
            action = (ActionImpl)it.next();
            shortcuts = (Set)layersActions.get(action);
            if (this.sharedActions.containsKey(action)) {
                action = (CompoundAction)this.sharedActions.get(action);
            }
            result.put(action, shortcuts);
        }
        return result;
    }
}

