/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Util {
    public static final ErrorManager err;
    private static final Pattern VALIDATION;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    public static String getAntScriptName(FileObject fo) {
        AntProjectCookie apc = Util.getAntProjectCookie(fo);
        if (apc == null) {
            return null;
        }
        Element projEl = apc.getProjectElement();
        if (projEl == null) {
            return null;
        }
        String name = projEl.getAttribute("name");
        return name.length() > 0 ? name : null;
    }

    private static AntProjectCookie getAntProjectCookie(FileObject fo) {
        DataObject dob;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            err.notify(1, (Throwable)ex);
            return null;
        }
        if (!$assertionsDisabled && dob == null) {
            throw new AssertionError();
        }
        AntProjectCookie apc = (AntProjectCookie)dob.getCookie(AntProjectCookie.class);
        if (apc == null && fo.getMIMEType().equals("text/xml")) {
            try {
                apc = Util.forceParse(fo);
            }
            catch (IOException e) {
                err.notify(1, (Throwable)e);
            }
            catch (SAXException e) {
                err.log("Parse error in " + fo + ": " + e);
            }
        }
        return apc;
    }

    public static String getMergedHelpIDFragments(Project p) {
        Collection providers = p.getLookup().lookup(new Lookup.Template(HelpIDFragmentProvider.class)).allInstances();
        ArrayList<String> fragments = new ArrayList<String>();
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            HelpIDFragmentProvider provider = (HelpIDFragmentProvider)i.next();
            String fragment = provider.getHelpIDFragment();
            if (fragment == null || !VALIDATION.matcher(fragment).matches()) {
                throw new IllegalStateException("HelpIDFragmentProvider \"" + provider + "\" provided invalid help ID fragment \"" + fragment + "\".");
            }
            fragments.add(fragment);
        }
        Collections.sort(fragments);
        StringBuffer result = new StringBuffer();
        Iterator i2 = fragments.iterator();
        while (i2.hasNext()) {
            result.append((String)i2.next());
            if (!i2.hasNext()) continue;
            result.append('.');
        }
        return result.toString();
    }

    public static List getAntScriptTargetNames(FileObject fo) {
        Set allTargets;
        if (fo == null) {
            throw new IllegalArgumentException("Cannot call Util.getAntScriptTargetNames with null");
        }
        AntProjectCookie apc = Util.getAntProjectCookie(fo);
        if (apc == null) {
            return null;
        }
        try {
            allTargets = TargetLister.getTargets((AntProjectCookie)apc);
        }
        catch (IOException e) {
            err.notify(1, (Throwable)e);
            return null;
        }
        TreeSet<Object> targetNames = new TreeSet<Object>(Collator.getInstance());
        Iterator it = allTargets.iterator();
        while (it.hasNext()) {
            TargetLister.Target target = (TargetLister.Target)it.next();
            if (target.isOverridden() || target.isInternal()) continue;
            targetNames.add(target.getName());
        }
        return new ArrayList<Object>(targetNames);
    }

    private static AntProjectCookie forceParse(FileObject fo) throws IOException, SAXException {
        Document doc = XMLUtil.parse((InputSource)new InputSource(fo.getURL().toExternalForm()), (boolean)false, (boolean)true, (ErrorHandler)new ErrH(), null);
        return new TrivialAntProjectCookie(fo, doc);
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.ant.freeform");
        VALIDATION = Pattern.compile("([A-Za-z0-9])+");
    }

    private static final class TrivialAntProjectCookie
    implements AntProjectCookie.ParseStatus {
        private final FileObject fo;
        private final Document doc;

        public TrivialAntProjectCookie(FileObject fo, Document doc) {
            this.fo = fo;
            this.doc = doc;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public File getFile() {
            return FileUtil.toFile((FileObject)this.fo);
        }

        public Document getDocument() {
            return this.doc;
        }

        public Element getProjectElement() {
            return this.doc.getDocumentElement();
        }

        public boolean isParsed() {
            return true;
        }

        public Throwable getParseException() {
            return null;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class ErrH
    implements ErrorHandler {
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

