/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.core.PortInformation;
import org.netbeans.modules.websvc.core.ServiceInformation;
import org.netbeans.modules.websvc.core.client.nodes.WsCompileConfigCookie;
import org.netbeans.modules.websvc.wsdl.PortInformationHandler;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ServiceInformationImpl
implements ServiceInformation {
    private WeakReference portInformationHandlerRef = null;
    private DataObject wsdlDataObj;
    private boolean clientResolved;
    private boolean isClientWsdl;

    public ServiceInformationImpl(DataObject dobj) {
        this.wsdlDataObj = dobj;
    }

    public boolean isClientWsdl() {
        if (!this.clientResolved) {
            this.initClientWsdl();
            this.clientResolved = true;
        }
        return this.isClientWsdl;
    }

    private void initClientWsdl() {
        FileObject wsdlFolder;
        WebServicesClientSupport clientSupport;
        this.isClientWsdl = false;
        FileObject wsdlFO = this.wsdlDataObj.getPrimaryFile();
        FileObject parentFO = wsdlFO.getParent();
        if (parentFO != null && (clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)wsdlFO)) != null && (wsdlFolder = clientSupport.getWsdlFolder()) != null && wsdlFolder.equals(parentFO)) {
            FileObject mappingFile;
            this.isClientWsdl = true;
            FileObject ddFolder = wsdlFolder.getParent();
            if (ddFolder != null && (mappingFile = ddFolder.getFileObject(this.wsdlDataObj.getName() + "-mapping", "xml")) != null) {
                this.isClientWsdl = false;
            }
        }
    }

    public String getServicePackageName() {
        String packageName = "unknown";
        FileObject configFO = null;
        FileObject wsdlFO = this.wsdlDataObj.getPrimaryFile();
        FileObject parentFO = wsdlFO.getParent();
        if (parentFO != null && parentFO.isFolder()) {
            configFO = parentFO.getFileObject(wsdlFO.getName() + "-config", "xml");
        }
        if (configFO != null) {
            WsCompileConfigCookie configCookie = null;
            try {
                DataObject dobj = DataObject.find(configFO);
                if (dobj instanceof WsCompileConfigCookie) {
                    configCookie = (WsCompileConfigCookie)dobj;
                }
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (configCookie != null) {
                packageName = configCookie.getServicePackageName();
            }
        }
        return packageName;
    }

    public PortInformation getPortInformation() {
        return this.parseWsdl();
    }

    public List getServicePorts(String serviceName) {
        List portList;
        PortInformationHandler handler = this.parseWsdl();
        if (handler != null) {
            PortInformation.ServiceInfo serviceInfo = handler.getServiceInfo(serviceName);
            portList = serviceInfo.getPorts();
        } else {
            portList = Collections.EMPTY_LIST;
        }
        return portList;
    }

    public String[] getServiceNames() {
        PortInformationHandler handler = this.parseWsdl();
        String[] result = handler != null ? handler.getServiceNames() : new String[]{};
        return result;
    }

    public String getTargetNamespace() {
        PortInformationHandler handler = this.parseWsdl();
        String result = handler != null ? handler.getTargetNamespace() : null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortInformationHandler parseWsdl() {
        PortInformationHandler handler = null;
        ServiceInformationImpl serviceInformationImpl = this;
        synchronized (serviceInformationImpl) {
            if (this.portInformationHandlerRef != null && (handler = (PortInformationHandler)this.portInformationHandlerRef.get()) != null) {
                return handler;
            }
        }
        List result = Collections.EMPTY_LIST;
        FileObject primaryFile = this.wsdlDataObj.getPrimaryFile();
        handler = new PortInformationHandler();
        try {
            XMLReader xmlReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(primaryFile.getInputStream()));
            ServiceInformationImpl serviceInformationImpl2 = this;
            synchronized (serviceInformationImpl2) {
                this.portInformationHandlerRef = new WeakReference<PortInformationHandler>(handler);
            }
        }
        catch (SAXException ex) {
            handler = null;
        }
        catch (FileNotFoundException ex) {
            handler = null;
        }
        catch (IOException ex) {
            handler = null;
        }
        return handler;
    }
}

