/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.client;

import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.ws.client.dispatch.impl.encoding.DispatchSerializer;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.simpletype.EncoderUtils;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.client.SOAPXMLDecoder;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.FaultCode;
import com.sun.xml.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.ws.encoding.soap.message.FaultReason;
import com.sun.xml.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.ws.encoding.soap.message.FaultSubcode;
import com.sun.xml.ws.encoding.soap.message.SOAP12FaultInfo;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP12XMLDecoder
extends SOAPXMLDecoder {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch").toString());

    @Override
    protected DispatchSerializer getSerializerInstance() {
        return DispatchSerializer.SOAP_1_2;
    }

    @Override
    protected SOAPFaultInfo decodeFault(XMLStreamReader reader, InternalMessage internalMessage, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_SOAP_FAULT);
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_CODE);
        XMLStreamReaderUtil.nextElementContent(reader);
        QName faultcode = this.readFaultValue(reader);
        FaultCodeEnum codeValue = FaultCodeEnum.get(faultcode);
        if (codeValue == null) {
            throw new DeserializationException("unknown fault code:", faultcode.toString());
        }
        FaultSubcode subcode = null;
        if (reader.getEventType() == 1) {
            subcode = this.readFaultSubcode(reader);
        }
        FaultCode code = new FaultCode(codeValue, subcode);
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_CODE);
        XMLStreamReaderUtil.nextElementContent(reader);
        FaultReason reason = this.readFaultReason(reader);
        String node = null;
        String role = null;
        Object detail = null;
        QName name = reader.getName();
        if (name.equals(SOAP12Constants.QNAME_FAULT_NODE)) {
            node = reader.getText();
        }
        if (name.equals(SOAP12Constants.QNAME_FAULT_ROLE)) {
            XMLStreamReaderUtil.nextContent(reader);
            role = reader.getText();
            XMLStreamReaderUtil.nextElementContent(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        if (name.equals(SOAP12Constants.QNAME_FAULT_DETAIL)) {
            XMLStreamReaderUtil.nextElementContent(reader);
            detail = this.readFaultDetail(reader, messageInfo);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_SOAP_FAULT);
        XMLStreamReaderUtil.nextElementContent(reader);
        return new SOAP12FaultInfo(code, reason, node, role, detail);
    }

    protected QName readFaultValue(XMLStreamReader reader) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_VALUE);
        XMLStreamReaderUtil.nextContent(reader);
        String tokens = reader.getText();
        XMLStreamReaderUtil.next(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_VALUE);
        XMLStreamReaderUtil.nextElementContent(reader);
        String uri = "";
        tokens = EncoderUtils.collapseWhitespace(tokens);
        String prefix = XmlUtil.getPrefix(tokens);
        if (prefix != null && (uri = reader.getNamespaceURI(prefix)) == null) {
            throw new DeserializationException("xsd.unknownPrefix", prefix);
        }
        String localPart = XmlUtil.getLocalPart(tokens);
        return new QName(uri, localPart);
    }

    protected FaultSubcode readFaultSubcode(XMLStreamReader reader) {
        FaultSubcode code = null;
        QName name = reader.getName();
        if (name.equals(SOAP12Constants.QNAME_FAULT_SUBCODE)) {
            XMLStreamReaderUtil.nextElementContent(reader);
            QName faultcode = this.readFaultValue(reader);
            FaultSubcode subcode = null;
            if (reader.getEventType() == 1) {
                subcode = this.readFaultSubcode(reader);
            }
            code = new FaultSubcode(faultcode, subcode);
            XMLStreamReaderUtil.verifyReaderState(reader, 2);
            XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_SUBCODE);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        return code;
    }

    protected FaultReason readFaultReason(XMLStreamReader reader) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_REASON);
        XMLStreamReaderUtil.nextElementContent(reader);
        ArrayList<FaultReasonText> texts = new ArrayList<FaultReasonText>();
        this.readFaultReasonTexts(reader, texts);
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_REASON);
        XMLStreamReaderUtil.nextElementContent(reader);
        FaultReasonText[] frt = texts.toArray(new FaultReasonText[0]);
        return new FaultReason(frt);
    }

    protected void readFaultReasonTexts(XMLStreamReader reader, List<FaultReasonText> texts) {
        QName name = reader.getName();
        if (!name.equals(SOAP12Constants.QNAME_FAULT_REASON_TEXT)) {
            return;
        }
        String lang = reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang == null) {
            lang = "en";
        }
        XMLStreamReaderUtil.nextContent(reader);
        String text = null;
        if (reader.getEventType() == 4) {
            text = reader.getText();
            XMLStreamReaderUtil.next(reader);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, SOAP12Constants.QNAME_FAULT_REASON_TEXT);
        XMLStreamReaderUtil.nextElementContent(reader);
        Locale loc = new Locale(lang);
        texts.add(new FaultReasonText(text, loc));
        this.readFaultReasonTexts(reader, texts);
    }

    @Override
    protected void decodeHeader(XMLStreamReader reader, MessageInfo messageInfo, InternalMessage request) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (!"Header".equals(reader.getLocalName())) {
            return;
        }
        XMLStreamReaderUtil.verifyTag(reader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        while (reader.getEventType() == 1) {
            this.decodeHeaderElement(reader, messageInfo, request);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    @Override
    protected void decodeHeaderElement(XMLStreamReader reader, MessageInfo messageInfo, InternalMessage msg) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        Set<QName> knownHeaders = ((SOAPRuntimeModel)rtCtxt.getModel()).getKnownHeaders();
        QName name = reader.getName();
        if (knownHeaders != null && knownHeaders.contains(name)) {
            Object decoderInfo;
            QName headerName = reader.getName();
            if (msg.isHeaderPresent(name)) {
                this.raiseFault(this.getSenderFaultCode(), "Duplicate Header" + headerName);
            }
            if ((decoderInfo = rtCtxt.getDecoderInfo(name)) != null && decoderInfo instanceof JAXBBridgeInfo) {
                JAXBBridgeInfo bridgeInfo = (JAXBBridgeInfo)decoderInfo;
                bridgeInfo.deserialize(reader, bridgeContext);
                HeaderBlock headerBlock = new HeaderBlock(bridgeInfo);
                msg.addHeader(headerBlock);
            }
        } else {
            XMLStreamReaderUtil.skipElement(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
    }

    @Override
    protected QName getFaultTag() {
        return SOAP12Constants.QNAME_SOAP_FAULT;
    }

    @Override
    protected QName getBodyTag() {
        return SOAP12Constants.QNAME_SOAP_BODY;
    }

    @Override
    protected QName getEnvelopeTag() {
        return SOAP12Constants.QNAME_SOAP_ENVELOPE;
    }

    @Override
    protected QName getHeaderTag() {
        return SOAP12Constants.QNAME_SOAP_HEADER;
    }

    @Override
    protected QName getMUAttrQName() {
        return SOAP12Constants.QNAME_MUSTUNDERSTAND;
    }

    @Override
    protected QName getRoleAttrQName() {
        return SOAP12Constants.QNAME_ROLE;
    }

    @Override
    protected QName getFaultDetailTag() {
        return SOAP12Constants.QNAME_FAULT_DETAIL;
    }

    @Override
    public String getBindingId() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAP12Constants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAP12Constants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAP12Constants.FAULT_CODE_VERSION_MISMATCH;
    }
}

