/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeViewCellEditor
extends DefaultTreeCellEditor
implements CellEditorListener,
FocusListener,
MouseMotionListener {
    static final long serialVersionUID = -2171725285964032312L;
    boolean dndActive = false;
    private boolean cancelled = false;
    private boolean stopped = false;

    public TreeViewCellEditor(JTree tree) {
        super(tree, new DefaultTreeCellRenderer());
        if (tree.getSelectionCount() == 1) {
            this.lastPath = tree.getSelectionPath();
        }
        this.addCellEditorListener(this);
    }

    public void editingStopped(ChangeEvent e) {
        Node n;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        TreePath lastP = this.lastPath;
        if (lastP != null && (n = Visualizer.findNode(lastP.getLastPathComponent())) != null && n.canRename()) {
            String newStr = (String)this.getCellEditorValue();
            try {
                if (!n.getName().equals(newStr)) {
                    n.setName(newStr);
                }
            }
            catch (IllegalArgumentException exc) {
                boolean needToAnnotate = true;
                ErrorManager em = ErrorManager.getDefault();
                ErrorManager.Annotation[] ann = em.findAnnotations((Throwable)exc);
                if (ann != null && ann.length > 0) {
                    for (int i = 0; i < ann.length; ++i) {
                        String glm = ann[i].getLocalizedMessage();
                        if (glm == null || glm.equals("")) continue;
                        needToAnnotate = false;
                    }
                }
                if (needToAnnotate) {
                    String msg = NbBundle.getMessage((Class)TreeViewCellEditor.class, (String)"RenameFailed", (Object)n.getName(), (Object)newStr);
                    em.annotate((Throwable)exc, msg);
                }
                em.notify(256, (Throwable)exc);
            }
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.cancelled = true;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JTextField) {
            this.cancelled = true;
            this.cancelCellEditing();
        } else {
            super.actionPerformed(evt);
        }
    }

    public void focusLost(FocusEvent evt) {
        if (this.stopped || this.cancelled) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    protected TreeCellEditor createTreeCellEditor() {
        JTextField tf = new JTextField(){

            public void addNotify() {
                TreeViewCellEditor.this.stopped = (TreeViewCellEditor.this.cancelled = false);
                super.addNotify();
                this.requestFocus();
            }
        };
        tf.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 0);
        tf.addFocusListener(this);
        Ed ed = new Ed(tf);
        ed.setClickCountToStart(1);
        ed.getComponent().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TreeViewCellEditor.class, (String)"ACSD_TreeViewCellEditor"));
        ed.getComponent().getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)TreeViewCellEditor.class, (String)"ACSN_TreeViewCellEditor"));
        return ed;
    }

    public boolean isCellEditable(EventObject event) {
        if (event != null && event instanceof MouseEvent && (!SwingUtilities.isLeftMouseButton((MouseEvent)event) || ((MouseEvent)event).isPopupTrigger())) {
            return false;
        }
        if (this.lastPath != null) {
            Node n = Visualizer.findNode(this.lastPath.getLastPathComponent());
            if (n == null || !n.canRename()) {
                return false;
            }
        } else {
            return false;
        }
        if (this.dndActive) {
            return false;
        }
        return super.isCellEditable(event);
    }

    protected void determineOffset(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            this.renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, true);
            this.editingIcon = this.renderer.getIcon();
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : 0;
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    void setDnDActive(boolean dndActive) {
        if (!dndActive) {
            this.tree.removeMouseMotionListener(this);
        }
        this.dndActive = dndActive;
    }

    protected void setTree(JTree newTree) {
        if (newTree != this.tree && this.timer != null && this.timer.isRunning()) {
            this.tree.removeMouseMotionListener(this);
        }
        super.setTree(newTree);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        boolean b = this.checkContinueTimer(p);
        if (!b) {
            this.abortTimer();
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        boolean b = this.checkContinueTimer(p);
        if (!b) {
            this.abortTimer();
        }
    }

    private void abortTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.tree.removeMouseMotionListener(this);
        }
    }

    protected void startEditingTimer() {
        this.tree.addMouseMotionListener(this);
        super.startEditingTimer();
    }

    protected void prepareForEditing() {
        this.abortTimer();
        this.tree.removeMouseMotionListener(this);
        super.prepareForEditing();
    }

    private boolean checkContinueTimer(Point p) {
        Rectangle r = this.tree.getPathBounds(this.tree.getSelectionPath());
        if (r == null) {
            return false;
        }
        return r.contains(p);
    }

    class Ed
    extends DefaultCellEditor {
        static final long serialVersionUID = -6373058702842751408L;

        public Ed(JTextField tf) {
            super(tf);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Node ren = Visualizer.findNode(value);
            if (ren != null && ren.canRename()) {
                this.delegate.setValue(ren.getName());
            } else {
                this.delegate.setValue("");
            }
            TreeViewCellEditor.this.editingIcon = ((VisualizerNode)value).getIcon(expanded, false);
            ((JTextField)this.editorComponent).selectAll();
            return this.editorComponent;
        }
    }
}

