/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.lookup.InstanceContent;

class ActiveEditorDropDefaultProvider
implements InstanceContent.Convertor {
    private static ActiveEditorDropDefaultProvider instance = new ActiveEditorDropDefaultProvider();

    private ActiveEditorDropDefaultProvider() {
    }

    static ActiveEditorDropDefaultProvider getInstance() {
        return instance;
    }

    public Class type(Object obj) {
        if (obj instanceof String) {
            return ActiveEditorDrop.class;
        }
        return null;
    }

    public String id(Object obj) {
        return obj.toString();
    }

    public String displayName(Object obj) {
        return ((Class)obj).getName();
    }

    public Object convert(Object obj) {
        ActiveEditorDrop drop = null;
        if (obj instanceof String) {
            drop = this.getActiveEditorDrop((String)obj);
        }
        return drop;
    }

    private ActiveEditorDrop getActiveEditorDrop(String body) {
        ActiveEditorDropDefault drop = new ActiveEditorDropDefault(body);
        return drop;
    }

    private static class ActiveEditorDropDefault
    implements ActiveEditorDrop {
        String body;

        public ActiveEditorDropDefault(String body) {
            this.body = body;
        }

        public boolean handleTransfer(JTextComponent targetComponent) {
            if (targetComponent == null) {
                return false;
            }
            try {
                Document doc = targetComponent.getDocument();
                Caret caret = targetComponent.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                doc.remove(p0, p1 - p0);
                int start = caret.getDot();
                doc.insertString(start, this.body, null);
            }
            catch (BadLocationException ble) {
                return false;
            }
            return true;
        }
    }
}

