/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openide.util.Utilities;

public final class TopologicalSortException
extends Exception {
    private Collection vertexes;
    private Map edges;
    private Set[] result;
    private int counter;
    private Stack dualGraph = new Stack();

    TopologicalSortException(Collection vertexes, Map edges) {
        this.vertexes = vertexes;
        this.edges = edges;
    }

    public final List partialSort() {
        Set[] all = this.topologicalSets();
        ArrayList res = new ArrayList(this.vertexes.size());
        for (int i = 0; i < all.length; ++i) {
            res.addAll(all[i]);
        }
        return res;
    }

    public final Set[] unsortableSets() {
        Set[] all = this.topologicalSets();
        ArrayList<Set> unsort = new ArrayList<Set>();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].size() <= 1 && all[i] instanceof HashSet) continue;
            unsort.add(all[i]);
        }
        return unsort.toArray(new Set[0]);
    }

    public final void printStackTrace(PrintWriter w) {
        w.print("TopologicalSortException - Collection: ");
        w.print(this.vertexes);
        w.print(" with edges ");
        w.print(this.edges);
        w.println(" cannot be sorted");
        Set[] bad = this.unsortableSets();
        for (int i = 0; i < bad.length; ++i) {
            w.print(" Conflict #");
            w.print(i);
            w.print(": ");
            w.println(bad[i]);
        }
        super.printStackTrace(w);
    }

    public final void printStackTrace(PrintStream s) {
        PrintWriter w = new PrintWriter(s);
        this.printStackTrace(w);
        w.flush();
    }

    public final Set[] topologicalSets() {
        if (this.result != null) {
            return this.result;
        }
        HashMap vertexInfo = new HashMap();
        this.counter = 0;
        Iterator<Object> it = this.vertexes.iterator();
        while (it.hasNext()) {
            this.constructDualGraph(this.counter, it.next(), vertexInfo);
        }
        HashMap objectsToSets = new HashMap();
        ArrayList sets = new ArrayList();
        while (!this.dualGraph.isEmpty()) {
            Vertex v = (Vertex)this.dualGraph.pop();
            if (v.visited) continue;
            Set<Object> set = new HashSet();
            this.visitDualGraph(v, set);
            if (set.size() == 1 && v.edgesFrom.contains(v)) {
                set = Collections.singleton(v.object);
            }
            sets.add(set);
            it = set.iterator();
            while (it.hasNext()) {
                objectsToSets.put(it.next(), set);
            }
        }
        HashMap edgesBetweenSets = new HashMap();
        it = this.edges.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Collection leadsTo = (Collection)entry.getValue();
            if (leadsTo == null || leadsTo.isEmpty()) continue;
            Set from = (Set)objectsToSets.get(entry.getKey());
            ArrayList<Set> setsTo = (ArrayList<Set>)edgesBetweenSets.get(from);
            if (setsTo == null) {
                setsTo = new ArrayList<Set>();
                edgesBetweenSets.put(from, setsTo);
            }
            Iterator convert = leadsTo.iterator();
            while (convert.hasNext()) {
                Set to = (Set)objectsToSets.get(convert.next());
                if (from == to) continue;
                setsTo.add(to);
            }
        }
        try {
            this.result = Utilities.topologicalSort(sets, edgesBetweenSets).toArray(new Set[0]);
        }
        catch (TopologicalSortException ex) {
            throw new IllegalStateException("Cannot happen");
        }
        return this.result;
    }

    private Vertex constructDualGraph(int counter, Object vertex, HashMap vertexInfo) {
        Vertex info = (Vertex)vertexInfo.get(vertex);
        if (info != null) {
            return info;
        }
        info = new Vertex(vertex, counter++);
        vertexInfo.put(vertex, info);
        Collection c = (Collection)this.edges.get(vertex);
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Vertex next = this.constructDualGraph(counter, it.next(), vertexInfo);
                next.edgesFrom.add(info);
            }
        }
        info.y = counter++;
        this.dualGraph.push(info);
        return info;
    }

    private void visitDualGraph(Vertex vertex, Collection visited) {
        if (vertex.visited) {
            return;
        }
        visited.add(vertex.object);
        vertex.visited = true;
        Iterator it = vertex.edges();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            this.visitDualGraph(v, visited);
        }
    }

    private static final class Vertex
    implements Comparable {
        public Object object;
        public List edgesFrom = new ArrayList();
        public final int x;
        public int y;
        public boolean sorted;
        public boolean visited;

        public Vertex(Object obj, int x) {
            this.x = x;
            this.object = obj;
        }

        public Iterator edges() {
            if (!this.sorted) {
                Collections.sort(this.edgesFrom);
                this.sorted = true;
            }
            return this.edgesFrom.iterator();
        }

        public int compareTo(Object o) {
            Vertex v = (Vertex)o;
            return v.y - this.y;
        }
    }
}

