/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspLoader;
import org.netbeans.modules.web.core.jsploader.JspParserAccess;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.modules.web.core.palette.JSPPaletteFactory;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableOpenSupport;

class BaseJspEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie.Observable,
OpenCookie,
LineCookie,
CloseCookie,
PrintCookie {
    private static final int AUTO_PARSING_DELAY = 2000;
    private Timer timer;
    private String encoding;
    private static String defaulEncoding = "UTF-8";

    public BaseJspEditorSupport(JspDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new BaseJspEnv(obj));
        DataObject data = this.getDataObject();
        if (data != null && data instanceof JspDataObject) {
            this.setMIMEType(JspLoader.getMimeType((JspDataObject)data));
        }
        this.initialize();
    }

    public boolean close() {
        TagLibParseSupport sup = (TagLibParseSupport)this.getDataObject().getCookie(TagLibParseSupport.class);
        if (sup != null) {
            sup.cancelParsingTask();
        }
        return super.close();
    }

    private void initialize() {
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final TagLibParseSupport sup = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                if (sup != null && WebModule.getWebModule((FileObject)BaseJspEditorSupport.this.getDataObject().getPrimaryFile()) != null) {
                    sup.autoParse().addTaskListener(new TaskListener(){

                        public void taskFinished(Task t) {
                            BaseJspEditorSupport.this.notifyParsingDone(sup);
                        }
                    });
                }
            }
        });
        this.timer.setInitialDelay(2000);
        this.timer.setRepeats(false);
        final DocumentListener docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.change(e);
            }

            public void changedUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
                this.change(e);
            }

            private void change(DocumentEvent e) {
                BaseJspEditorSupport.this.restartTimer(false);
                TagLibParseSupport sup = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                if (sup != null) {
                    sup.setDocumentDirty(true);
                }
            }
        };
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (BaseJspEditorSupport.this.isDocumentLoaded() && BaseJspEditorSupport.this.getDocument() != null) {
                    BaseJspEditorSupport.this.getDocument().addDocumentListener(docListener);
                }
            }
        });
        this.encoding = null;
        JspParserAccess.getJspParserWM(this.getWebModule(this.getDataObject().getPrimaryFile())).addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("libraries".equals(propName) || "package_roots".equals(propName)) {
                    BaseJspEditorSupport.this.restartTimer(false);
                }
            }
        });
    }

    private WebModule getWebModule(FileObject fo) {
        FileObject wmRoot;
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null && (wmRoot = wm.getDocumentBase()) != null && (fo == wmRoot || FileUtil.isParentOf((FileObject)wmRoot, (FileObject)fo))) {
            return wm;
        }
        return null;
    }

    private void restartTimer(boolean onlyIfRunning) {
        if (onlyIfRunning && !this.timer.isRunning()) {
            return;
        }
        int delay = 2000;
        if (delay > 0) {
            this.timer.setInitialDelay(delay);
            this.timer.restart();
        }
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    public void open() {
        long a = System.currentTimeMillis();
        this.encoding = this.getObjectEncoding(false, false);
        if (!this.isSupportedEncoding(this.encoding)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadEncodingDuringLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaulEncoding}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        Reader reader = null;
        this.encoding = this.getObjectEncoding(false, true);
        if (!this.isSupportedEncoding(this.encoding)) {
            this.encoding = defaulEncoding;
        }
        try {
            reader = new InputStreamReader(stream, this.encoding);
            kit.read(reader, (Document)doc, 0);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        Writer wr = null;
        if (this.encoding == null) {
            this.encoding = this.getObjectEncoding(false, true);
        }
        try {
            if (!this.isSupportedEncoding(this.encoding)) {
                this.encoding = defaulEncoding;
            }
            wr = new OutputStreamWriter(stream, this.encoding);
            kit.write(wr, (Document)doc, 0, doc.getLength());
        }
        finally {
            if (wr != null) {
                wr.close();
            }
        }
    }

    protected void notifyClose() {
    }

    protected void notifyParsingDone(TagLibParseSupport sup) {
        if (sup.isDocumentDirty()) {
            this.restartTimer(false);
        }
    }

    protected boolean notifyModified() {
        boolean notify = super.notifyModified();
        if (!notify) {
            return false;
        }
        JspDataObject obj = (JspDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    BaseJspEditorSupport.this.saveDocument();
                }
            });
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JspDataObject obj = (JspDataObject)this.getDataObject();
        obj.removeSaveCookie();
    }

    protected String getObjectEncoding(boolean useEditor) {
        return this.getObjectEncoding(useEditor, false);
    }

    protected String getObjectEncoding(boolean useEditor, boolean useCache) {
        return useCache ? ((TagLibParseSupport)this.getDataObject().getCookie(TagLibParseSupport.class)).getCachedOpenInfo(false, useEditor).getEncoding() : ((JspDataObject)this.getDataObject()).getFileEncoding(useEditor).trim();
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true, true);
    }

    protected void saveDocumentIfNecessary(boolean parse) throws IOException {
        this.saveDocument(parse, false);
    }

    private void saveDocument(boolean parse, boolean forceSave) throws IOException {
        if (forceSave || this.isModified()) {
            TagLibParseSupport sup;
            this.encoding = this.getObjectEncoding(true);
            if (!this.isSupportedEncoding(this.encoding)) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaulEncoding}), 0, 2);
                nd.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                    return;
                }
            } else {
                try {
                    CharsetEncoder coder = Charset.forName(this.encoding).newEncoder();
                    if (!coder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding}), 0, 2);
                        nd.setValue(NotifyDescriptor.NO_OPTION);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            super.saveDocument();
            if (parse && (sup = (TagLibParseSupport)this.getDataObject().getCookie(TagLibParseSupport.class)) != null) {
                sup.prepare();
            }
        }
    }

    protected CloneableEditor createCloneableEditor() {
        return new BaseJspEditor(this);
    }

    public static class BaseJspEditor
    extends CloneableEditor {
        public static final String JSP_MIME_TYPE = "text/x-jsp";
        public static final String TAG_MIME_TYPE = "text/x-tag";
        private TagLibParseSupport taglibParseSupport;
        private InstanceContent instanceContent;
        CaretListener caretListener;

        public BaseJspEditor() {
        }

        public boolean isXmlSyntax(DataObject dataObject) {
            FileObject fileObject;
            FileObject fileObject2 = fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
            if (fileObject == null) {
                return false;
            }
            return this.taglibParseSupport.getCachedOpenInfo(false, false).isXmlSyntax();
        }

        void associatePalette(BaseJspEditorSupport s) {
            DataObject dataObject = s.getDataObject();
            String mimeType = dataObject.getPrimaryFile().getMIMEType();
            this.instanceContent.add((Object)this.getActionMap());
            if (dataObject instanceof JspDataObject && (mimeType.equals(JSP_MIME_TYPE) || mimeType.equals(TAG_MIME_TYPE)) && !this.isXmlSyntax(dataObject)) {
                try {
                    PaletteController pc = JSPPaletteFactory.getPalette();
                    this.instanceContent.add((Object)pc);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public BaseJspEditor(BaseJspEditorSupport s) {
            super((CloneableEditorSupport)s);
            this.initialize();
        }

        protected void notifyParsingDone() {
        }

        private void initialize() {
            Node[] nodes = new Node[]{((DataEditorSupport)this.cloneableEditorSupport()).getDataObject().getNodeDelegate()};
            this.instanceContent = new InstanceContent();
            this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.instanceContent), nodes[0].getLookup()}));
            this.setActivatedNodes(nodes);
            this.caretListener = new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ((BaseJspEditorSupport)BaseJspEditor.this.cloneableEditorSupport()).restartTimer(true);
                }
            };
            this.taglibParseSupport = (TagLibParseSupport)((BaseJspEditorSupport)this.cloneableEditorSupport()).getDataObject().getCookie(TagLibParseSupport.class);
        }

        protected void componentActivated() {
            if (this.getEditorPane() != null) {
                this.getEditorPane().addCaretListener(this.caretListener);
                super.componentActivated();
            }
            ((BaseJspEditorSupport)this.cloneableEditorSupport()).restartTimer(false);
            this.taglibParseSupport.setEditorOpened(true);
            this.associatePalette((BaseJspEditorSupport)this.cloneableEditorSupport());
        }

        protected void componentDeactivated() {
            this.getEditorPane().removeCaretListener(this.caretListener);
            super.componentDeactivated();
            this.taglibParseSupport.setEditorOpened(false);
        }

        protected boolean closeLast() {
            if (!super.closeLast()) {
                return false;
            }
            ((BaseJspEditorSupport)this.cloneableEditorSupport()).notifyClose();
            return true;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
            this.associatePalette((BaseJspEditorSupport)this.cloneableEditorSupport());
        }
    }

    public static class BaseJspEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public BaseJspEnv(JspDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (BaseJspEditorSupport)this.getDataObject().getCookie(BaseJspEditorSupport.class);
        }
    }
}

